% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewnorm.R
\name{dskewnorm}
\alias{dskewnorm}
\alias{pskewnorm}
\alias{qskewnorm}
\alias{rskewnorm}
\title{Skew-Normal Distribution}
\usage{
dskewnorm(x, mean = 0, sd = 1, shape = 0, log = FALSE)

pskewnorm(q, mean = 0, sd = 1, shape = 0)

qskewnorm(p, mean = 0, sd = 1, shape = 0)

rskewnorm(n = 1, mean = 0, sd = 1, shape = 0)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{mean}{A numeric vector of the means.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{shape}{A numeric vector of values.}

\item{log}{A flag specifying whether to return the log-transformed value.}

\item{q}{A vector of quantiles.}

\item{p}{A vector of probabilities.}

\item{n}{A non-negative whole number of the number of random samples to
generate.}
}
\value{
\code{dskewnorm} gives the density, \code{pskewnorm} gives the distribution function, \code{qskewnorm} gives the quantile function, and \code{rskewnorm} generates random deviates.
\code{pskewnorm} and \code{qskewnorm} use the lower tail probability.
}
\description{
Skew-Normal Distribution
}
\examples{
dskewnorm(x = -2:2, mean = 0, sd = 1, shape = 0.1)
dskewnorm(x = -2:2, mean = 0, sd = 1, shape = -1)
qskewnorm(p = c(0.1, 0.4), mean = 0, sd = 1, shape = 0.1)
qskewnorm(p = c(0.1, 0.4), mean = 0, sd = 1, shape = -1)
pskewnorm(q = -2:2, mean = 0, sd = 1, shape = 0.1)
pskewnorm(q = -2:2, mean = 0, sd = 1, shape = -1)
rskewnorm(n = 3, mean = 0, sd = 1, shape = 0.1)
rskewnorm(n = 3, mean = 0, sd = 1, shape = -1)
}
\concept{skewnorm}
