% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpd-distribution.R
\name{GPD}
\alias{GPD}
\alias{dgpd}
\alias{pgpd}
\alias{qgpd}
\alias{rgpd}
\title{Generalized Pareto distribution}
\usage{
dgpd(x, mu = 0, sigma = 1, xi = 0, log = FALSE)

pgpd(q, mu = 0, sigma = 1, xi = 0, lower.tail = TRUE, log.p = FALSE)

qgpd(p, mu = 0, sigma = 1, xi = 0, lower.tail = TRUE, log.p = FALSE)

rgpd(n, mu = 0, sigma = 1, xi = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma, xi}{location, scale, and shape parameters. Scale must be positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the generalized Pareto distribution.
}
\details{
Probability density function
\deqn{ f(x) = \left\{\begin{array}{ll}
\frac{1}{\sigma} \left(1+\xi \frac{x-\mu}{\sigma}\right)^{-(\xi+1)/\xi} & \xi \neq 0 \\
\frac{1}{\sigma} \exp\left(-\frac{x-\mu}{\sigma}\right)                 & \xi = 0
\end{array}\right.
}{
f(x) = [if \xi != 0:] (1+\xi*(x-\mu)/\sigma)^{-(\xi+1)/\xi}/\sigma
       [else:] exp(-(x-\mu)/\sigma)/\sigma
}

Cumulative distribution function
\deqn{ F(x) = \left\{\begin{array}{ll}
1-\left(1+\xi \frac{x-\mu}{\sigma}\right)^{-1/\xi} & \xi \neq 0 \\
1-\exp\left(-\frac{x-\mu}{\sigma}\right)           & \xi = 0
\end{array}\right.
}{
F(x) = [if \xi != 0:] 1-(1+\xi*(x-\mu)/\sigma)^{-1/\xi}
       [else:] 1-exp(-(x-\mu)/\sigma)
}

Quantile function
\deqn{ F^{-1}(x) = \left\{\begin{array}{ll}
\mu + \sigma \frac{(1-p)^{-\xi}-1}{\xi} & \xi \neq 0 \\
\mu - \sigma \log(1-p)                  & \xi = 0
\end{array}\right.
}{
F^-1(x) = [if \xi != 0:] \mu + \sigma * ((1-p)^{-\xi}-1)/\xi
          [else:] \mu - \sigma * log(1-p)
}
}
\examples{

x <- rgpd(1e5, 5, 2, .1)
hist(x, 100, freq = FALSE, xlim = c(0, 50))
curve(dgpd(x, 5, 2, .1), 0, 50, col = "red", add = TRUE, n = 5000)
hist(pgpd(x, 5, 2, .1))
plot(ecdf(x))
curve(pgpd(x, 5, 2, .1), 0, 50, col = "red", lwd = 2, add = TRUE)

}
\references{
Coles, S. (2001). An Introduction to Statistical Modeling of Extreme Values.
Springer.
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
