% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate-hypergeometric-distribution.R
\name{MultiHypergeometric}
\alias{MultiHypergeometric}
\alias{dmvhyper}
\alias{rmvhyper}
\title{Multivariate hypergeometric distribution}
\usage{
dmvhyper(x, n, k, log = FALSE)

rmvhyper(nn, n, k)
}
\arguments{
\item{x}{\eqn{m}-column matrix of quantiles.}

\item{n}{\eqn{m}-length vector or \eqn{m}-column matrix
of numbers of balls in \eqn{m} colors.}

\item{k}{the number of balls drawn from the urn.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{nn}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the multivariate hypergeometric distribution.
}
\details{
Probability mass function
\deqn{
f(x) = \frac{\prod_{i=1}^m {n_i \choose x_i}}{{N \choose k}}
}{
f(x) = prod(choose(n, x)) / choose(N, k)
}

The multivariate hypergeometric distribution is generalization of
hypergeometric distribution. It is used for sampling \emph{without} replacement
\eqn{k} out of \eqn{N} marbles in \eqn{m} colors, where each of the colors appears
\eqn{n_i}{n[i]} times. Where \eqn{k=\sum_{i=1}^m x_i}{k=sum(x)},
\eqn{N=\sum_{i=1}^m n_i}{N=sum(n)} and \eqn{k \le N}{k<=N}.
}
\examples{

# Generating 10 random draws from multivariate hypergeometric
# distribution parametrized using a vector

rmvhyper(10, c(10, 12, 5, 8, 11), 33)

}
\references{
Gentle, J.E. (2006). Random number generation and Monte Carlo methods. Springer.
}
\seealso{
\code{\link[stats]{Hypergeometric}}
}
\concept{
Multivariate

Discrete
}
\keyword{distribution}
