% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lomax-distribution.R
\name{Lomax}
\alias{Lomax}
\alias{dlomax}
\alias{plomax}
\alias{qlomax}
\alias{rlomax}
\title{Lomax distribution}
\usage{
dlomax(x, lambda, kappa, log = FALSE)

plomax(q, lambda, kappa, lower.tail = TRUE, log.p = FALSE)

qlomax(p, lambda, kappa, lower.tail = TRUE, log.p = FALSE)

rlomax(n, lambda, kappa)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda, kappa}{positive valued parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Lomax distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{\lambda \kappa}{(1+\lambda x)^{\kappa+1}}
}{
f(x) = \lambda*\kappa / (1+\lambda*x)^(\kappa+1)
}

Cumulative distribution function
\deqn{
F(x) = 1-(1+\lambda x)^{-\kappa}
}{
F(x) = 1-(1+\lambda*x)^-\kappa
}

Quantile function
\deqn{
F^{-1}(p) = \frac{(1-p)^{-1/\kappa} -1}{\lambda}
}{
F^-1(p) = ((1-p)^(-1/\kappa)-1) / \lambda
}
}
\examples{

x <- rlomax(1e5, 5, 16)
xx <- seq(-100, 100, by = 0.001)
hist(x, 100, freq = FALSE)
lines(xx, dlomax(xx, 5, 16), col = "red")
hist(plomax(x, 5, 16))
plot(ecdf(x))
lines(xx, plomax(xx, 5, 16), col = "red", lwd = 2)

}
\keyword{distribution}
