% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomialEF.R
\name{binomialEF}
\alias{binomialEF}
\title{Additional Binomial Links For Generalized Linear Models}
\usage{
binomialEF(link = "loglog", alpha = 1)
}
\arguments{
\item{link}{name of link function. One of loglog, logc, identity, or  odds-power (Default: loglog)}

\item{alpha}{power for odds-power link. Not used otherwise. (Default: 1)}
}
\value{
An object of class "family" (which has a concise print method). This is a list with elements


\itemize{
  \item family: character: the family name.
  \item link: character: the link name.
  \item linkfun: function: the link.
  \item linkinv: function: the inverse of the link function.
  \item variance: function: the variance as a function of the mean.
  \item dev.resids function giving the deviance for each observation as a function of (y, mu, wt),
        used by the \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/glm.summaries.html}{residuals}
        method when computing deviance residuals.
  \item aic: function giving the AIC value if appropriate (but NA for the quasi- families).
        More precisely, this function returns -2 ll + 2 s, where ll is the log-likelihood and s
        is the number of estimated scale parameters. Note that the penalty term for the location
        parameters (typically the “regression coefficients”) is added elsewhere, e.g., in
        \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/glm.html}{glm.fit}()
        or \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/AIC.html}{AIC}(),
        see the AIC example in \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/glm.html}{glm}.
        See \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/logLik.html}{logLik}
        for the assumptions made about the dispersion parameter.
  \item initialize: expression. This needs to set up whatever data objects are needed for the family
        as well as n (needed for AIC in the binomial family) and mustart (See
        \href{https://stat.ethz.ch/R-manual/R-devel/RHOME/library/stats/html/glm.html}{glm})
  \item validmu: logical function. Returns TRUE if a mean vector mu is within the domain of variance.
  \item valideta: logical function. Returns TRUE if a linear predictor eta is within the domain of linkinv.
  \item simulate: (optional) function simulate(object, nsim) to be called by the "lm" method of
        \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/simulate.html}{simulate}.
        It will normally return a matrix with nsim columns and one row for each fitted value,
        but it can also return a list of length nsim. Clearly this will be missing for ‘quasi-’ families.
        }
}
\description{
Additional Binomial Links For Generalized Linear Models
}
\details{
family is a generic function with methods for classes "glm" and "lm".

The loglog link works well for many datasets. The range of the link is negative
infinity to positive infinity. For all other links, this is not true. This can cause a failure to converge in R's
glm function. If this happens, the link does not work well for the training data. Try another link.
}
\examples{
library(stats)
library(extendedFamily)

# loglog example
data(heart)
model <- glm(
  formula = death ~ anterior + hcabg +
    kk2 + kk3 + kk4 + age2 + age3 + age4,
  data = heart,
  family = binomialEF(link = "loglog")
)
}
