% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure_functions.R
\name{expSize}
\alias{expSize}
\title{Estimate size of exposure data frame}
\usage{
expSize(records, type = "PY", lower_year = NULL, upper_year = NULL)
}
\arguments{
\item{records}{File containing a unique policy key with start and end dates.}

\item{type}{Creates policy year rows for the default type = "PY".
Creates policy month rows for type = "PM". Many other variations on this.}

\item{lower_year}{A lower year for truncation to reduce calculation time and output size.}

\item{upper_year}{An upper year for truncation to reduce calculation time and output size.}
}
\value{
An upper bound for the number of rows used in the calculation of an exposure frame.
}
\description{
This function takes a records file and the same arguments as the addExposures function to
estimate the size of the output created. The upper bound is pretty reasonable. The idea with this function
is that it enables users to determine if they can reasonably perform an operation on their computer.
}
\examples{
addExposures(records)
}
