% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.4-plMonteCarlo.R
\name{plMonteCarlo}
\alias{plMonteCarlo}
\title{Monte Carlo Cross-Validation}
\usage{
plMonteCarlo(array, B = 10, ctrlSS, ctrlFS = NULL, ctrlGS, ctrlMS = NULL,
  save = FALSE)
}
\arguments{
\item{array}{Specifies the \code{ExprsArray} object to undergo cross-validation.}

\item{B}{A numeric scalar. The number of times to \code{split} the data.}

\item{ctrlSS}{Arguments handled by \code{\link{ctrlSplitSet}}.}

\item{ctrlFS}{A list of arguments handled by \code{\link{ctrlFeatureSelect}}.}

\item{ctrlGS}{Arguments handled by \code{\link{ctrlGridSearch}}.}

\item{ctrlMS}{Arguments handled by \code{\link{ctrlModSet}}. Optional.}

\item{save}{A logical scalar. Toggles whether to save randomly split
training and validation sets.}
}
\value{
An \code{\link{ExprsPipeline-class}} object.
}
\description{
Perform Monte Carlo style cross-validation.
}
\details{
Analogous to how \code{\link{plGrid}} manages multiple \code{build} and
 \code{predict} tasks, one can think of \code{plMonteCarlo} as managing
 multiple \code{pl} tasks.

Specifically, \code{plMonteCarlo} will call the provided \code{split}
 function (via \code{ctrlSS}) some \code{B} times, perform all
 feature selection tasks (listed via \code{ctrlFS}) on each split of
 the data, and execute the \code{pl} function (via \code{ctrlGS})
 using the bootstrapped set.

To perform multiple feature selection tasks, supply a list of multiple
 \code{\link{ctrlFeatureSelect}} argument wrappers to \code{ctrlFS}.
 To reduce the results of \code{plMonteCarlo} to a single performance metric,
 you can feed the returned \code{ExprsPipeline} object through the helper
 function \code{\link{calcMonteCarlo}}.

When embedding another \code{plMonteCarlo} or \code{plNested} call within
 this function (i.e., via \code{ctrlGS}), outer-fold model performance
 will force \code{aucSkip = TRUE} and \code{plotSkip = TRUE}.
}
\examples{
\dontrun{
require(golubEsets)
data(Golub_Merge)
array <- arrayEset(Golub_Merge, colBy = "ALL.AML", include = list("ALL", "AML"))
array <- modFilter(array, 20, 16000, 500, 5) # pre-filter Golub ala Deb 2003
array <- modTransform(array) # lg transform
array <- modNormalize(array, c(1, 2)) # normalize gene and subject vectors
ss <- ctrlSplitSet(func = "splitStratify", percent.include = 67, colBy = NULL)
fs <- list(ctrlFeatureSelect(func = "fsStats", top = 0, how = "t.test"),
           ctrlFeatureSelect(func = "fsPrcomp", top = 50))
gs <- ctrlGridSearch(func = "plGrid", how = "buildSVM", top = c(2, 3, 4), fold = 10,
                     kernel = c("linear", "radial"), cost = 10^(-3:3), gamma = 10^(-3:3))
boot <- plMonteCarlo(array, B = 3, ctrlSS = ss, ctrlFS = fs, ctrlGS = gs)
}
}
