% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurtosis.R
\name{kurtosis}
\alias{kurtosis}
\title{Kurtosis}
\usage{
kurtosis(vector = NULL, unbiased = TRUE)
}
\arguments{
\item{vector}{a numeric vector}

\item{unbiased}{logical. If \code{unbiased = TRUE}, the unbiased
estimate of the population kurtosis will be calculated.
If \code{unbiased = FALSE}, the biased estimate of the population
kurtosis will be calculated. By default, \code{unbiase = TRUE}.}
}
\value{
a numeric value, i.e., kurtosis of the given vector
}
\description{
Calculate kurtosis of the sample using a formula for either the
(1) biased estimator or (2) an unbiased estimator of the
population kurtosis. Formulas were taken from DeCarlo (1997),
\doi{10.1037/1082-989X.2.3.292}
}
\examples{
# calculate the unbiased estimator (e.g., kurtosis value that
# Excel 2016 will produce)
exploratory::kurtosis(c(1, 2, 3, 4, 5, 10))
# calculate the biased estimator (e.g., kurtosis value that
# R Package 'moments' will produce)
exploratory::kurtosis(c(1, 2, 3, 4, 5, 10), unbiased = FALSE)
# compare with kurtosis from 'moments' package
moments::kurtosis(c(1, 2, 3, 4, 5, 10))
}
