% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_poi_list}
\alias{get_poi_list}
\title{List of points of intersection}
\usage{
get_poi_list(
  data,
  batch_vbl,
  model_list,
  sl,
  srch_range,
  mode = "minimal",
  alpha = 0.05,
  ivl = "confidence",
  ivl_type = "one.sided",
  ivl_side = "lower",
  ...
)
}
\arguments{
\item{data}{The data frame that was used for fitting the models of parameter
\code{model_list}.}

\item{batch_vbl}{A character string that specifies the column in \code{data}
with the grouping information (i.e. a categorical variable) for the
differentiation of the observations of the different batches.}

\item{model_list}{A list of regression models of different type. Usually,
it is a list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids}, where the first three elements contain
\sQuote{\code{lm}} objects of the \dQuote{common intercept / common slope}
(\code{cics}), \dQuote{different intercept / common slope} (\code{dics})
and \dQuote{different intercept / different slope} (\code{dids.pmse}) type.
The fourth element with the label \code{dids} is usually a list of the
\sQuote{\code{lm}} objects that is obtained from fitting a regression
model to the data of each level of the categorical variable separately.
The \code{dids.pmse} model differs from the \code{dids} model in that it
is a model with the categorical variable as a fixed main effect and with
an interaction term of the categorical variable with the time variable,
i.e. a model where the mean square error is pooled across batches (thus
the \dQuote{pmse} suffix meaning \dQuote{pooled mean square error}). The
\code{cics}, \code{dics} and \code{dids.pmse} elements are \code{NA} if
data of only a single batch is available.}

\item{sl}{A numeric variable that specifies the \dQuote{specification limit}
(SL). Another kind of acceptance criterion may be regarded as SL.}

\item{srch_range}{A vector of length \code{2} that specifies the endpoints
of the (time) range within which the minimum distance is expected.}

\item{mode}{A character string of either \code{"minimal"} or \code{"all"},
that specifies if only the minimal distance of a factor regression model
is returned or if the distances of all lines belonging to the different
factor levels is returned. The default is \code{"minimal"}.}

\item{alpha}{A numeric value between 0 and 1 that specifies the significance
level for the calculation of confidence or prediction intervals. The
default is \code{0.05}.}

\item{ivl}{A character string of either \code{"confidence"} or
\code{"prediction"} that specifies the type of interval of interest.
The default is \code{"confidence"}.}

\item{ivl_type}{A character string that specifies if a \dQuote{one sided}
or a \dQuote{two sided} interval should be calculated, i.e. either
\code{"one.sided"} or \code{"two.sided"}, respectively. The default is
\code{"one.sided"}.}

\item{ivl_side}{A character string that specifies if the specification
limit, given that the limit has only one side, is an \dQuote{upper} or a
\dQuote{lower} bound, i.e. it is specified as either \code{"upper"} or
\code{"lower"}, respectively. The default is \code{"lower"}. If the
specification has two boundaries, then this parameter specifies the
preferred side. If no side is preferred over the other, \code{"both"} can
be used.}

\item{...}{Additional named or unnamed arguments passed on to
\code{\link[stats]{uniroot}()}.}
}
\value{
A list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids} is returned. Each of them contains a named
vector of the POI values estimated for each batch and named accordingly.
}
\description{
The function \code{get_poi_list()} prepares a list of points of intersection
(POI) for multiple regression models using the \code{find_poi()} function.
}
\details{
The function \code{get_poi_list()} applies the \code{find_poi()}
function (find the \dQuote{point of intersection}) on all the models that
are provided.
}
\seealso{
\code{\link{get_model_list}}, \code{\link{find_poi}},
\code{\link{get_distance}}, \code{\link{get_osle_poi_list}},
\code{\link{expirest_osle}}, \code{\link{expirest_wisle}},
\code{\link[stats]{uniroot}}.
}
\keyword{internal}
