% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate_index}
\alias{evaluate_index}
\title{Evaluates a data.frame}
\usage{
evaluate_index(i, pheno)
}
\arguments{
\item{i}{Index}

\item{pheno}{Data.frame with information about the samples}
}
\value{
An array of three dimensions with the mean, standard deviation
(\code{\link[=sd]{sd()}}), and median absolute deviation (\code{\link[=mad]{mad()}}) of the numeric variables, the
entropy of the categorical and the number of \code{NA} by each subgroup.
}
\description{
Measures several indicators per group
}
\examples{
data(survey, package = "MASS")
index <- create_subset(nrow(survey), 50, 5)
ev_index <- evaluate_index(index, survey[, c("Sex", "Smoke")])
ev_index["entropy", , ]
}
\seealso{
If you have already an index you can use \code{\link[=use_index]{use_index()}}.

Other functions to evaluate samples: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_independence}()},
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_orig}()},
\code{\link{evaluate_sd}()}
}
\concept{functions to evaluate samples}
