% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_category.R
\name{evaluate_independence}
\alias{evaluate_independence}
\title{Compare independence by chisq.test}
\usage{
evaluate_independence(i, pheno)
}
\arguments{
\item{i}{Index of subsets.}

\item{pheno}{A data.frame with the information about the samples.}
}
\value{
Returns a vector with the p-values of the chisq.test between the
category and the subset.
}
\description{
Looks the independence between the categories and the batches.
}
\examples{
data(survey, package = "MASS")
index <- design(survey[, c("Sex", "Smoke", "Age")], size_subset = 50,
                iterations = 50)
# Note that numeric columns will be omitted:
evaluate_independence(index, survey[, c("Sex", "Smoke", "Age")])
}
\seealso{
Other functions to evaluate samples: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_index}()},
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_orig}()},
\code{\link{evaluate_sd}()}

Other functions to evaluate categories: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_na}()}
}
\concept{functions to evaluate categories}
\concept{functions to evaluate samples}
