% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_methods.R
\name{vcov.spm}
\alias{vcov.spm}
\title{Calculate Variance-Covariance Matrix for an \code{"spm"} object}
\usage{
\method{vcov}{spm}(object, maxima = c("sliding", "disjoint"),
  estimator = "all", ...)
}
\arguments{
\item{object}{and object of class \code{c("spm", "exdex")} returned from
\code{\link{spm}}.}

\item{maxima}{A character scalar specifying whether to return the
estimated variance of the estimator of the extremal index \eqn{\theta}
based on sliding maxima or on disjoint maxima.}

\item{estimator}{A character vector specifying which of the three variants
of the semiparametric maxima estimator to use: \code{"N2015", "BB2018"}
or \code{"BB2018b"}.  See \code{\link{spm}} for details.
If \code{estimator = "all"} then the
estimated variances of all variants are returned.}

\item{...}{Further arguments.  None are used.}
}
\value{
A 1 by 1 numeric matrix if \code{estimator = "N2015"} or
  \code{"BB2018"} and a vector of length 2 if \code{estimator = "both"},
  containing the estimated variance(s) of the estimator(s).
}
\description{
\code{vcov} method for class \code{c("spm", "exdex")}.
}
\references{
Northrop, P. J. (2015) An efficient semiparametric maxima
estimator of the extremal index. \emph{Extremes} \strong{18}(4), 585-603.
\url{https://doi.org/10.1007/s10687-015-0221-5}

Berghaus, B., Bucher, A. (2018) Weak convergence of a pseudo
maximum likelihood estimator for the extremal index. \emph{Ann. Statist.}
\strong{46}(5), 2307-2335. \url{https://doi.org/10.1214/17-AOS1621}
}
