% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_to_R.R
\name{excel_to_R}
\alias{excel_to_R}
\title{Convert excel object to data.frame}
\usage{
excel_to_R(excelObj)
}
\arguments{
\item{excelObj}{the json data retuned from excel table}
}
\description{
This function is used to excel data to data.frame. Can be used in shiny app to convert input json to data.frame
}
\examples{
if(interactive()){
 library(shiny)
 library(excelR)
 shinyApp(
   ui = fluidPage(excelOutput("table")),
   server = function(input, output, session) {
     output$table <-
       renderExcel(excelTable(data = head(iris)))
     observeEvent(input$table,{
       print(excel_to_R(input$table))
     })
   }
 )
}
}
