% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{lsumprod}
\alias{lsumprod}
\alias{latex_sumprod}
\alias{latex_sum}
\alias{latex_product}
\alias{latex_mean}
\alias{latex_var}
\alias{latex_bracket}
\alias{latex_pmsign}
\alias{lsum}
\alias{lprod}
\alias{lvec}
\alias{lmean}
\alias{lvar}
\alias{lbr}
\alias{lsgn}
\title{Supporting Functions for Math LaTeX Output}
\usage{
lsumprod(..., br = "(")

lsum(x)

lprod(x)

lvec(
  x,
  left = c("(", "[", "{", "|", "||", "<", "a", "c", "f"),
  right = NULL,
  collapse = ", "
)

lmean(x)

lvar(x, mu = NULL, br = "(")

lbr(x, br = c("(", "[", "{", "|", "||", "<", "a", "c", "f"), subset = NULL)

lsgn(x)

latex_sumprod(..., br = "(")

latex_sum(x)

latex_product(x)

latex_mean(x)

latex_var(x, mu = NULL, br = "(")

latex_bracket(
  x,
  br = c("(", "[", "{", "|", "||", "<", "a", "c", "f"),
  subset = NULL
)

latex_pmsign(x)
}
\arguments{
\item{...}{further input values}

\item{br, left, right}{character: which brackets to use. The possibilities are:
\itemize{
\item \code{(} (default) uses \verb{\\left(} and \verb{\\right(},
\item \code{[} use \verb{\\left[} and \verb{\\right]},
\item \code{\{} use \verb{\\left\\\{} and \verb{\\right\\\}},
\item \code{|}  use \verb{\\left|} and \verb{\\right|},
\item \code{||}  uses \verb{\\left\\|} and \verb{\\right\\|},
\item \code{<}, \code{a} use \verb{\\left\\langle} and \verb{\\right\\rangle},
\item \code{c}  use \verb{\\left\\lceil} and \verb{\\right\\rceil}, and
\item \code{f}  use \verb{\\left\\lfloor} and \verb{\\right\\rfloor}.
}}

\item{x}{numeric: input values}

\item{collapse}{character: an optional character string to separate the results (default: ', ')}

\item{mu}{numeric: population mean (default: \code{NULL})}

\item{subset}{logical: indicates which elements have brackets added (default: \code{NULL} = all elements starting with \code{-}); missing values are taken as false.}
}
\value{
A character.
}
\description{
\code{lsumprod} creates a latex printout of \eqn{\sum_i x_i y_i} with brackets if \eqn{x_i} or \eqn{y_i} starts with a \code{-}.

\code{lsum} creates a latex printout of \eqn{x} as sum.

\code{lprod} creates a latex printout of \eqn{x} as product.

\code{lvec} creates a latex printout of \eqn{x} as vector.

\code{lmean} creates a latex printout as \eqn{\frac{x_1+...+x_n}{n}}.

\code{lvar} creates a latex printout as \eqn{\frac{(x_1-xbar)^2+...+(x_n-xbar)^2}{n}}.

\code{lbr} creates a latex printout of \eqn{x} with brackets if \eqn{x} starts with a \code{-}.

\code{lsgn} creates a latex printout of \eqn{x} with a plus or minus at the beginning.
}
\examples{
lsumprod(-2:2, (1:5)/10)
lbr(-2:2)
lsum(-2:2)
lmean(-2:2)
lvec(-2:2)
lvec(-2:2, '[')
lvec(0:1, '(', ']')
}
