% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{ItemLift}
\alias{ItemLift}
\alias{ItemLift.default}
\alias{ItemLift.binary}
\title{Item Lift}
\usage{
ItemLift(U, na = NULL, Z = NULL, w = NULL)

\method{ItemLift}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{ItemLift}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A matrix of item lift values with exametrika class.
Each element (j,k) represents the lift value of item k given item j,
which indicates how much more likely item k is to be correct given that
item j was answered correctly.
}
\description{
The lift is a commonly used index in a POS data analysis.
The item lift of Item k to Item j is defined as follow:
\eqn{ l_{jk} = \frac{p_{k\mid j}}{p_k} }
This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate ItemLift using sample dataset J5S10
ItemLift(J5S10)
}
\references{
Brin, S., Motwani, R., Ullman, J., & Tsur, S. (1997). Dynamic itemset counting and
implication rules for market basket data. In Proceedings of ACM SIGMOD International Conference
on Management of Data (pp. 255–264). https://dl.acm.org/doi/10.1145/253262.253325
}
