% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operating_characteristics.R
\name{dlt_rate}
\alias{dlt_rate}
\title{Evaluation of the DLT rate}
\usage{
dlt_rate(dlt_matrix, trial = FALSE, target_rate = NULL, margin = NULL,
  digits = 2)
}
\arguments{
\item{dlt_matrix}{a matrix of the number of DLT for each step of the trial (column)
and for each trial (row).}

\item{trial}{a logical value indicating if the DLT rate for each trial should be returned.}

\item{target_rate}{a numerical value of the target rate of DLT.}

\item{margin}{a numerical value of the acceptable distance from the \code{target_rate}.}

\item{digits}{a numerical value indicating the number of digits.}
}
\value{
\code{trial} a numerical vector of the DLT rate for each trial.

\code{average} a numerical value of the average of DLT rate considering a batch of trials.

\code{upper} the percent of trials which the
\code{DLT rate > target_rate + margin} if \code{margin != NULL} and
\code{target_rate != NULL}.

\code{lower} the percent of trials which the
\code{DLT rate < target_rate - margin} if \code{margin != NULL} and
\code{target_rate != NULL}.

\code{interval} the percent of trials which the
\code{target_rate - margin < DLT rate < target_rate + margin} if \code{margin != NULL} and
\code{target_rate != NULL}.
}
\description{
Calculate the DLT rate for each trial, the average DLT rate, the percent
of trials which have \eqn{DLT rate > target_rate + margin}, the percent
of trials which have \eqn{DLT rate < target_rate - margin} and the percent
of trials which have \eqn{target_rate - margin < DLT rate < target_rate + margin}.
}
\examples{
\dontrun{
DLT <- 0
dose <- 30
step_zero <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
stop_rule_sim(step_zero)
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- ewoc_simulation(step_zero = step_zero,
                       n_sim = 1, sample_size = 2,
                       alpha_strategy = "increasing",
                       response_sim = response_sim,
                       stop_rule_sim = stop_rule_sim,
                       ncores = 2)
dlt_rate(sim$dlt_sim)
}

\dontrun{
DLT <- 0
dose <- 30
step_zero <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
stop_rule_sim(step_zero)
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- ewoc_simulation(step_zero = step_zero,
                       n_sim = 2, sample_size = 30,
                       alpha_strategy = "increasing",
                       response_sim = response_sim,
                       stop_rule_sim = stop_rule_sim,
                       ncores = 2)
dlt_rate(sim$dlt_sim)
}

}
