\name{mop}
\alias{mop}
\alias{mop.MOP}
\alias{mop.RBMOP}
\alias{mop.beta}
\alias{mop.rho}
\title{
Mean of order p (MOP) statistics for the extreme value index (EVI)
}
\description{
Mean of order p (MOP) statistics for the extreme value index (EVI).
}
\usage{
mop(X, k = 1, p = 0, method = c("MOP", "RBMOP"))
}

\arguments{
  \item{X}{
Data vector.
}
  \item{k}{
intermediate sequence, default is \code{k=1}.
}
  \item{p}{
mean order, default is \code{p=0}.
}
  \item{method}{
Method used, ("MOP", default) 
                  and reduced-bias MOP ("RBMOP").
}
}
\details{
This method performs a mean of order p (is real) (MOP) methodology for estimating extreme value index (EVI) for heavy tailed models. At \code{p=0} MOP estimator is equal to classical Hill estimator.
}


\references{
M.F. Brilhante, M.Ivette Gomes and Dinis Pestana. (2013). A simple generalisation of the Hill estimator
\emph{Computational Statistics and Data Analysis}, \bold{57}, 518-- 535.

J.Beran, D. Schell and M. Stehlik. (2013). The harmonic moment tail index estimator: asymptotic distribution and robustness  \emph{Ann Inst Stat Math},  Published Online.

M. Ivette Gomes, M.F. Brilhante and Dinis Pestana. (2013). New reduced-bias estimators of a positive extreme value index \emph{Submitted article}.
}
\author{
B G Manjunath \email{bgmanjunath@gmail.com}
}

\examples{
set.seed(1.2345) 

# generate random samples               
X = rfrechet(5000, loc = 0, scale = 1,shape = 1/0.5)

# estimate EVI 
mop(X,100, 0,"MOP")
}

\keyword{mean of order p}
\keyword{Hill estimator}
