% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{intervals}
\alias{intervals}
\title{Computation of prediction intervals from a trained ENNreg model}
\usage{
intervals(pred, level = 0.9, yt = NULL)
}
\arguments{
\item{pred}{Prediction object returned by function \code{\link{predict.ENNreg}}.}

\item{level}{Level of the prediction interval (between 0 and 1).}

\item{yt}{Optional vector of test response values.}
}
\value{
A list with four elements:
\describe{
\item{INTP}{Matrix (n,2) of probabilistic prediction intervals.}
\item{INTBel}{Matrix (n,2) of belief prediction intervals.}
\item{coverage.P}{Estimated coverage rate of the probabilistic intervals (if yt is provided).}
\item{coverage.Bel}{Estimated coverage rate of the belief intervals (if yt is provided).}
}
}
\description{
\code{intervals} computes probabilistic and belief prediction intervals from a prediction object
returned by function \code{\link{predict.ENNreg}}.
}
\examples{
library(MASS)
\donttest{
X<-as.matrix(scale(Boston[,1:13]))
y<-Boston[,14]
set.seed(220322)
n<-nrow(Boston)
ntrain<-round(0.7*n)
train <-sample(n,ntrain)
fit <- ENNreg(X[train,],y[train],K=30)
pred<-predict(fit,newdata=X[-train,],yt=y[-train])
int<- intervals(pred,level=0.95,y[-train])
print(c(int$coverage.P,int$coverage.Bel))
}

}
\seealso{
\code{\link{predict.ENNreg}}, \code{\link{ENNreg}}
}
