% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fun.R
\name{get_fun}
\alias{get_fun}
\title{Get Function}
\usage{
get_fun(obj)
}
\arguments{
\item{obj}{An object of type handler, handler_list or dispatcher.}
}
\value{
Returns a function
}
\description{
Get the function in a handler, handler_list or dispatcher objects.
}
\examples{

set_birth_date <- function(obj, event){
  obj$birthDate <- event$body$birthDate
  return(obj)
}

set_death_date <- function(obj, event){
  obj$deathDate <- event$body$deathDate
  return(obj)
}

birth_handler <- handler(type = 'BIRTH', FUN = set_birth_date)
get_fun(birth_handler)

death_handler <- handler(type = 'DEATH', FUN = set_death_date)
get_fun(death_handler)

handlers <- handlers_list(birth_handler, death_handler)
get_fun(handlers)

}
