% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kevclus.R
\name{kevclus}
\alias{kevclus}
\title{k-EVCLUS algorithm}
\usage{
kevclus(x, k = n, D, J, c, type = "simple", pairs = NULL, m0 = NULL,
  ntrials = 1, disp = TRUE, maxit = 1000, epsi = 1e-05,
  d0 = quantile(D, 0.9), tr = FALSE, change.order = FALSE)
}
\arguments{
\item{x}{nxp matrix of p attributes observed for n objects (optional).}

\item{k}{Number of distances to compute for each object (default: n).}

\item{D}{nxn or nxk dissimilarity matrix (used only of x is not supplied).}

\item{J}{n x k matrix of indices. D[i,j] is the Euclidean distance between x[i,] and
x[J[i,j],]. (Used only of x is not supplied or k<n).}

\item{c}{Number of clusters}

\item{type}{Type of focal sets ("simple": empty set, singletons and Omega;
"full": all \eqn{2^c} subsets of \eqn{\Omega}; "pairs": \eqn{\emptyset}, singletons,
\eqn{\Omega}, and all or selected pairs).}

\item{pairs}{Set of pairs to be included in the focal sets; if NULL, all pairs are
included. Used only if type="pairs".}

\item{m0}{Initial credal partition. Should be a matrix with n rows and a number of
columns equal to the number f of focal sets specified by 'type' and 'pairs'.}

\item{ntrials}{Number of runs of the optimization algorithm (set to 1 if m0 is supplied
and change.order=FALSE).}

\item{disp}{If TRUE (default), intermediate results are displayed.}

\item{maxit}{Maximum number of iterations.}

\item{epsi}{Minimum amount of improvement.}

\item{d0}{Parameter used for matrix normalization. The normalized distance corresponding
to d0 is 0.95.}

\item{tr}{If TRUE, a trace of the stress function is returned.}

\item{change.order}{If TRUE, the order of objects is changed at each iteration of the
Iterative Row-wise Quadratic Programming (IRQP) algorithm.}
}
\value{
The credal partition (an object of class \code{"credpart"}). In addition to the
usual attributes, the output credal partition has the following attributes:
 \describe{
  \item{Kmat}{The matrix of degrees of conflict. Same size as D.}
  \item{D}{The normalized dissimilarity matrix.}
  \item{trace}{Trace of the algorithm (Stress function vs iterations).}
 }
}
\description{
\code{kevclus} computes a credal partition from a dissimilarity matrix using the k-EVCLUS
algorithm.
}
\details{
This version of the EVCLUS algorithm uses the Iterative Row-wise Quadratic Programming
(IRQP) algorithm (see ter Braak et al., 2009). It also makes it possible to use only
a random sample of the dissimilarities, reducing the time and space complexity from
quadratic to roughly linear (Denoeux et al., 2016).
}
\examples{
## Example with a non metric dissimilarity matrix: the Protein dataset

data(protein)
clus <- kevclus(D=protein$D,c=4,type='simple',d0=max(protein$D))
z<- cmdscale(protein$D,k=2)  # Computation of 2 attributes by Multidimensional Scaling
plot(clus,X=z,mfrow=c(2,2),ytrue=protein$y,Outliers=FALSE,approx=1)

}
\author{
Thierry Denoeux.
}
\references{
T. Denoeux and M.-H. Masson. EVCLUS: Evidential Clustering of Proximity Data.
IEEE Transactions on Systems, Man and Cybernetics B, Vol. 34, Issue 1, 95--109, 2004.

T. Denoeux, S. Sriboonchitta and O. Kanjanatarakul. Evidential clustering of large
dissimilarity data. Knowledge-Based Systems (accepted for publication),
DOI: 10.1016/j.knosys.2016.05.043, 2016.

C. J. ter Braak, Y. Kourmpetis, H. A. Kiers, and M. C. Bink. Approximating a
similarity matrix by a latent class model: A reappraisal of additive fuzzy clustering.
Computational Statistics & Data Analysis, 53(8):3183--3193, 2009.

 Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{createD}}, \code{\link{makeF}}, \code{\link{extractMass}}
}

