% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp.R
\name{interp}
\alias{interp}
\title{Interpolation (project and resample)}
\usage{
interp(x, y, method = "bilinear", mask, verbose = FALSE)
}
\arguments{
\item{x}{rast to be interpolated}

\item{y}{target rast of the interpolation}

\item{method}{passed to terra::resample}

\item{mask}{optional SpatVector to mask the results}

\item{verbose}{display additional information (not used)}
}
\value{
SpatRaster (terra package)
}
\description{
function to project and interpolate rast
}
\examples{
model_o3 <- terra::rast(paste0(system.file("extdata",package="eva3dm"),
                              "/camx_no2.Rds"))
omi_o3   <- terra::rast(paste0(system.file("extdata",package="eva3dm"),
                              "/omi_no2.Rds"))

# interpolate omi O3 column to model grid
omi_o3c_interp_model <- interp(omi_o3,model_o3)

# interpolate model o3 column to omi grid
model_o3c_interp_omi <- interp(omi_o3,model_o3)

}
