% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_risk.R
\name{relative_risk}
\alias{relative_risk}
\alias{relative_risk_table}
\alias{order_filter}
\title{Calculate relative risks to be reported or plotted as dot plot}
\usage{
relative_risk(
  safety,
  type = c("non_serious", "serious"),
  reference = safety$GROUP$title[1],
  size = 95
)

relative_risk_table(
  safety,
  type = c("non_serious", "serious"),
  reference = safety$GROUP$title[1],
  size = 95,
  digits = 3,
  valid_estimates = TRUE
)

order_filter(rel_risk, threshold = 10)
}
\arguments{
\item{safety}{an object created by \code{\link{safety_summary}}}

\item{type}{a choice of "non_serious" (default) or "serious" as to which type of AE to report on}

\item{reference}{character vector nameing the refenrence arm for teh calculations. 
Defualts to the first row of the safety$GROUP.}

\item{size}{a number between 0-100, giving the size of the confidence interval. 
Default is 95.}

\item{digits}{integer giving the number of significant figures to report to. Default of 3.}

\item{valid_estimates}{a logical, which determines if only terms with valid estimates of relative risk are included in the table.
The alternative is to include terms with zeroes.}

\item{rel_risk}{a relative risk object}

\item{threshold}{a threshold on the percent scale, the max percentage for a term the incidence rate needs to exceed}
}
\value{
a data.frame that has the relative risk estimate and confidence intervals. 
No adjustment made to deal with zeroes.

A data frame that is suitable for printing to a report, giving relative risks

a revised relative risk object, with the terms concatenated with SOC if there are any duplicates, 
then ordered by relative risk, into a factor, and filtered to only those terms with an incidence rate above
the threshold.
}
\description{
Calculate relative risks to be reported or plotted as dot plot
}
\examples{
safety_statistics <- safety_summary(safety,
           exposed=c("Experimental"=60,"Control"=67))
head( relative_risk(safety_statistics, type="serious") )
relative_risk_table(safety_statistics, type="serious")
rr <- relative_risk(safety_statistics)
rr2 <- order_filter(rr, threshold=2)
dot_plot(rr2)
}
\seealso{
\code{\link{safety_summary}} \code{\link{dot_plot}}
}
