% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stats}
\alias{stats}
\title{Get etcd statistics}
\arguments{
\item{which}{(character) one of leader (default), self, or store}

\item{pretty}{(logical) parse text to an R list, or not. Default: \code{TRUE}}

\item{...}{Further args passed on to \code{\link[httr]{GET}}}
}
\value{
Prints a human readable text representation to console. If
\code{pretty = TRUE} (default), retunrs a list, but if \code{pretty = FALSE}
returns JSON data.
}
\description{
Get etcd statistics
}
\examples{
\dontrun{
# make a client
cli <- etcd()

# leader stats
cli$stats()

# self stats
cli$stats("self")

# store stats
cli$stats("store")

# Prety or not
cli$stats(pretty = TRUE)
cli$stats(pretty = FALSE)
}
}

