% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_tests.R
\name{boehmer}
\alias{boehmer}
\title{Boehmer's parametric test (1991).}
\usage{
boehmer(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{mean}: an average abnormal return
    \item \code{bh_stat}: a Boehmer's test statistic
    \item \code{bh_signif}: a significance of the statistic
}
}
\description{
An event study parametric test described in Boehmer 1991.
}
\details{
Performs a parametric test for event study, which is described in Boehmer
1991. Also called hybrid test or standardized cross-sectional test.
This test performs t-test based on Patell's standardized residuals. By
combining Patell's and t-tests, this test allows for event-induced variance
changes, but still assumes cross-sectional independence. The test examines
the hypothesis whether the theoretical cross-sectional expected value for a
given day is equal to zero. It calculates statistics even if event window and
estimation period are overlapped (intersect). The critical values has
Student's t-distribution. The significance levels of \eqn{\alpha} are 0.1,
0.05, and 0.01 (marked respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    boehmer(event_start = as.Date("2001-09-11"),
            event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
boehmer(list_of_returns = securities_returns,
        event_start =  as.Date("2001-09-11"),
        event_end = as.Date("2001-09-28"))

}
\references{
\itemize{
\item Patell J.M. \emph{Corporate forecasts of earnings per share and stock
price behavior: empirical tests}. Journal of Accounting Research, 14(2):246-
276, 1976.
\item Boehmer E., Musumeci J., Poulsen A.B. \emph{Event-study methodology
under conditions of event-induced variance}. Journal of Financial Economics,
30(2):253-272, 1991.}
}
\seealso{
\code{\link{parametric_tests}}, \code{\link{brown_warner_1980}},
\code{\link{brown_warner_1985}}, \code{\link{t_test}}, \code{\link{patell}},
and \code{\link{lamb}}.
}
