% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rip}
\alias{rip}
\title{Runnining Intersection Property}
\usage{
rip(adj, check = TRUE)
}
\arguments{
\item{adj}{A named adjacency list of a decomposable graph}

\item{check}{Boolean: check if adj is decomposable}
}
\value{
A list with cliques and separators of \code{adj}
}
\description{
Given a decomposable graph, this functions finds a perfect numbering on the vertices using maximum cardinality search, and hereafter returns a list with two elements: "C" - A RIP-ordering of the cliques and "S" - A RIP ordering of the separators.
}
\examples{
x <- list(a = c("b", "d"), b = c("a", "c", "d"), c = c("b", "d"), d = c("a", "c", "b"))
y <- rip(x)
# Cliques:
y$C
# Separators:
y$S
}
\seealso{
\code{\link{mcs}}, \code{\link{is_decomposable}}
}
