% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_extreme_pt.R
\name{get.extreme.pt}
\alias{get.extreme.pt}
\title{Coordinates of the extreme points}
\usage{
get.extreme.pt(vol, ref.pseudo = vol$ref.pseudo, T.MAT = NULL)
}
\arguments{
\item{vol}{"volume" class object.}

\item{ref.pseudo}{Pseudonym of the frame of reference in which you want the
coordinates.}

\item{T.MAT}{"t.mat" class object, created by
\link[espadon]{load.patient.from.Rdcm} or \link[espadon]{load.T.MAT}. If
\code{T.MAT = NULL}, \code{ref.pseudo} must be equal to \code{vol$ref.pseudo}.}
}
\value{
Returns a dataframe of min and max columns, and x, y and z rows,
representing the coordinates of the 2 extreme voxels of the rectangular
parallelepiped.
}
\description{
The \code{get.extreme.pt} function returns the x, y, z coordinates
of the 2 extreme voxels of the rectangular parallelepiped, containing
the volume \code{vol}. These coordinates are given in the \code{ref.pseudo}
frame of reference .
}
\examples{
# loading of toy-patient objects
patient <- toy.load.patient (modality = "ct", roi.name = "", dxyz = c (5, 5, 5))
CT <- patient$ct[[1]]

# xyz extreme coordinate
get.extreme.pt (CT)
}
