% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal_RVV.R
\name{pal.RVV}
\alias{pal.RVV}
\title{Conversion of Hounsfied Units to Realistic Volume Vizualization colors}
\usage{
pal.RVV(n, alpha = NULL, min.col = "#000000", max.col = "#FFFFFF")
}
\arguments{
\item{n}{Integer, number of colors to be in the palette}

\item{alpha}{Vector representing the opacity, in the range of 0 (transparent)
to 1 (opaque). If \code{alpha = NULL} (default), all colors are opaque, and
no alpha channel is added to the colors.}

\item{min.col, max.col}{respectively the color below -1000HU (by default, black,
i.e. \code{"#000000"}) and above +1000HU (by default, white, i.e. \code{"#FFFFFF"})}
}
\value{
Returns a vector of colors of size \code{n}.
}
\description{
The \code{build.RVV.pal} function produces a color palette where
Hounsfield Units in the range -1000 HU to 1000 HU are converted into
realistically colorized virtual anatomy (for use with CT), developped by
\emph{J.C. Silverstein and al} [1]
}
\examples{
pal <- pal.RVV (256)

image (x = seq (-1000, 1000, length.out = 1024), y = 1,
       z = matrix (seq (-1100, 1100, length.out = 1024), ncol = 1),
       col = pal,
       main = "Realistic Volume Vizualization colors")
}
\references{
[1] \insertRef{SILVERSTEIN2008927}{espadon}
}
