% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_cut.R
\name{signal_cut}
\alias{signal_cut}
\title{Cut signal amplitude at standard deviation-defined level.}
\usage{
signal_cut(data, k = 1)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{k}{\code{Numeric} value, multiplier of the standard deviation
threshold used to cut the signal amplitude. Default is \code{1} (1 sd).}
}
\value{
\code{Numeric} vector or list of vectors, cut signal.
}
\description{
This function cuts the amplitude of signal parts that exceede a user 
defined threshold set by k times the standard deviation of the signal.
}
\examples{

## load example data
data(rockfall)

## cut signal
rockfall_cut <- signal_cut(data = rockfall_eseis)

}
\author{
Michael Dietze
}
\keyword{eseis}
