% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_or2d.R
\name{esc_or2d}
\alias{esc_or2d}
\title{Convert effect size OR from d}
\usage{
esc_or2d(or, se, v, totaln, es.type = c("d", "cox.d", "g", "f", "eta"),
  info = NULL, study = NULL)
}
\arguments{
\item{or}{The effect size as odds ratio.}

\item{se}{The standard error of \code{d}. One of \code{se} or \code{v}
must be specified.}

\item{v}{The variance of \code{d}. One of \code{se} or \code{v} must be
specified.}

\item{totaln}{A vector of total sample size(s).}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns effect size \code{d}}
  \item{\code{"cox.d"}}{returns effect size \code{d}, based on Cox method}
  \item{\code{"g"}}{returns effect size Hedges' \code{g} (see \code{\link{hedges_g}})}
}}

\item{info}{String with information on the transformation. Used for the
print-method. Usually, this argument can be ignored}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size \code{d} from effect size \code{OR}.
}
\note{
While \code{or} is the exponentiated log odds, the variance or standard
      error need to be on the log-scale!
}
\examples{
esc_or2d(3.56, se = 0.91)
esc_d2or(0.7, se = 0.5)

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}
