% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MipRules.R
\docType{class}
\name{MipRules-class}
\alias{MipRules-class}
\alias{miprules}
\title{Create a mip object from a validator object}
\description{
Create a mip object from \code{\link[=validator]{validator()}} object.
This is a utility class that translates a validor object into a mixed integer problem that
can be solved.
Most users should use \code{\link[=locate_errors]{locate_errors()}} which will handle all translation and execution
automatically. This class is provided so users can implement or derive an alternative solution.
}

\section{Methods}{

The \code{MipRules} class contains the following methods:
\itemize{
\item \verb{$execute()} calls the mip solver to execute the rules.
\item \verb{$to_lp()}: transforms the object into a lp_solve object
\item \verb{$is_infeasible} Checks if the current system of mixed integer rules is feasible.
\item \verb{$set_values}: set values and weights for variables (determines the objective function).
}
}

\examples{
rules <- validator(x > 1)
mr <- miprules(rules)
mr$to_lp()
mr$set_values(c(x=0), weights=c(x=1))
mr$execute()
}
\seealso{
Other Mixed Integer Problem: 
\code{\link{inspect_mip}()}
}
\concept{Mixed Integer Problem}
