% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_R_cl.R
\name{estimate_R_cl}
\alias{estimate_R_cl}
\title{Estimate the effective reproduction from clinical report data}
\usage{
estimate_R_cl(
  cl.input,
  dist.repdelay,
  dist.repfrac,
  dist.incub,
  dist.gi,
  popsize,
  prm.daily = list(burn = 500, iter = 2000, chains = 3, first.agg.period = NULL,
    prior_R0_shape = 2, prior_R0_rate = 0.6, prior_alpha_shape = 1, prior_alpha_rate = 1),
  prm.daily.check = list(agg.reldiff.tol = 10),
  prm.smooth = list(method = "rollmean", align = "right", window = 7),
  prm.R = list(iter = 10, CI = 0.95, window = 7, config.EpiEstim = NULL),
  RL.max.iter = 10,
  silent = FALSE
)
}
\arguments{
\item{cl.input}{Data frame. Must have variables:
\itemize{
\item \code{date}: calendar date of report
\item \code{value}: count of reported cases
}}

\item{dist.repdelay}{List. Parameters for the reporting delay distribution in the same format as returned by \code{\link[=def_dist_reporting_delay]{def_dist_reporting_delay()}}.}

\item{dist.repfrac}{List. Parameters for the reporting fraction distribution in the same format as returned by \code{\link[=def_dist_reporting_fraction]{def_dist_reporting_fraction()}}.}

\item{dist.incub}{List. Parameters for the incubation period distribution in the same format as returned by \code{\link[=def_dist_incubation_period]{def_dist_incubation_period()}}.}

\item{dist.gi}{List. Parameters for the generation interval distribution in the same format as returned by \code{\link[=def_dist_generation_interval]{def_dist_generation_interval()}}.}

\item{popsize}{Integer. Population size to use in MCMC simulation to infer daily observations from aggregated input data.}

\item{prm.daily}{List. Parameters for daily report inference via MCMC. Elements include:
\itemize{
\item \code{burn}: Numeric. Length of burn-in period (number of days).
\item \code{iter}: Numeric. Number of iterations after burn-in period (number of days).
\item \code{chains}: Numeric. Number of chains to simulate.
\item \code{first.agg.period}: length of aggregation period for first aggregated observation (number of days); if NULL, assume same aggregation period as observed for second observation (gap between first and second observations)
\item \code{prior_R0_shape}: Shape of the (hyper-)parameter for the prior Gamma distribution for R0.
\item \code{prior_R0_rate}: Rate of the (hyper-)parameter for the prior Gamma distribution for R0.
\item \code{prior_alpha_shape}: Shape of the (hyper-)parameter for the prior Gamma distribution for alpha.
\item \code{prior_alpha_rate}: Rate of the (hyper-)parameter for the prior Gamma distribution for alpha.
}}

\item{prm.daily.check}{List. Parameters for checking aggregated to daily report inference. Elements include:
\itemize{
\item \code{agg.reldiff.tol}: numerical tolerance (\%) for relative error between aggregated inferred daily reports and original aggregated reports; chronological observations are dropped until this tolerance is first acheived (convergence at the start of the timeseries is often the worst, need to maintain uninterrupted daily timeseries for input into Rt calculation).
}
Set this entire argument to \code{NULL} to use inferred daily reports as is.}

\item{prm.smooth}{List. Smoothing parameters for input signal (daily reports) into Rt calculation. Elements include:
\itemize{
\item \code{method}: smoothing method to use; currently only \code{rollmean} (centred rolling average) is implemented
\item \code{window}: width of smoothing window (number of days)
}
Set this entire argument to \code{NULL} to turn off smoothing.}

\item{prm.R}{List. Settings for the ensemble when calculating Rt.
Elements include:
\itemize{
\item \code{iter}: Integer. Number of iterations for the Rt ensemble
\item \code{CI}: Numeric between 0 and 1. Confidence interval width for Rt
estimates after sampling uncertain distributions.
\item \code{window}: Integer. Number of days defining the window of data used by
\code{EpiEstim} to estimate Rt. If \code{NULL}, will default to 7.
\item \code{config.EpiEstim}: (optional) configuration for \code{EpiEstim} defined via
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}. If \code{NULL}, will use default config from
\code{EpiEstim}.
}}

\item{RL.max.iter}{Integer. Maximum of iterations for the Richardson-Lucy deconvolution algorithm.}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}
}
\value{
List. Elements include:
\itemize{
\item \code{cl.input}: original aggregated reports signal
\item \code{cl.daily}: reports as input for Rt calculation (inferred daily counts, smoothed)
\item \code{inferred.agg}: inferred daily reports aggregated on the reporting schedule as input in \code{cl.input}
\item \code{R}: the effective R estimate (summary from ensemble)
}
}
\description{
Estimate the effective reproduction from clinical report data
}
\examples{

# -- THIS EXAMPLE TAKES ABOUT 30 SECONDS TO RUN --

# Load SARS-CoV-2 reported cases in Ontario
# during the Omicron wave
data('cl.input')
dat = cl.input[cl.input$pt == 'on' & 
                 cl.input$date > as.Date('2021-11-30') & 
                 cl.input$date < as.Date('2022-01-31'),] 

# Estimate Rt
\dontrun{
x = estimate_R_cl(
  cl.input = dat,
  dist.repdelay = def_dist_reporting_delay(pathogen = 'sarscov2'), 
  dist.repfrac = def_dist_reporting_fraction(),
  dist.incub = def_dist_incubation_period(pathogen = 'sarscov2'),
  dist.gi = def_dist_generation_interval(pathogen = 'sarscov2'),
  popsize = 14e6, # population of Ontario in 2023
  prm.daily = list(
    # Very low number of MCMC iterations
    # for this example to run fast.
    # Increase `burn`, `iter` and `chains` 
    # for better accuracy
    burn = 50, iter = 50, chains = 1, 
    # first.agg.period = NULL,
    prior_R0_shape = 2, prior_R0_rate = 0.6, 
    prior_alpha_shape = 1, prior_alpha_rate = 1),
  silent = TRUE
)

# Rt estimates
print(x$R)
}

 

}
\seealso{
\code{\link[=plot_diagnostic_cl]{plot_diagnostic_cl()}} \code{\link[=estimate_R_ww]{estimate_R_ww()}}
}
