% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{nodemix-ergmTerm}
\alias{nodemix-ergmTerm}
\alias{InitErgmTerm.nodemix}
\alias{InitWtErgmTerm.nodemix}
\title{Nodal attribute mixing}
\usage{
# binary: nodemix(attr, base=NULL, b1levels=NULL, b2levels=NULL, levels=NULL, levels2=-1)

# valued: nodemix(attr, base=NULL, b1levels=NULL, b2levels=NULL, levels=NULL,
#                 levels2=-1, form="sum")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{base}{deprecated}

\item{b1levels, b2levels, levels}{control what statistics are included in the model and the order in which they appear. \code{levels} applies to unipartite networks; \code{b1levels} and \code{b2levels} apply to bipartite networks (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}

\item{levels2}{similar to the other levels arguments above and applies to all networks. Optionally allows a factor or character matrix to be specified to group certain levels. Level combinations corresponding to \code{NA} are excluded. Combinations specified by the same character or level will be grouped together and summarised by the same statistic. If an empty string is specified, the level combinations will be ungrouped. Only the upper triangle needs to be specified for undirected networks. For example, \code{levels2=matrix(c('A', '', NA, 'A'), 2, 2, byrow=TRUE)} on an undirected matrix will group homophilous ties while leaving ties between 1 and 2 ungrouped.}

\item{form}{how to aggregate tie values in a valued ERGM: \code{"sum"}
(the default) for a statistic of the form \eqn{\sum_{i,j} x_{i,j}
  y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is
the value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the
term's covariate associated with it; and \code{"nonzero"} with the
edge considered to be present if its value is not 0. See
\code{\link{ergmTerm}} for more information.}
}
\description{
By default, this term adds one network statistic to
the model for each possible pairing of attribute values. The
statistic equals the number of edges in the network in which the
nodes have that pairing of values. (When multiple attributes are specified, a
statistic is added for each combination of attribute values for
those attributes.) In other words, this term produces one statistic for
every entry in the mixing matrix for the attribute(s). By default, the ordering of
the attribute values is lexicographic: alphabetical (for nominal categories) or
numerical (for ordered categories).
}
\note{
The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels2} are passed,
\code{levels2} overrides \code{base}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "nodemix", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{dyad-independent}
\concept{frequently-used}
\concept{undirected}
