% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmConstraint.operator.R
\name{ChangeStats-ergmConstraint}
\alias{ChangeStats-ergmConstraint}
\alias{InitErgmConstraint.ChangeStats}
\title{Specified statistics must remain constant}
\usage{
# ChangeStats(fix, check_dind = TRUE)
}
\arguments{
\item{fix}{an \code{\link{ergmTerm}} formula.}

\item{check_dind}{logical; if \code{fix} turns out to be dyad-independent, fall back to \ergmConstraint{ergm}{Dyads}{(fix)}.}
}
\description{
This is an constraint operator that takes a \code{\link{ergmTerm}} formula, and prevents any changes to the network that modify its value. Unlike \ergmConstraint{ergm}{Dyads}{(fix = ...)}, the terms can be dyad-dependent and are calculated at the same time as the proposal rather than used to select proposable-dyads in the first place.
}
\section{Dyadic dependence}{


If the constraint is dyad-independent, \ergmConstraint{ergm}{Dyads}{(fix)} will usually be faster (at least for estimation) and will make MPLE far more accurate, so if \code{ChangeStats} detects a dyad-independent constraint, it will fall back to \code{Dyads}. This can be overridden by setting \code{check_dind = FALSE}.
}

\section{Sampleability is not guaranteed}{


It is perfectly possible for this constraint to make sampling impossible. For example, \code{ChangeStats(~edges)} will prevent any proposals that change the number of edges in the network, but \pkg{ergm} has no way of knowing that two toggles (edge and non-edge) are now required, so it will keep trying making proposals and failing.

More insidiously, it is in principle possible for the constraint to split the sample space into two parts such that it is not possible to go between them without passing through a state that breaks the constraint.

Thus, it is recommended to use this constraint to, e.g., prevent certain motifs from forming.
}

\seealso{
\code{\link{ergmConstraint}} for index of constraints and hints currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmConstraint", "ChangeStats", "subsection")}
}
\concept{directed}
\concept{operator}
\concept{undirected}
