\name{plot.freqtab}
\alias{plot.freqtab}
\alias{points.freqtab}
\alias{bfreqplot}
\alias{ufreqplot}
\title{Plotting Frequency Distributions}
\description{
This function plots univariate and bivariate frequency tables of class \dQuote{\code{\link{freqtab}}}.
}
\usage{
\method{plot}{freqtab}(x, y = NULL, xcol = 1, ycol, pch = 16,
  ylty = 1, xlab = "Total Test", addlegend = !missing(y),
  legendtext, ...)

\method{points}{freqtab}(x, xcol = 1, pch = 16, ...)
}
\arguments{
  \item{x}{
univariate or bivariate score distribution of class \dQuote{\code{\link{freqtab}}}.
}
  \item{y}{
either an object of class \dQuote{\code{\link{freqtab}}}, where frequencies will be extracted, or a vector or matrix of frequencies, to be added to the plot of \code{x}. See below for details.
}
  \item{xcol, ycol}{
colors used in plotting \code{x} and \code{y}.
}
  \item{pch}{
plotting symbol used to plot bivariate points.
}
  \item{ylty}{
line type used to plot frequencies in \code{y}.
}
  \item{xlab}{
label for the x axis.
}
  \item{addlegend}{
logical indicating whether or not a legend should be added.
}
  \item{legendtext}{
character vector of text to be passed to the \code{legend} argument of the \code{legend} function, defaulting to column names used in \code{y}.
}
  \item{\dots}{
further arguments passed to or from other methods, such as graphical parameters besides \code{col}, \code{type}, and \code{pch}.
}
}
\details{
For the points method, a scatterplot for \code{x} is added to the current opened plot.

For the plot method, when \code{x} is univariate, i.e, having 2 columns, a frequency plot is created for \code{x}. When \code{x} is bivariate, e.g., coming from a single group equating design or one form of a nonequivalent groups design, a scatterplot is produced with frequency plots for the marginal distributions.

\code{y} is used to superimpose lines, e.g., smoothed frequencies, over the (marginal) frequencies of \code{x}.

Colors must be specified using \code{xcol} and \code{ycol}. When \code{ycol} is missing, a vector of colors is created using \code{rainbow(ncol(y))}.
}
\value{
The univariate option produces a single line plot of \code{type = "h"}. Frequencies from \code{y} are then superimposed. The bivariate option produces a scatterplot with a marginal frequency plot for each distribution.
}
\author{
Anthony Albano \email{tony.d.albano@gmail.com}
}
\seealso{
\code{\link{plot.table}}, \code{\link{plot.equate}}, \code{\link{lines}}, \code{\link{points}}
}
\examples{
x <- freqtab(KBneat$x[, 1], KBneat$x[, 2],
  xscale = 0:36, vscale = 0:12)
plot(x)

xs <- loglinear(x, degree = 4, xdegree = 1, stepup = TRUE)
plot(x, xs[c(3:4, 7:9)], lwd = 2)
}
\keyword{misc}
