% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{morphing_epw}
\alias{morphing_epw}
\title{Morphing EPW weather variables}
\usage{
morphing_epw(data, years = NULL, labels = NULL)
}
\arguments{
\item{data}{An \code{epw_cmip6_data}object generated using \code{\link[=extract_data]{extract_data()}}}

\item{years}{An integer vector indicating the target years to be considered.
If \code{NULL}, all years in input data will be considered. Default: \code{NULL}.}

\item{labels}{A character or factor vector used for grouping input \code{years}.
Usually are the outputs of \code{\link[base:cut]{base::cut()}}. \code{labels} should have the
same length as \code{years}. If given, climate data of \code{years} grouped by
\code{labels} will be averaged. Default: \code{NULL}.}
}
\value{
An \code{epw_cmip6_morphed} object, which is basically a list of 12 elements:\tabular{rllll}{
   No. \tab Element \tab Type \tab Morphing Method \tab Description \cr
   1 \tab \code{epw} \tab \link[eplusr:Epw]{eplusr::Epw} \tab N/A \tab The original EPW file used for morphing \cr
   2 \tab \code{tdb} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of dry-bulb temperature after morphing \cr
   3 \tab \code{tdew} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of dew-point temperature after morphing \cr
   4 \tab \code{rh} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of relative humidity after morphing \cr
   5 \tab \code{p} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of atmospheric pressure after morphing \cr
   6 \tab \code{hor_ir} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of horizontal infrared radiation from the sky after morphing \cr
   7 \tab \code{glob_rad} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of global horizontal radiation after morphing \cr
   8 \tab \code{norm_rad} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of direct normal radiation after morphing \cr
   9 \tab \code{diff_rad} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of diffuse horizontal radiation after morphing \cr
   10 \tab \code{wind} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Stretch \tab Data of wind speed after morphing \cr
   11 \tab \code{total_cover} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of total sky cover after morphing \cr
   12 \tab \code{opaque_cover} \tab \code{\link[data.table:data.table]{data.table::data.table()}} \tab Derived \tab Data of opaque sky cover after morphing \cr
}


Each \code{\link[data.table:data.table]{data.table::data.table()}} listed above contains x columns\tabular{rlll}{
   No. \tab Column \tab Type \tab Description \cr
   1 \tab \code{activity_drs} \tab Character \tab Activity DRS (Data Reference Syntax) \cr
   2 \tab \code{institution_id} \tab Character \tab Institution identifier \cr
   3 \tab \code{source_id} \tab Character \tab Model identifier \cr
   4 \tab \code{experiment_id} \tab Character \tab Root experiment identifier \cr
   5 \tab \code{member_id} \tab Character \tab A compound construction from \code{sub_experiment_id} and \code{variant_label} \cr
   6 \tab \code{table_id} \tab Character \tab Table identifier \cr
   7 \tab \code{lat} \tab Double \tab The \strong{averaged} values of input latitude \cr
   8 \tab \code{lon} \tab Double \tab The \strong{averaged} values of input longitude \cr
   9 \tab \code{interval} \tab Factor \tab The year value of data morphed \cr
   10 \tab \strong{Variable Name} \tab Double \tab The morphed data, where \verb{Variable Name} is the corresponding EPW weather variable name \cr
   11 \tab \code{delta} \tab Double \tab The shift factor. Will be \code{NA} for derivied values \cr
   12 \tab \code{alpha} \tab Double \tab The stretch factor. Will be \code{NA} for derivied values \cr
}
}
\description{
\code{morphing_epw()} takes an \code{epw_cmip6_data} object generated using
\code{\link[=extract_data]{extract_data()}} and calculates future core EPW weather variables using
Morphing Method.
}
\details{
The EPW weather variables that get morphed are listed in details.
}
\references{
Belcher, S., Hacker, J., Powell, D., 2005. Constructing design weather data
for future climates. Building Services Engineering Research and Technology
26, 49–61. https://doi.org/10.1191/0143624405bt112oa
}
