% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{get_EPU}
\alias{get_EPU}
\title{Get Economic Policy Uncertainty (EPU) data}
\usage{
get_EPU(region = "all")
}
\arguments{
\item{region}{a character indicating the region of the EPU. The default
is "all" regions. The region names has to be one of the options in the EPU country list}
}
\value{
an xts data object containing the EPU for the chosen region.
}
\description{
EPU index from the official website while processing the dates and output formats.
}
\examples{
data <- get_EPU()
# it is an xts object so it can be plotted directly
plot(data)
# use dygraphs for interactive ts plot
library(dygraphs)
dygraph(data)
# get country-wise data using specific region name
china_epu <- get_EPU("China")
dygraph(china_epu)
}
\references{
\url{https://www.policyuncertainty.com/}
}
\seealso{
\code{\link{xts}}
}
