% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srtDataSimulation.R
\name{srtDataSimulation}
\alias{srtDataSimulation}
\title{Simulate Simple Randomized Trial (SRT) Data}
\usage{
srtDataSimulation(
  ni,
  np,
  tpi,
  sigma,
  sigmaPret,
  B0,
  B1,
  es,
  seed,
  attritionrates
)
}
\arguments{
\item{ni}{The number of intervention groups excluding the control group.}

\item{np}{The total number of participants.}

\item{tpi}{The proportions (in percent) assigned to each group, with the first value for the control group followed by the intervention groups. Must sum to 100. It should be specified as a numeric vector of length ni + 1.}

\item{sigma}{The standard deviation of individual-level error for the post-test score.}

\item{sigmaPret}{The standard deviation of the pretest scores.}

\item{B0}{The intercept term in the model.}

\item{B1}{The coefficient for the pretest in the model.}

\item{es}{The standardized effect sizes for each intervention group. It should be specified as a numeric vector.}

\item{seed}{The random seed for reproducibility.}

\item{attritionrates}{The attrition rates for each group, including the control group. It should be specified as a numeric vector of length ni + 1.}
}
\value{
A \code{data.frame} containing:
\describe{
\item{ID}{Participant ID}
\item{interventions}{Intervention assignment (0 = control, 1 to \code{ni} = intervention groups)}
\item{pretest}{Pretest score}
\item{posttest}{Posttest score (NA if participant attrited)}
}
}
\description{
This function simulates a Simple Randomized Trial (SRT), with multiple intervention arms,
pre-test and post-test scores, and individual-level attrition. No clustering or hierarchical structure is assumed.
}
\examples{
srtdata <- srtDataSimulation(ni = 2, np = 300, tpi = c(40, 30, 30),
sigma = 1, sigmaPret = 1, B0 = 0, B1 = 0.6, es = c(0.2, 0.3), 
seed = 101, attritionrates = c(0.1, 0.05, 0.05))
head(srtdata)

}
