% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{binary2factor}
\alias{binary2factor}
\title{Convert binary data to factors based on column name}
\usage{
binary2factor(.data, ...)
}
\arguments{
\item{.data}{(data.frame) A data frame or data frame extension (e.g. a tibble)}

\item{...}{Name-value pairs. The names of columns to be transformed}
}
\value{
(data.frame) An object of the same type as \code{.data}
}
\description{
Convert binary data to factors based on column name
}
\examples{
df <- data.frame(
  a = c(1, 0, NA, 1, 0),
  b = c("y", "n", NA, "Y", "n"),
  c = c("yes", "no", NA, "Yes", "No"),
  d = c(TRUE, FALSE, NA, TRUE, FALSE),
  e = c(1, 2, 3, 4, 5)
)
binary2factor(df, a, b:d)
df \%>\%
  binary2factor(-e)
}
