% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool.R
\name{tool}
\alias{tool}
\alias{epiworld_tool}
\alias{set_name_tool}
\alias{get_name_tool}
\alias{add_tool}
\alias{rm_tool}
\alias{tool_fun_logit}
\alias{set_susceptibility_reduction}
\alias{set_susceptibility_reduction_ptr}
\alias{set_susceptibility_reduction_fun}
\alias{set_transmission_reduction}
\alias{set_transmission_reduction_ptr}
\alias{set_transmission_reduction_fun}
\alias{set_recovery_enhancer}
\alias{set_recovery_enhancer_ptr}
\alias{set_recovery_enhancer_fun}
\alias{set_death_reduction}
\alias{set_death_reduction_ptr}
\alias{set_death_reduction_fun}
\alias{print.epiworld_agents_tools}
\alias{set_distribution_tool}
\alias{distribute_tool_randomly}
\alias{distribute_tool_to_set}
\title{Tools in epiworld}
\usage{
tool(
  name,
  prevalence,
  as_proportion,
  susceptibility_reduction,
  transmission_reduction,
  recovery_enhancer,
  death_reduction
)

set_name_tool(tool, name)

get_name_tool(tool)

add_tool(model, tool, proportion)

rm_tool(model, tool_pos)

tool_fun_logit(vars, coefs, model)

set_susceptibility_reduction(tool, prob)

set_susceptibility_reduction_ptr(tool, model, param)

set_susceptibility_reduction_fun(tool, model, tfun)

set_transmission_reduction(tool, prob)

set_transmission_reduction_ptr(tool, model, param)

set_transmission_reduction_fun(tool, model, tfun)

set_recovery_enhancer(tool, prob)

set_recovery_enhancer_ptr(tool, model, param)

set_recovery_enhancer_fun(tool, model, tfun)

set_death_reduction(tool, prob)

set_death_reduction_ptr(tool, model, param)

set_death_reduction_fun(tool, model, tfun)

\method{print}{epiworld_agents_tools}(x, max_print = 10, ...)

set_distribution_tool(tool, distfun)

distribute_tool_randomly(prevalence, as_proportion, agents_ids = integer(0))

distribute_tool_to_set(agents_ids)
}
\arguments{
\item{name}{Name of the tool}

\item{prevalence}{Numeric scalar. Prevalence of the tool.}

\item{as_proportion}{Logical scalar. If \code{TRUE}, \code{prevalence} is interpreted
as a proportion of the total number of agents in the model.}

\item{susceptibility_reduction}{Numeric. Proportion it reduces susceptibility.}

\item{transmission_reduction}{Numeric. Proportion it reduces transmission.}

\item{recovery_enhancer}{Numeric. Proportion it improves recovery.}

\item{death_reduction}{Numeric. Proportion it reduces probability of death.e}

\item{tool}{An object of class \code{epiworld_tool}}

\item{model}{Model}

\item{proportion}{Deprecated.}

\item{tool_pos}{Positive integer. Index of the tool's position in the model.}

\item{vars}{Integer vector. Indices (starting from 0) of the positions of the
variables used to compute the logit probability.}

\item{coefs}{Numeric vector. Of the same length of \code{vars}, is a vector of
coefficients associated to the logit probability.}

\item{prob}{Numeric scalar. A probability (between zero and one).}

\item{param}{Character scalar. Name of the parameter featured in \code{model} that
will be added to the tool (see details).}

\item{tfun}{An object of class \code{epiworld_tool_fun}.}

\item{x}{An object of class \code{epiworld_agents_tools}.}

\item{max_print}{Numeric scalar. Maximum number of tools to print.}

\item{...}{Currently ignored.}

\item{distfun}{An object of class \code{epiworld_tool_distfun}.}

\item{agents_ids}{Integer vector. Indices of the agents to which the tool
will be assigned.}
}
\value{
\itemize{
\item The \code{tool} function creates a tool of class \link{epiworld_tool}.
}

\itemize{
\item The \code{set_name_tool} function assigns a name to the tool of class
\link{epiworld_tool} and returns the tool.
}

\itemize{
\item The \code{get_name_tool} function returns the name of the tool of class
\link{epiworld_tool}.
}

\itemize{
\item The \code{rm_tool} function removes the specified tool from a model.
}

\itemize{
\item The \code{set_susceptibility_reduction} function assigns a probability reduction
to the specified tool of class \link{epiworld_tool}.
}

\itemize{
\item The \code{set_transmission_reduction} function assigns a probability reduction
to the specified tool of class \link{epiworld_tool}.
}

\itemize{
\item The \code{set_recovery_enhancer} function assigns a probability increase
to the specified tool of class \link{epiworld_tool}.
}

\itemize{
\item The \code{set_death_reduction} function assigns a probability decrease
to the specified tool of class \link{epiworld_tool}.
}

\itemize{
\item The \code{distribute_tool_randomly} function returns a distribution function of
class \code{epiworld_tool_distfun}. When \code{agents_ids} is not empty,
it will distribute the tool randomly within that set. Otherwise it uses
all the agents in the model.
}

\itemize{
\item The \code{distribute_tool_to_set} function returns a distribution function of
class \code{epiworld_tool_distfun}.
}
}
\description{
Tools are functions that affect how agents react to the virus. They can be
used to simulate the effects of vaccination, isolation, and social
distancing.
}
\details{
The name of the \code{epiworld_tool} object can be manipulated with the functions
\code{\link[=set_name_tool]{set_name_tool()}} and \code{\link[=get_name_tool]{get_name_tool()}}.

The \code{add_tool} function adds the specified tool to the model of class
\link{epiworld_model} with specified proportion.

In the case of \code{set_susceptibility_reduction_ptr}, \code{set_transmission_reduction_ptr},
\code{set_recovery_enhancer}, and
\code{set_death_reduction_ptr}, the corresponding parameters are passed as a pointer to
the tool. The implication of using pointers is that the values will be
read directly from the \code{model} object, so changes will be reflected.

The \code{set_distribution_tool} function assigns a distribution function to the
specified tool of class \link{epiworld_tool}. The distribution function can be
created using the functions \code{\link[=distribute_tool_randomly]{distribute_tool_randomly()}} and
\code{\link[=distribute_tool_to_set]{distribute_tool_to_set()}}.

The \code{distribute_tool_randomly} function creates a distribution function that
randomly assigns the tool to a proportion of the population.

The \code{distribute_tool_to_set} function creates a distribution function that
assigns the tool to a set of agents.
}
\examples{
# Simple model
model_sirconn <- ModelSIRCONN(
  name                = "COVID-19",
  n                   = 10000,
  prevalence          = 0.01,
  contact_rate        = 5,
  transmission_rate   = 0.4,
  recovery_rate       = 0.95
)

# Running and printing
run(model_sirconn, ndays = 100, seed = 1912)
plot(model_sirconn)

epitool <- tool(
  name = "Vaccine",
  prevalence = 0.5,
  as_proportion = TRUE,
  susceptibility_reduction = .9,
  transmission_reduction = .5,
  recovery_enhancer = .5,
  death_reduction = .9
)

epitool

set_name_tool(epitool, "Pfizer") # Assigning name to the tool
get_name_tool(epitool) # Returning the name of the tool
add_tool(model_sirconn, epitool)
run(model_sirconn, ndays = 100, seed = 1912)
model_sirconn
plot(model_sirconn)

# To declare a certain number of individuals with the tool
rm_tool(model_sirconn, 0) # Removing epitool from the model
# Setting prevalence to 0.1
set_distribution_tool(epitool, distribute_tool_randomly(0.1, TRUE))
add_tool(model_sirconn, epitool)
run(model_sirconn, ndays = 100, seed = 1912)

# Adjusting probabilities due to tool
set_susceptibility_reduction(epitool, 0.1) # Susceptibility reduction
set_transmission_reduction(epitool, 0.2) # Transmission reduction
set_recovery_enhancer(epitool, 0.15) # Probability increase of recovery
set_death_reduction(epitool, 0.05) # Probability reduction of death

rm_tool(model_sirconn, 0)
add_tool(model_sirconn, epitool)
run(model_sirconn, ndays = 100, seed = 1912) # Run model to view changes


# Using the logit function --------------
sir <- ModelSIR(
  name = "COVID-19", prevalence = 0.01,
  transmission_rate = 0.9, recovery_rate = 0.1
)

# Adding a small world population
agents_smallworld(
  sir,
  n = 10000,
  k = 5,
  d = FALSE,
  p = .01
)

# Creating a tool
mask_wearing <- tool(
  name = "Mask",
  prevalence               = 0.5,
  as_proportion            = TRUE,
  susceptibility_reduction = 0.0,
  transmission_reduction   = 0.3, # Only transmission
  recovery_enhancer        = 0.0,
  death_reduction          = 0.0
)

add_tool(sir, mask_wearing)

run(sir, ndays = 50, seed = 11)
hist_0 <- get_hist_total(sir)

# And adding features
dat <- cbind(
  female = sample.int(2, 10000, replace = TRUE) - 1,
  x      = rnorm(10000)
)

set_agents_data(sir, dat)

# Creating the logit function
tfun <- tool_fun_logit(
  vars  = c(0L, 1L),
  coefs = c(-1, 1),
  model = sir
)

# The infection prob is lower
hist(plogis(dat \%*\% rbind(.5, 1)))

tfun # printing


set_susceptibility_reduction_fun(
  tool  = get_tool(sir, 0),
  model = sir,
  tfun  = tfun
)

run(sir, ndays = 50, seed = 11)
hist_1 <- get_hist_total(sir)

op <- par(mfrow = c(1, 2))
plot(hist_0)
abline(v = 30)
plot(hist_1)
abline(v = 30)
par(op)

}
