% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDiagram.R
\name{print.epiworld_diagram}
\alias{print.epiworld_diagram}
\alias{plot.epiworld_diagram}
\alias{epiworld-model-diagram}
\alias{draw_mermaid_from_data}
\alias{draw_mermaid_from_matrix}
\alias{draw_mermaid_from_file}
\alias{draw_mermaid_from_files}
\title{Model Diagram}
\usage{
\method{print}{epiworld_diagram}(x, ...)

\method{plot}{epiworld_diagram}(x, ...)

draw_mermaid_from_data(
  states,
  transition_probs,
  output_file = "",
  allow_self_transitions = FALSE
)

draw_mermaid_from_matrix(
  transition_matrix,
  output_file = "",
  allow_self_transitions = FALSE
)

draw_mermaid_from_file(
  transitions_file,
  output_file = "",
  allow_self_transitions = FALSE
)

draw_mermaid_from_files(
  transitions_files,
  output_file = "",
  allow_self_transitions = FALSE
)
}
\arguments{
\item{x}{An \code{epiworld_diagram} object.}

\item{...}{Additional arguments passed to \code{\link[DiagrammeR:mermaid]{DiagrammeR::mermaid()}}.}

\item{states}{String vector. List of model states.}

\item{transition_probs}{Numeric vector. Transition probability matrix}

\item{output_file}{String. Optional path to a file. If provided, the diagram will be written to the file.}

\item{allow_self_transitions}{Logical. Whether to allow self-transitions, defaults to FALSE.}

\item{transition_matrix}{Square matrix. Contains states and transition probabilities.}

\item{transitions_file}{String. Path to file containing the transition probabilities matrix.}

\item{transitions_files}{String vector. List of files containing transition probabilities matrices from multiple model runs.}
}
\value{
\itemize{
\item The \code{draw_mermaid_from_data} function returns the
mermaid diagram as a string.
}

\itemize{
\item The \code{draw_mermaid_from_matrix} function returns the
mermaid diagram as a string.
}

\itemize{
\item The \code{draw_mermaid_from_file} function returns the
mermaid diagram as a string.
}

\itemize{
\item The \code{draw_mermaid_from_files} function returns the
mermaid diagram as a string.
}
}
\description{
Functions described here are helper functions for drawing
diagrams from model data. These generate mermaid diagrams from
transition probability matrices which can then be rendered
using other packages.
}
\examples{
# Create and run a model
model <- ModelSIRCONN(
  name = "A Virus",
  n = 10000,
  prevalence = .01,
  contact_rate = 4.0,
  transmission_rate = .5,
  recovery_rate = 1.0 / 7.0
)

verbose_off(model)
run(model, ndays = 50, seed = 1912)

# Draw mermaid diagrams from model data
diagram <- draw_mermaid_from_data(
  states = get_states(model),
  transition_probs = c(get_transition_probability(model))
)

\dontrun{
  # If DiagrammeR is installed, we can plot the diagram
  plot(diagram)
}
}
\concept{model-utility-functions}
