% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population.R
\name{Population}
\alias{Population}
\title{Population constructor.}
\usage{
Population(
  pop = NULL,
  popSize = NULL,
  vcf = NULL,
  map = NULL,
  QTL = NULL,
  genotypes = NULL,
  literal = TRUE,
  alleleFrequencies = NULL,
  broadH2 = NULL,
  narrowh2 = NULL,
  traitVar = NULL
)
}
\arguments{
\item{pop}{an optional \code{Population} object to use for default
values}

\item{popSize}{an optional number of individuals in the new
\code{Population} to be created}

\item{vcf}{an optional VCF file which will provide the map and
genotypes}

\item{map}{an optional \code{data.frame} specifying the name,
chromosome and position (in base-pairs) of each SNP}

\item{QTL}{an optional argument giving either a single number
which specifies the number of SNPs to randomly select as QTLs, or a
vector of SNP IDs (from \code{map}) to select as QTLs}

\item{genotypes}{an optional matrix of genotypes to use for the
population; see below for details}

\item{literal}{an optional \code{logical} value specifying whether
to use the genotypes directly or to generate new genotypes based
on the allele frequencies of the given genotypes}

\item{alleleFrequencies}{an optional vector of allele frequencies for
generating genotypes}

\item{broadH2}{initial broad-sense heritability within the new
\code{Population}}

\item{narrowh2}{initial narrow-sense heritability within the new
\code{Population}}

\item{traitVar}{initial phenotypic variance within the new
\code{Population}}
}
\value{
The constructor creates a new object of class
\code{'Population'}.
}
\description{
The constructor for the \code{Population} object.
}
\details{
\code{Population()} creates a new \code{Population} object based
on arguments which optionally modify a previously defined
\code{Population} object. If no \code{Population} object is given,
the new \code{Population} is created using only the arguments
given.

The arguments \code{vcf}, \code{map}, \code{genotypes},
\code{literal} and \code{alleleFrequencies} all work together in a
specific way.

If a VCF file is supplied via the \code{vcf} argument, the
\code{map}, \code{genotypes} and \code{alleleFrequencies}
arguments are not needed, since a map and set of genotypes are
given within the VCF file. If the number of individuals' genotypes
given by the VCF file does not match the number of individuals
specified by the \code{popSize} argument, the supplied genotypes
within the VCF file are used to suggest allele frequencies only:
this behaviour can also be forced by setting the \code{literal}
argument to \code{FALSE}.

The \code{genotypes} argument supplies genotypes directly. In this
case, the user should supply a phased, individual-major genotypes matrix:
one individual per row and two columns per single nucleotide
polymorphism (SNP). Odd columns are assumed to be the haplotypes
inherited from the sires, while even columns are assumed to be the
haplotypes inherited from the dams. As with genotypes supplied via
a VCF file, if the number of individuals' genotypes given by the
matrix does not match the number of individuals specified by the
\code{popSize} argument, the supplied genotypes are used to
suggest allele frequencies only; again, this behaviour can also be
forced by setting the \code{literal} argument to \code{FALSE}.

When supplying genotypes either directly or via a VCF file, all
SNPs should be biallelic and phased, with no missing values.
Genotypes supplied directly should have variants coded as either
0 or 1.

Any map (either supplied directly or via a VCF file) will be sorted,
such that all SNPs along the first chromosome listed will appear at the
start of the map, sorted in terms of base-pair distance; the second
chromosome to appear will then be treated similarly, and so on. SNPs
will be referenced within the population in this order.

The \code{alleleFrequencies} argument is used when genotypes are
not given directly. In this case, the \code{literal} argument has
no meaning.

An example \code{map data.frame} has been included in the epinetr
package as \code{map100snp}. Note that all chromosomes must be
autosomal, whether given via the \code{map} parameter or via a VCF
file.

When supplying an existing \code{Population} object, any additive
effects and epistatic network will be carried over from the
previous population unless new QTLs are supplied.

Note that if \code{broadH2} is equal to \code{narrowh2}, no
epistatic effects will be present; if \code{narrowh2} is 0, no
additive effects will be present; if \code{broadH2} is 1, no
environmental effects will be present.
}
\examples{
# Construct a new population of size 500, with random allele
# frequencies and 20 QTLs chosen at random, broad-sense
# heritability set to 0.9, narrow-sense heritability set to 0.75
# and overall trait variance set to 40.

pop <- Population(
  popSize = 500, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100), broadH2 = 0.9,
  narrowh2 = 0.75, traitVar = 40
)

# Construct a new population of size 500 using directly supplied
# genotypes and 20 QTLs chosen at random, broad-sense heritability
# set to 0.7, narrow-sense heritability set to 0.3 and overall
# trait variance set to 10.

pop2 <- Population(
  map = map100snp, genotypes = geno100snp,
  literal = TRUE, QTL = 20,
  broadH2 = 0.7, narrowh2 = 0.3, traitVar = 10
)

# Modify the previous population to have narrow-sense heritabilty
# set to 0.45 and overall trait variance set to 20.

pop2 <- Population(pop2, narrowh2 = 0.45, traitVar = 20)
}
\seealso{
\code{\link{addEffects}}, \code{\link{attachEpiNet}},
\code{\link{print.Population}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
