% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel_proportions.R
\name{rename_redundant}
\alias{rename_redundant}
\alias{augment_redundant}
\title{Cosmetically relabel all columns that contains a certain pattern}
\usage{
rename_redundant(x, ...)

augment_redundant(x, ...)
}
\arguments{
\item{x}{a data frame}

\item{...}{a series of keys and values to replace columns that match specific
patterns.}
}
\value{
a data frame.
}
\description{
These function are only to be used cosmetically before kable and will
likely return a data frame with duplicate names.
}
\details{
\itemize{
\item rename_redundant fully replaces any column names matching the keys
\item augment_redundant will take a regular expression and rename columns
via \code{\link[=gsub]{gsub()}}.
}
}
\examples{

df <- data.frame(
  x = letters[1:10],
  `a n` = 1:10,
  `a prop` = (1:10) / 10,
  `a deff` = round(pi, 2),
  `b n` = 10:1,
  `b prop` = (10:1) / 10,
  `b deff` = round(pi * 2, 2),
  check.names = FALSE
)
df
print(df <- rename_redundant(df, "\%" = "prop", "Design Effect" = "deff"))
print(df <- augment_redundant(df, " (n)" = " n$"))
}
\author{
Zhian N. Kamvar
}
