% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy_episode_dates.R
\name{proxy_episode_dates}
\alias{proxy_episode_dates}
\title{HES/SUS Episode Date Cleaning}
\usage{
proxy_episode_dates(
  x,
  group_vars,
  spell_start_date,
  spell_end_date,
  discharge_destination,
  .dropTmp = TRUE,
  .forceCopy = FALSE
)
}
\arguments{
\item{x}{a data frame; will be converted to a data.table}

\item{group_vars}{a vector containing any variables to be used for
record grouping, minimum is a patient identifier}

\item{spell_start_date}{Inpatient provider spell or episode admission date}

\item{spell_end_date}{Inpatient provider spell or episode discharge  date}

\item{discharge_destination}{CDS discharge destination code}

\item{.dropTmp}{default TRUE; a logical to drop all tmp values used}

\item{.forceCopy}{default FALSE; TRUE will force data.table to take a copy
instead of editing the data without reference}
}
\value{
a data.table with cleaned start and end dates, and an indicator proxy_missing where the value has changed
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Correcting for missing end dates on HES/SUS episodes
}
\examples{

proxy_test <- data.frame(
  id = c(
    rep(3051, 4),
    rep(7835,3),
    rep(9891,3),
    rep(1236,3)
  ),
  provider = c(
    rep("QKJ", 4),
    rep("JSD",3),
    rep("YJG",3),
    rep("LJG",3)
  ),
  spell_start = as.Date(c(
    "2020-07-03", "2020-07-14", "2020-07-23", "2020-08-05",
    "2020-11-01", "2020-11-13", "2020-12-01",
    "2020-03-28", "2020-04-06", "2020-04-09",
    "2020-10-06", "2020-11-05", "2020-12-25"
  )),
  spell_end = as.Date(c(
    "2020-07-11", "2020-07-22", "2020-07-30", "2020-07-30",
    "2020-11-11", NA, "2020-12-03",
    "2020-03-28", NA, "2020-04-09",
    "2020-10-06", "2020-11-05", NA
  )),
  disdest = c(
    19, 19, 51, 19,
    19, 19, 19,
    51, 98, 19,
    19, 19, 98
  )
)


proxy_episode_dates(
  x=proxy_test,
  group_vars = c('id','provider'),
  spell_start_date = 'spell_start',
  spell_end_date = 'spell_end',
  discharge_destination = 'disdest'
)[]
}
