// Generated by rstantools.  Do not edit by hand.

/*
    epidemia is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    epidemia is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with epidemia.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_epidemia_base_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_epidemia_base");
    reader.add_event(1, 1, "include", "/functions/reverse.stan");
    reader.add_event(1, 0, "start", "/functions/reverse.stan");
    reader.add_event(10, 9, "end", "/functions/reverse.stan");
    reader.add_event(10, 2, "restart", "model_epidemia_base");
    reader.add_event(10, 2, "include", "/functions/common_functions.stan");
    reader.add_event(10, 0, "start", "/functions/common_functions.stan");
    reader.add_event(310, 300, "end", "/functions/common_functions.stan");
    reader.add_event(310, 3, "restart", "model_epidemia_base");
    reader.add_event(310, 3, "include", "/functions/continuous_likelihoods.stan");
    reader.add_event(310, 0, "start", "/functions/continuous_likelihoods.stan");
    reader.add_event(547, 237, "end", "/functions/continuous_likelihoods.stan");
    reader.add_event(547, 4, "restart", "model_epidemia_base");
    reader.add_event(547, 4, "include", "/functions/linkinv.stan");
    reader.add_event(547, 0, "start", "/functions/linkinv.stan");
    reader.add_event(564, 17, "end", "/functions/linkinv.stan");
    reader.add_event(564, 5, "restart", "model_epidemia_base");
    reader.add_event(572, 13, "include", "/data/data_indices.stan");
    reader.add_event(572, 0, "start", "/data/data_indices.stan");
    reader.add_event(582, 10, "end", "/data/data_indices.stan");
    reader.add_event(582, 14, "restart", "model_epidemia_base");
    reader.add_event(582, 14, "include", "/data/data_obs.stan");
    reader.add_event(582, 0, "start", "/data/data_obs.stan");
    reader.add_event(602, 20, "end", "/data/data_obs.stan");
    reader.add_event(602, 15, "restart", "model_epidemia_base");
    reader.add_event(604, 17, "include", "/data/data_obs_mm.stan");
    reader.add_event(604, 0, "start", "/data/data_obs_mm.stan");
    reader.add_event(624, 20, "end", "/data/data_obs_mm.stan");
    reader.add_event(624, 18, "restart", "model_epidemia_base");
    reader.add_event(624, 18, "include", "/data/data_model.stan");
    reader.add_event(624, 0, "start", "/data/data_model.stan");
    reader.add_event(631, 7, "end", "/data/data_model.stan");
    reader.add_event(631, 19, "restart", "model_epidemia_base");
    reader.add_event(631, 19, "include", "/data/NKX.stan");
    reader.add_event(631, 0, "start", "/data/NKX.stan");
    reader.add_event(638, 7, "end", "/data/NKX.stan");
    reader.add_event(638, 20, "restart", "model_epidemia_base");
    reader.add_event(638, 20, "include", "/data/data_glm.stan");
    reader.add_event(638, 0, "start", "/data/data_glm.stan");
    reader.add_event(648, 10, "end", "/data/data_glm.stan");
    reader.add_event(648, 21, "restart", "model_epidemia_base");
    reader.add_event(648, 21, "include", "/data/data_ac.stan");
    reader.add_event(648, 0, "start", "/data/data_ac.stan");
    reader.add_event(662, 14, "end", "/data/data_ac.stan");
    reader.add_event(662, 22, "restart", "model_epidemia_base");
    reader.add_event(662, 22, "include", "/data/data_inf.stan");
    reader.add_event(662, 0, "start", "/data/data_inf.stan");
    reader.add_event(668, 6, "end", "/data/data_inf.stan");
    reader.add_event(668, 23, "restart", "model_epidemia_base");
    reader.add_event(668, 23, "include", "/data/hyperparameters.stan");
    reader.add_event(668, 0, "start", "/data/hyperparameters.stan");
    reader.add_event(722, 54, "end", "/data/hyperparameters.stan");
    reader.add_event(722, 24, "restart", "model_epidemia_base");
    reader.add_event(722, 24, "include", "/data/glmer_stuff.stan");
    reader.add_event(722, 0, "start", "/data/glmer_stuff.stan");
    reader.add_event(737, 15, "end", "/data/glmer_stuff.stan");
    reader.add_event(737, 25, "restart", "model_epidemia_base");
    reader.add_event(737, 25, "include", "/data/glmer_stuff2.stan");
    reader.add_event(737, 0, "start", "/data/glmer_stuff2.stan");
    reader.add_event(742, 5, "end", "/data/glmer_stuff2.stan");
    reader.add_event(742, 26, "restart", "model_epidemia_base");
    reader.add_event(748, 32, "include", "/tdata/tdata_reverse.stan");
    reader.add_event(748, 0, "start", "/tdata/tdata_reverse.stan");
    reader.add_event(752, 4, "end", "/tdata/tdata_reverse.stan");
    reader.add_event(752, 33, "restart", "model_epidemia_base");
    reader.add_event(752, 33, "include", "/tdata/tdata_glm.stan");
    reader.add_event(752, 0, "start", "/tdata/tdata_glm.stan");
    reader.add_event(772, 20, "end", "/tdata/tdata_glm.stan");
    reader.add_event(772, 34, "restart", "model_epidemia_base");
    reader.add_event(783, 45, "include", "/parameters/parameters_glm.stan");
    reader.add_event(783, 0, "start", "/parameters/parameters_glm.stan");
    reader.add_event(795, 12, "end", "/parameters/parameters_glm.stan");
    reader.add_event(795, 46, "restart", "model_epidemia_base");
    reader.add_event(795, 46, "include", "/parameters/parameters_ac.stan");
    reader.add_event(795, 0, "start", "/parameters/parameters_ac.stan");
    reader.add_event(800, 5, "end", "/parameters/parameters_ac.stan");
    reader.add_event(800, 47, "restart", "model_epidemia_base");
    reader.add_event(800, 47, "include", "/parameters/parameters_obs.stan");
    reader.add_event(800, 0, "start", "/parameters/parameters_obs.stan");
    reader.add_event(801, 1, "end", "/parameters/parameters_obs.stan");
    reader.add_event(801, 48, "restart", "model_epidemia_base");
    reader.add_event(801, 48, "include", "/parameters/parameters_inf.stan");
    reader.add_event(801, 0, "start", "/parameters/parameters_inf.stan");
    reader.add_event(807, 6, "end", "/parameters/parameters_inf.stan");
    reader.add_event(807, 49, "restart", "model_epidemia_base");
    reader.add_event(819, 61, "include", "/tparameters/infections_rt.stan");
    reader.add_event(819, 0, "start", "/tparameters/infections_rt.stan");
    reader.add_event(824, 5, "end", "/tparameters/infections_rt.stan");
    reader.add_event(824, 62, "restart", "model_epidemia_base");
    reader.add_event(824, 62, "include", "/tparameters/tparameters_ac.stan");
    reader.add_event(824, 0, "start", "/tparameters/tparameters_ac.stan");
    reader.add_event(829, 5, "end", "/tparameters/tparameters_ac.stan");
    reader.add_event(829, 63, "restart", "model_epidemia_base");
    reader.add_event(829, 63, "include", "/tparameters/tparameters_obs.stan");
    reader.add_event(829, 0, "start", "/tparameters/tparameters_obs.stan");
    reader.add_event(830, 1, "end", "/tparameters/tparameters_obs.stan");
    reader.add_event(830, 64, "restart", "model_epidemia_base");
    reader.add_event(830, 64, "include", "/tparameters/tparameters_glm.stan");
    reader.add_event(830, 0, "start", "/tparameters/tparameters_glm.stan");
    reader.add_event(864, 34, "end", "/tparameters/tparameters_glm.stan");
    reader.add_event(864, 65, "restart", "model_epidemia_base");
    reader.add_event(929, 130, "include", "/tparameters/make_eta.stan");
    reader.add_event(929, 0, "start", "/tparameters/make_eta.stan");
    reader.add_event(953, 24, "include", "/tparameters/eta_add_Zb.stan");
    reader.add_event(953, 0, "start", "/tparameters/eta_add_Zb.stan");
    reader.add_event(955, 2, "end", "/tparameters/eta_add_Zb.stan");
    reader.add_event(955, 25, "restart", "/tparameters/make_eta.stan");
    reader.add_event(960, 30, "include", "/tparameters/eta_no_intercept.stan");
    reader.add_event(960, 0, "start", "/tparameters/eta_no_intercept.stan");
    reader.add_event(962, 2, "end", "/tparameters/eta_no_intercept.stan");
    reader.add_event(962, 31, "restart", "/tparameters/make_eta.stan");
    reader.add_event(965, 34, "include", "/tparameters/eta_add_ac.stan");
    reader.add_event(965, 0, "start", "/tparameters/eta_add_ac.stan");
    reader.add_event(973, 8, "end", "/tparameters/eta_add_ac.stan");
    reader.add_event(973, 35, "restart", "/tparameters/make_eta.stan");
    reader.add_event(976, 38, "end", "/tparameters/make_eta.stan");
    reader.add_event(976, 131, "restart", "model_epidemia_base");
    reader.add_event(976, 131, "include", "/tparameters/make_oeta.stan");
    reader.add_event(976, 0, "start", "/tparameters/make_oeta.stan");
    reader.add_event(1196, 220, "end", "/tparameters/make_oeta.stan");
    reader.add_event(1196, 132, "restart", "model_epidemia_base");
    reader.add_event(1196, 132, "include", "/tparameters/gen_infections.stan");
    reader.add_event(1196, 0, "start", "/tparameters/gen_infections.stan");
    reader.add_event(1245, 49, "end", "/tparameters/gen_infections.stan");
    reader.add_event(1245, 133, "restart", "model_epidemia_base");
    reader.add_event(1245, 133, "include", "/tparameters/gen_eobs.stan");
    reader.add_event(1245, 0, "start", "/tparameters/gen_eobs.stan");
    reader.add_event(1267, 22, "end", "/tparameters/gen_eobs.stan");
    reader.add_event(1267, 134, "restart", "model_epidemia_base");
    reader.add_event(1270, 137, "include", "/model/priors_glm.stan");
    reader.add_event(1270, 0, "start", "/model/priors_glm.stan");
    reader.add_event(1319, 49, "end", "/model/priors_glm.stan");
    reader.add_event(1319, 138, "restart", "model_epidemia_base");
    reader.add_event(1319, 138, "include", "/model/priors_ac.stan");
    reader.add_event(1319, 0, "start", "/model/priors_ac.stan");
    reader.add_event(1338, 19, "end", "/model/priors_ac.stan");
    reader.add_event(1338, 139, "restart", "model_epidemia_base");
    reader.add_event(1338, 139, "include", "/model/priors_obs.stan");
    reader.add_event(1338, 0, "start", "/model/priors_obs.stan");
    reader.add_event(1353, 15, "end", "/model/priors_obs.stan");
    reader.add_event(1353, 140, "restart", "model_epidemia_base");
    reader.add_event(1353, 140, "include", "/model/priors_inf.stan");
    reader.add_event(1353, 0, "start", "/model/priors_inf.stan");
    reader.add_event(1405, 52, "end", "/model/priors_inf.stan");
    reader.add_event(1405, 141, "restart", "model_epidemia_base");
    reader.add_event(1446, 180, "end", "model_epidemia_base");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse2(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& vec, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(vec));
        current_statement_begin__ = 4;
        validate_non_negative_index("rev", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev(K);
        stan::math::initialize(rev, DUMMY_VAR__);
        stan::math::fill(rev, DUMMY_VAR__);
        current_statement_begin__ = 5;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 6;
            stan::model::assign(rev, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        get_base1(vec, ((K - k) + 1), "vec", 1), 
                        "assigning variable rev");
        }
        current_statement_begin__ = 8;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse2_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& vec, std::ostream* pstream__) const {
        return reverse2(vec, pstream__);
    }
};
template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic, 1>
make_theta_L(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& z_T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 32;
        validate_non_negative_index("theta_L", "len_theta_L", len_theta_L);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_L(len_theta_L);
        stan::math::initialize(theta_L, DUMMY_VAR__);
        stan::math::fill(theta_L, DUMMY_VAR__);
        current_statement_begin__ = 33;
        int zeta_mark(0);
        (void) zeta_mark;  // dummy to suppress unused var warning
        stan::math::fill(zeta_mark, std::numeric_limits<int>::min());
        stan::math::assign(zeta_mark,1);
        current_statement_begin__ = 34;
        int rho_mark(0);
        (void) rho_mark;  // dummy to suppress unused var warning
        stan::math::fill(rho_mark, std::numeric_limits<int>::min());
        stan::math::assign(rho_mark,1);
        current_statement_begin__ = 35;
        int z_T_mark(0);
        (void) z_T_mark;  // dummy to suppress unused var warning
        stan::math::fill(z_T_mark, std::numeric_limits<int>::min());
        stan::math::assign(z_T_mark,1);
        current_statement_begin__ = 36;
        int theta_L_mark(0);
        (void) theta_L_mark;  // dummy to suppress unused var warning
        stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
        stan::math::assign(theta_L_mark,1);
        current_statement_begin__ = 39;
        for (int i = 1; i <= size(p); ++i) {
            {
            current_statement_begin__ = 40;
            int nc(0);
            (void) nc;  // dummy to suppress unused var warning
            stan::math::fill(nc, std::numeric_limits<int>::min());
            stan::math::assign(nc,get_base1(p, i, "p", 1));
            current_statement_begin__ = 41;
            if (as_bool(logical_eq(nc, 1))) {
                current_statement_begin__ = 42;
                stan::model::assign(theta_L, 
                            stan::model::cons_list(stan::model::index_uni(theta_L_mark), stan::model::nil_index_list()), 
                            ((get_base1(tau, i, "tau", 1) * get_base1(scale, i, "scale", 1)) * dispersion), 
                            "assigning variable theta_L");
                current_statement_begin__ = 44;
                stan::math::assign(theta_L_mark, (theta_L_mark + 1));
            } else {
                {
                current_statement_begin__ = 47;
                validate_non_negative_index("T_i", "nc", nc);
                validate_non_negative_index("T_i", "nc", nc);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> T_i(nc, nc);
                stan::math::initialize(T_i, DUMMY_VAR__);
                stan::math::fill(T_i, DUMMY_VAR__);
                current_statement_begin__ = 48;
                local_scalar_t__ std_dev(DUMMY_VAR__);
                (void) std_dev;  // dummy to suppress unused var warning
                stan::math::initialize(std_dev, DUMMY_VAR__);
                stan::math::fill(std_dev, DUMMY_VAR__);
                current_statement_begin__ = 49;
                local_scalar_t__ T21(DUMMY_VAR__);
                (void) T21;  // dummy to suppress unused var warning
                stan::math::initialize(T21, DUMMY_VAR__);
                stan::math::fill(T21, DUMMY_VAR__);
                current_statement_begin__ = 50;
                local_scalar_t__ trace_T_i(DUMMY_VAR__);
                (void) trace_T_i;  // dummy to suppress unused var warning
                stan::math::initialize(trace_T_i, DUMMY_VAR__);
                stan::math::fill(trace_T_i, DUMMY_VAR__);
                stan::math::assign(trace_T_i,(square(((get_base1(tau, i, "tau", 1) * get_base1(scale, i, "scale", 1)) * dispersion)) * nc));
                current_statement_begin__ = 51;
                validate_non_negative_index("pi", "nc", nc);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pi(nc);
                stan::math::initialize(pi, DUMMY_VAR__);
                stan::math::fill(pi, DUMMY_VAR__);
                stan::math::assign(pi,segment(zeta, zeta_mark, nc));
                current_statement_begin__ = 52;
                stan::math::assign(pi, divide(pi, sum(pi)));
                current_statement_begin__ = 55;
                stan::math::assign(zeta_mark, (zeta_mark + nc));
                current_statement_begin__ = 56;
                stan::math::assign(std_dev, stan::math::sqrt((get_base1(pi, 1, "pi", 1) * trace_T_i)));
                current_statement_begin__ = 57;
                stan::model::assign(T_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            std_dev, 
                            "assigning variable T_i");
                current_statement_begin__ = 60;
                stan::math::assign(std_dev, stan::math::sqrt((get_base1(pi, 2, "pi", 1) * trace_T_i)));
                current_statement_begin__ = 61;
                stan::math::assign(T21, ((2.0 * get_base1(rho, rho_mark, "rho", 1)) - 1.0));
                current_statement_begin__ = 62;
                stan::math::assign(rho_mark, (rho_mark + 1));
                current_statement_begin__ = 63;
                stan::model::assign(T_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            (std_dev * stan::math::sqrt((1.0 - square(T21)))), 
                            "assigning variable T_i");
                current_statement_begin__ = 64;
                stan::model::assign(T_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            (std_dev * T21), 
                            "assigning variable T_i");
                current_statement_begin__ = 66;
                for (int r = 2; r <= (nc - 1); ++r) {
                    {
                    current_statement_begin__ = 67;
                    int rp1(0);
                    (void) rp1;  // dummy to suppress unused var warning
                    stan::math::fill(rp1, std::numeric_limits<int>::min());
                    stan::math::assign(rp1,(r + 1));
                    current_statement_begin__ = 68;
                    validate_non_negative_index("T_row", "r", r);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> T_row(r);
                    stan::math::initialize(T_row, DUMMY_VAR__);
                    stan::math::fill(T_row, DUMMY_VAR__);
                    stan::math::assign(T_row,segment(z_T, z_T_mark, r));
                    current_statement_begin__ = 69;
                    local_scalar_t__ scale_factor(DUMMY_VAR__);
                    (void) scale_factor;  // dummy to suppress unused var warning
                    stan::math::initialize(scale_factor, DUMMY_VAR__);
                    stan::math::fill(scale_factor, DUMMY_VAR__);
                    stan::math::assign(scale_factor,(stan::math::sqrt((get_base1(rho, rho_mark, "rho", 1) / dot_self(T_row))) * std_dev));
                    current_statement_begin__ = 70;
                    stan::math::assign(z_T_mark, (z_T_mark + r));
                    current_statement_begin__ = 71;
                    stan::math::assign(std_dev, stan::math::sqrt((get_base1(pi, rp1, "pi", 1) * trace_T_i)));
                    current_statement_begin__ = 72;
                    for (int c = 1; c <= r; ++c) {
                        current_statement_begin__ = 72;
                        stan::model::assign(T_i, 
                                    stan::model::cons_list(stan::model::index_uni(rp1), stan::model::cons_list(stan::model::index_uni(c), stan::model::nil_index_list())), 
                                    (get_base1(T_row, c, "T_row", 1) * scale_factor), 
                                    "assigning variable T_i");
                    }
                    current_statement_begin__ = 73;
                    stan::model::assign(T_i, 
                                stan::model::cons_list(stan::model::index_uni(rp1), stan::model::cons_list(stan::model::index_uni(rp1), stan::model::nil_index_list())), 
                                (stan::math::sqrt((1.0 - get_base1(rho, rho_mark, "rho", 1))) * std_dev), 
                                "assigning variable T_i");
                    current_statement_begin__ = 74;
                    stan::math::assign(rho_mark, (rho_mark + 1));
                    }
                }
                current_statement_begin__ = 78;
                for (int c = 1; c <= nc; ++c) {
                    current_statement_begin__ = 78;
                    for (int r = c; r <= nc; ++r) {
                        current_statement_begin__ = 79;
                        stan::model::assign(theta_L, 
                                    stan::model::cons_list(stan::model::index_uni(theta_L_mark), stan::model::nil_index_list()), 
                                    get_base1(T_i, r, c, "T_i", 1), 
                                    "assigning variable theta_L");
                        current_statement_begin__ = 80;
                        stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    }
                }
                }
            }
            }
        }
        current_statement_begin__ = 84;
        return stan::math::promote_scalar<fun_return_scalar_t__>(theta_L);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct make_theta_L_functor__ {
    template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic, 1>
    operator()(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& z_T, std::ostream* pstream__) const {
        return make_theta_L(len_theta_L, p, dispersion, tau, scale, zeta, rho, z_T, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
make_b(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 99;
        validate_non_negative_index("b", "rows(z_b)", rows(z_b));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b(rows(z_b));
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b, DUMMY_VAR__);
        current_statement_begin__ = 100;
        int b_mark(0);
        (void) b_mark;  // dummy to suppress unused var warning
        stan::math::fill(b_mark, std::numeric_limits<int>::min());
        stan::math::assign(b_mark,1);
        current_statement_begin__ = 101;
        int theta_L_mark(0);
        (void) theta_L_mark;  // dummy to suppress unused var warning
        stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
        stan::math::assign(theta_L_mark,1);
        current_statement_begin__ = 102;
        for (int i = 1; i <= size(p); ++i) {
            {
            current_statement_begin__ = 103;
            int nc(0);
            (void) nc;  // dummy to suppress unused var warning
            stan::math::fill(nc, std::numeric_limits<int>::min());
            stan::math::assign(nc,get_base1(p, i, "p", 1));
            current_statement_begin__ = 104;
            if (as_bool(logical_eq(nc, 1))) {
                {
                current_statement_begin__ = 105;
                local_scalar_t__ theta_L_start(DUMMY_VAR__);
                (void) theta_L_start;  // dummy to suppress unused var warning
                stan::math::initialize(theta_L_start, DUMMY_VAR__);
                stan::math::fill(theta_L_start, DUMMY_VAR__);
                stan::math::assign(theta_L_start,get_base1(theta_L, theta_L_mark, "theta_L", 1));
                current_statement_begin__ = 106;
                for (int s = b_mark; s <= ((b_mark + get_base1(l, i, "l", 1)) - 1); ++s) {
                    current_statement_begin__ = 107;
                    stan::model::assign(b, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                (theta_L_start * get_base1(z_b, s, "z_b", 1)), 
                                "assigning variable b");
                }
                current_statement_begin__ = 108;
                stan::math::assign(b_mark, (b_mark + get_base1(l, i, "l", 1)));
                current_statement_begin__ = 109;
                stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                }
            } else {
                {
                current_statement_begin__ = 112;
                validate_non_negative_index("T_i", "nc", nc);
                validate_non_negative_index("T_i", "nc", nc);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> T_i(nc, nc);
                stan::math::initialize(T_i, DUMMY_VAR__);
                stan::math::fill(T_i, DUMMY_VAR__);
                stan::math::assign(T_i,rep_matrix(0, nc, nc));
                current_statement_begin__ = 113;
                for (int c = 1; c <= nc; ++c) {
                    current_statement_begin__ = 114;
                    stan::model::assign(T_i, 
                                stan::model::cons_list(stan::model::index_uni(c), stan::model::cons_list(stan::model::index_uni(c), stan::model::nil_index_list())), 
                                get_base1(theta_L, theta_L_mark, "theta_L", 1), 
                                "assigning variable T_i");
                    current_statement_begin__ = 115;
                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    current_statement_begin__ = 116;
                    for (int r = (c + 1); r <= nc; ++r) {
                        current_statement_begin__ = 117;
                        stan::model::assign(T_i, 
                                    stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(c), stan::model::nil_index_list())), 
                                    get_base1(theta_L, theta_L_mark, "theta_L", 1), 
                                    "assigning variable T_i");
                        current_statement_begin__ = 118;
                        stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    }
                }
                current_statement_begin__ = 121;
                for (int j = 1; j <= get_base1(l, i, "l", 1); ++j) {
                    {
                    current_statement_begin__ = 122;
                    validate_non_negative_index("temp", "nc", nc);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> temp(nc);
                    stan::math::initialize(temp, DUMMY_VAR__);
                    stan::math::fill(temp, DUMMY_VAR__);
                    stan::math::assign(temp,multiply(T_i, segment(z_b, b_mark, nc)));
                    current_statement_begin__ = 123;
                    stan::math::assign(b_mark, (b_mark - 1));
                    current_statement_begin__ = 124;
                    for (int s = 1; s <= nc; ++s) {
                        current_statement_begin__ = 124;
                        stan::model::assign(b, 
                                    stan::model::cons_list(stan::model::index_uni((b_mark + s)), stan::model::nil_index_list()), 
                                    get_base1(temp, s, "temp", 1), 
                                    "assigning variable b");
                    }
                    current_statement_begin__ = 125;
                    stan::math::assign(b_mark, (b_mark + (nc + 1)));
                    }
                }
                }
            }
            }
        }
        current_statement_begin__ = 129;
        return stan::math::promote_scalar<fun_return_scalar_t__>(b);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct make_b_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) const {
        return make_b(z_b, theta_L, p, l, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type
decov_lp(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 150;
        int pos_reg(0);
        (void) pos_reg;  // dummy to suppress unused var warning
        stan::math::fill(pos_reg, std::numeric_limits<int>::min());
        stan::math::assign(pos_reg,1);
        current_statement_begin__ = 151;
        int pos_rho(0);
        (void) pos_rho;  // dummy to suppress unused var warning
        stan::math::fill(pos_rho, std::numeric_limits<int>::min());
        stan::math::assign(pos_rho,1);
        current_statement_begin__ = 152;
        lp_accum__.add(normal_log(z_b, 0, 1));
        current_statement_begin__ = 153;
        lp_accum__.add(normal_log(z_T, 0, 1));
        current_statement_begin__ = 154;
        for (int i = 1; i <= t; ++i) {
            current_statement_begin__ = 154;
            if (as_bool(logical_gt(get_base1(p, i, "p", 1), 1))) {
                {
                current_statement_begin__ = 155;
                validate_non_negative_index("shape1", "(get_base1(p, i, \"p\", 1) - 1)", (get_base1(p, i, "p", 1) - 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> shape1((get_base1(p, i, "p", 1) - 1));
                stan::math::initialize(shape1, DUMMY_VAR__);
                stan::math::fill(shape1, DUMMY_VAR__);
                current_statement_begin__ = 156;
                validate_non_negative_index("shape2", "(get_base1(p, i, \"p\", 1) - 1)", (get_base1(p, i, "p", 1) - 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> shape2((get_base1(p, i, "p", 1) - 1));
                stan::math::initialize(shape2, DUMMY_VAR__);
                stan::math::fill(shape2, DUMMY_VAR__);
                current_statement_begin__ = 157;
                local_scalar_t__ nu(DUMMY_VAR__);
                (void) nu;  // dummy to suppress unused var warning
                stan::math::initialize(nu, DUMMY_VAR__);
                stan::math::fill(nu, DUMMY_VAR__);
                stan::math::assign(nu,(get_base1(regularization, pos_reg, "regularization", 1) + (0.5 * (get_base1(p, i, "p", 1) - 2))));
                current_statement_begin__ = 158;
                stan::math::assign(pos_reg, (pos_reg + 1));
                current_statement_begin__ = 159;
                stan::model::assign(shape1, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            nu, 
                            "assigning variable shape1");
                current_statement_begin__ = 160;
                stan::model::assign(shape2, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            nu, 
                            "assigning variable shape2");
                current_statement_begin__ = 161;
                for (int j = 2; j <= (get_base1(p, i, "p", 1) - 1); ++j) {
                    current_statement_begin__ = 162;
                    stan::math::assign(nu, (nu - 0.5));
                    current_statement_begin__ = 163;
                    stan::model::assign(shape1, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                (0.5 * j), 
                                "assigning variable shape1");
                    current_statement_begin__ = 164;
                    stan::model::assign(shape2, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                nu, 
                                "assigning variable shape2");
                }
                current_statement_begin__ = 166;
                lp_accum__.add(beta_log(stan::model::rvalue(rho, stan::model::cons_list(stan::model::index_min_max(pos_rho, ((pos_rho + get_base1(p, i, "p", 1)) - 2)), stan::model::nil_index_list()), "rho"), shape1, shape2));
                current_statement_begin__ = 167;
                stan::math::assign(pos_rho, (pos_rho + (get_base1(p, i, "p", 1) - 1)));
                }
            }
        }
        current_statement_begin__ = 169;
        lp_accum__.add(gamma_log(zeta, delta, 1));
        current_statement_begin__ = 170;
        lp_accum__.add(gamma_log(tau, shape, 1));
        current_statement_begin__ = 171;
        return stan::math::promote_scalar<fun_return_scalar_t__>(get_lp(lp__, lp_accum__));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct decov_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return decov_lp(z_b, z_T, rho, zeta, tau, regularization, delta, shape, t, p, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, 1>
hs_prior(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic, 1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale,
             const T5__& c2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 187;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z_beta));
        current_statement_begin__ = 188;
        validate_non_negative_index("lambda", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda(K);
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda, DUMMY_VAR__);
        stan::math::assign(lambda,elt_multiply(get_base1(local, 1, "local", 1), stan::math::sqrt(get_base1(local, 2, "local", 1))));
        current_statement_begin__ = 189;
        local_scalar_t__ tau(DUMMY_VAR__);
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau, DUMMY_VAR__);
        stan::math::assign(tau,(((get_base1(global, 1, "global", 1) * stan::math::sqrt(get_base1(global, 2, "global", 1))) * global_prior_scale) * error_scale));
        current_statement_begin__ = 190;
        validate_non_negative_index("lambda2", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda2(K);
        stan::math::initialize(lambda2, DUMMY_VAR__);
        stan::math::fill(lambda2, DUMMY_VAR__);
        stan::math::assign(lambda2,square(lambda));
        current_statement_begin__ = 191;
        validate_non_negative_index("lambda_tilde", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_tilde(K);
        stan::math::initialize(lambda_tilde, DUMMY_VAR__);
        stan::math::fill(lambda_tilde, DUMMY_VAR__);
        stan::math::assign(lambda_tilde,stan::math::sqrt(elt_divide(multiply(c2, lambda2), add(c2, multiply(square(tau), lambda2)))));
        current_statement_begin__ = 192;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(elt_multiply(z_beta, lambda_tilde), tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct hs_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic, 1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale,
             const T5__& c2, std::ostream* pstream__) const {
        return hs_prior(z_beta, global, local, global_prior_scale, error_scale, c2, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, 1>
hsplus_prior(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic, 1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale,
                 const T5__& c2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 208;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z_beta));
        current_statement_begin__ = 209;
        validate_non_negative_index("lambda", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda(K);
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda, DUMMY_VAR__);
        stan::math::assign(lambda,elt_multiply(get_base1(local, 1, "local", 1), stan::math::sqrt(get_base1(local, 2, "local", 1))));
        current_statement_begin__ = 210;
        validate_non_negative_index("eta", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta(K);
        stan::math::initialize(eta, DUMMY_VAR__);
        stan::math::fill(eta, DUMMY_VAR__);
        stan::math::assign(eta,elt_multiply(get_base1(local, 3, "local", 1), stan::math::sqrt(get_base1(local, 4, "local", 1))));
        current_statement_begin__ = 211;
        local_scalar_t__ tau(DUMMY_VAR__);
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau, DUMMY_VAR__);
        stan::math::assign(tau,(((get_base1(global, 1, "global", 1) * stan::math::sqrt(get_base1(global, 2, "global", 1))) * global_prior_scale) * error_scale));
        current_statement_begin__ = 212;
        validate_non_negative_index("lambda_eta2", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_eta2(K);
        stan::math::initialize(lambda_eta2, DUMMY_VAR__);
        stan::math::fill(lambda_eta2, DUMMY_VAR__);
        stan::math::assign(lambda_eta2,square(elt_multiply(lambda, eta)));
        current_statement_begin__ = 213;
        validate_non_negative_index("lambda_tilde", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_tilde(K);
        stan::math::initialize(lambda_tilde, DUMMY_VAR__);
        stan::math::fill(lambda_tilde, DUMMY_VAR__);
        stan::math::assign(lambda_tilde,stan::math::sqrt(elt_divide(multiply(c2, lambda_eta2), add(c2, multiply(square(tau), lambda_eta2)))));
        current_statement_begin__ = 215;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(elt_multiply(z_beta, lambda_tilde), tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct hsplus_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic, 1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale,
                 const T5__& c2, std::ostream* pstream__) const {
        return hsplus_prior(z_beta, global, local, global_prior_scale, error_scale, c2, pstream__);
    }
};
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
CFt(const T0__& z,
        const T1__& df, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 229;
        local_scalar_t__ z2(DUMMY_VAR__);
        (void) z2;  // dummy to suppress unused var warning
        stan::math::initialize(z2, DUMMY_VAR__);
        stan::math::fill(z2, DUMMY_VAR__);
        stan::math::assign(z2,square(z));
        current_statement_begin__ = 230;
        local_scalar_t__ z3(DUMMY_VAR__);
        (void) z3;  // dummy to suppress unused var warning
        stan::math::initialize(z3, DUMMY_VAR__);
        stan::math::fill(z3, DUMMY_VAR__);
        stan::math::assign(z3,(z2 * z));
        current_statement_begin__ = 231;
        local_scalar_t__ z5(DUMMY_VAR__);
        (void) z5;  // dummy to suppress unused var warning
        stan::math::initialize(z5, DUMMY_VAR__);
        stan::math::fill(z5, DUMMY_VAR__);
        stan::math::assign(z5,(z2 * z3));
        current_statement_begin__ = 232;
        local_scalar_t__ z7(DUMMY_VAR__);
        (void) z7;  // dummy to suppress unused var warning
        stan::math::initialize(z7, DUMMY_VAR__);
        stan::math::fill(z7, DUMMY_VAR__);
        stan::math::assign(z7,(z2 * z5));
        current_statement_begin__ = 233;
        local_scalar_t__ z9(DUMMY_VAR__);
        (void) z9;  // dummy to suppress unused var warning
        stan::math::initialize(z9, DUMMY_VAR__);
        stan::math::fill(z9, DUMMY_VAR__);
        stan::math::assign(z9,(z2 * z7));
        current_statement_begin__ = 234;
        local_scalar_t__ df2(DUMMY_VAR__);
        (void) df2;  // dummy to suppress unused var warning
        stan::math::initialize(df2, DUMMY_VAR__);
        stan::math::fill(df2, DUMMY_VAR__);
        stan::math::assign(df2,square(df));
        current_statement_begin__ = 235;
        local_scalar_t__ df3(DUMMY_VAR__);
        (void) df3;  // dummy to suppress unused var warning
        stan::math::initialize(df3, DUMMY_VAR__);
        stan::math::fill(df3, DUMMY_VAR__);
        stan::math::assign(df3,(df2 * df));
        current_statement_begin__ = 236;
        local_scalar_t__ df4(DUMMY_VAR__);
        (void) df4;  // dummy to suppress unused var warning
        stan::math::initialize(df4, DUMMY_VAR__);
        stan::math::fill(df4, DUMMY_VAR__);
        stan::math::assign(df4,(df2 * df2));
        current_statement_begin__ = 237;
        return stan::math::promote_scalar<fun_return_scalar_t__>(((((z + ((z3 + z) / (4 * df))) + ((((5 * z5) + (16 * z3)) + (3 * z)) / (96 * df2))) + (((((3 * z7) + (19 * z5)) + (17 * z3)) - (15 * z)) / (384 * df3))) + ((((((79 * z9) + (776 * z7)) + (1482 * z5)) - (1920 * z3)) - (945 * z)) / (92160 * df4))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct CFt_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& z,
        const T1__& df, std::ostream* pstream__) const {
        return CFt(z, df, pstream__);
    }
};
std::vector<std::vector<int> >
make_V(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 251;
        validate_non_negative_index("V", "t", t);
        validate_non_negative_index("V", "N", N);
        std::vector<std::vector<int  >  > V(t, std::vector<int>(N, int(0)));
        stan::math::fill(V, std::numeric_limits<int>::min());
        current_statement_begin__ = 252;
        int pos(0);
        (void) pos;  // dummy to suppress unused var warning
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        current_statement_begin__ = 253;
        if (as_bool(logical_gt(t, 0))) {
            current_statement_begin__ = 253;
            for (int j = 1; j <= N; ++j) {
                current_statement_begin__ = 253;
                for (int i = 1; i <= t; ++i) {
                    current_statement_begin__ = 254;
                    stan::model::assign(V, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (get_base1(v, pos, "v", 1) + 1), 
                                "assigning variable V");
                    current_statement_begin__ = 255;
                    stan::math::assign(pos, (pos + 1));
                }
            }
        }
        current_statement_begin__ = 257;
        return stan::math::promote_scalar<fun_return_scalar_t__>(V);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct make_V_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) const {
        return make_V(N, t, v, pstream__);
    }
};
template <typename T2__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T5__>::type, Eigen::Dynamic, 1>
csr_matrix_times_vector2(const int& m,
                             const int& n,
                             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& w,
                             const std::vector<int>& v,
                             const std::vector<int>& u,
                             const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& b, std::ostream* pstream__);
double
make_lower(const int& family,
               const int& link, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 291;
        if (as_bool(logical_eq(family, 1))) {
            current_statement_begin__ = 291;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::negative_infinity());
        }
        current_statement_begin__ = 292;
        if (as_bool(logical_lte(family, 3))) {
            current_statement_begin__ = 293;
            if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 293;
                return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::negative_infinity());
            }
            current_statement_begin__ = 294;
            return stan::math::promote_scalar<fun_return_scalar_t__>(0);
        }
        current_statement_begin__ = 296;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::negative_infinity());
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct make_lower_functor__ {
            double
    operator()(const int& family,
               const int& link, std::ostream* pstream__) const {
        return make_lower(family, link, pstream__);
    }
};
double
make_upper(const int& family,
               const int& link, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 307;
        if (as_bool((primitive_value(logical_eq(family, 4)) && primitive_value(logical_eq(link, 5))))) {
            current_statement_begin__ = 307;
            return stan::math::promote_scalar<fun_return_scalar_t__>(0);
        }
        current_statement_begin__ = 308;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::positive_infinity());
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct make_upper_functor__ {
            double
    operator()(const int& family,
               const int& link, std::ostream* pstream__) const {
        return make_upper(family, link, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv_gauss(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                  const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 319;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 319;
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 320;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::exp(eta));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 321;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv(eta));
        } else {
            current_statement_begin__ = 322;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 323;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_gauss_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                  const int& link, std::ostream* pstream__) const {
        return linkinv_gauss(eta, link, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
pw_gauss(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
             const T2__& sigma,
             const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 334;
        return stan::math::promote_scalar<fun_return_scalar_t__>(subtract((-(0.5) * stan::math::log((6.283185307179586232 * sigma))), multiply(0.5, square(divide(subtract(y, linkinv_gauss(eta, link, pstream__)), sigma)))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pw_gauss_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
             const T2__& sigma,
             const int& link, std::ostream* pstream__) const {
        return pw_gauss(y, eta, sigma, link, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv_gamma(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                  const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 346;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 346;
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 347;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::exp(eta));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 348;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv(eta));
        } else {
            current_statement_begin__ = 349;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 350;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_gamma_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                  const int& link, std::ostream* pstream__) const {
        return linkinv_gamma(eta, link, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__>::type
GammaReg(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
             const T2__& shape,
             const int& link,
             const T4__& sum_log_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 365;
        local_scalar_t__ ret(DUMMY_VAR__);
        (void) ret;  // dummy to suppress unused var warning
        stan::math::initialize(ret, DUMMY_VAR__);
        stan::math::fill(ret, DUMMY_VAR__);
        stan::math::assign(ret,((rows(y) * ((shape * stan::math::log(shape)) - stan::math::lgamma(shape))) + ((shape - 1) * sum_log_y)));
        current_statement_begin__ = 367;
        if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 368;
            stan::math::assign(ret, (ret - ((shape * sum(eta)) + (shape * sum(elt_divide(y, stan::math::exp(eta)))))));
        } else if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 370;
            stan::math::assign(ret, (ret - ((shape * sum(stan::math::log(eta))) + (shape * sum(elt_divide(y, eta))))));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 372;
            stan::math::assign(ret, (ret + ((shape * sum(stan::math::log(eta))) - (shape * dot_product(eta, y)))));
        } else {
            current_statement_begin__ = 373;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 374;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct GammaReg_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
             const T2__& shape,
             const int& link,
             const T4__& sum_log_y, std::ostream* pstream__) const {
        return GammaReg(y, eta, shape, link, sum_log_y, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
pw_gamma(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
             const T2__& shape,
             const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 386;
        int N(0);
        (void) N;  // dummy to suppress unused var warning
        stan::math::fill(N, std::numeric_limits<int>::min());
        stan::math::assign(N,rows(eta));
        current_statement_begin__ = 387;
        validate_non_negative_index("ll", "N", N);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ll(N);
        stan::math::initialize(ll, DUMMY_VAR__);
        stan::math::fill(ll, DUMMY_VAR__);
        current_statement_begin__ = 388;
        if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 389;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 390;
                stan::model::assign(ll, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            gamma_log(get_base1(y, n, "y", 1), shape, (shape * get_base1(eta, n, "eta", 1))), 
                            "assigning variable ll");
            }
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 394;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 395;
                stan::model::assign(ll, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            gamma_log(get_base1(y, n, "y", 1), shape, (shape / stan::math::exp(get_base1(eta, n, "eta", 1)))), 
                            "assigning variable ll");
            }
        } else if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 399;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 400;
                stan::model::assign(ll, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            gamma_log(get_base1(y, n, "y", 1), shape, (shape / get_base1(eta, n, "eta", 1))), 
                            "assigning variable ll");
            }
        } else {
            current_statement_begin__ = 403;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 404;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pw_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
             const T2__& shape,
             const int& link, std::ostream* pstream__) const {
        return pw_gamma(y, eta, shape, link, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv_inv_gaussian(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                         const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 415;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 415;
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 416;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::exp(eta));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 417;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv(eta));
        } else if (as_bool(logical_eq(link, 4))) {
            current_statement_begin__ = 418;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_sqrt(eta));
        } else {
            current_statement_begin__ = 419;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 420;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_inv_gaussian_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                         const int& link, std::ostream* pstream__) const {
        return linkinv_inv_gaussian(eta, link, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
inv_gaussian(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                 const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                 const T2__& lambda,
                 const T3__& sum_log_y,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& sqrt_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 435;
        return stan::math::promote_scalar<fun_return_scalar_t__>(((((0.5 * rows(y)) * stan::math::log((lambda / 6.283185307179586232))) - (1.5 * sum_log_y)) - ((0.5 * lambda) * dot_self(elt_divide(subtract(y, mu), elt_multiply(mu, sqrt_y))))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct inv_gaussian_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                 const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                 const T2__& lambda,
                 const T3__& sum_log_y,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& sqrt_y, std::ostream* pstream__) const {
        return inv_gaussian(y, mu, lambda, sum_log_y, sqrt_y, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type, Eigen::Dynamic, 1>
pw_inv_gaussian(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
                    const T2__& lambda,
                    const int& link,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& log_y,
                    const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& sqrt_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 453;
        validate_non_negative_index("mu", "rows(y)", rows(y));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(rows(y));
        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu, DUMMY_VAR__);
        stan::math::assign(mu,linkinv_inv_gaussian(eta, link, pstream__));
        current_statement_begin__ = 454;
        return stan::math::promote_scalar<fun_return_scalar_t__>(subtract(add(multiply((-(0.5) * lambda), square(elt_divide(subtract(y, mu), elt_multiply(mu, sqrt_y)))), (0.5 * stan::math::log((lambda / 6.283185307179586232)))), multiply(1.5, log_y)));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pw_inv_gaussian_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
                    const T2__& lambda,
                    const int& link,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& log_y,
                    const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& sqrt_y, std::ostream* pstream__) const {
        return pw_inv_gaussian(y, eta, lambda, link, log_y, sqrt_y, pstream__);
    }
};
template <typename T0__, typename T1__, class RNG>
typename boost::math::tools::promote_args<T0__, T1__>::type
inv_gaussian_rng(const T0__& mu,
                     const T1__& lambda, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 468;
        local_scalar_t__ mu2(DUMMY_VAR__);
        (void) mu2;  // dummy to suppress unused var warning
        stan::math::initialize(mu2, DUMMY_VAR__);
        stan::math::fill(mu2, DUMMY_VAR__);
        stan::math::assign(mu2,square(mu));
        current_statement_begin__ = 469;
        local_scalar_t__ z(DUMMY_VAR__);
        (void) z;  // dummy to suppress unused var warning
        stan::math::initialize(z, DUMMY_VAR__);
        stan::math::fill(z, DUMMY_VAR__);
        stan::math::assign(z,uniform_rng(0, 1, base_rng__));
        current_statement_begin__ = 470;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,square(normal_rng(0, 1, base_rng__)));
        current_statement_begin__ = 471;
        local_scalar_t__ x(DUMMY_VAR__);
        (void) x;  // dummy to suppress unused var warning
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,(mu + (((mu2 * y) - (mu * stan::math::sqrt(((((4 * mu) * lambda) * y) + (mu2 * square(y)))))) / (2 * lambda))));
        current_statement_begin__ = 473;
        if (as_bool(logical_lte(z, (mu / (mu + x))))) {
            current_statement_begin__ = 473;
            return stan::math::promote_scalar<fun_return_scalar_t__>(x);
        } else {
            current_statement_begin__ = 474;
            return stan::math::promote_scalar<fun_return_scalar_t__>((mu2 / x));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct inv_gaussian_rng_functor__ {
    template <typename T0__, typename T1__, class RNG>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& mu,
                     const T1__& lambda, RNG& base_rng__, std::ostream* pstream__) const {
        return inv_gaussian_rng(mu, lambda, base_rng__, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv_beta(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                 const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 485;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 485;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_logit(eta));
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 486;
            return stan::math::promote_scalar<fun_return_scalar_t__>(Phi(eta));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 487;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_cloglog(eta));
        } else if (as_bool(logical_eq(link, 4))) {
            current_statement_begin__ = 488;
            return stan::math::promote_scalar<fun_return_scalar_t__>(add(0.5, divide(stan::math::atan(eta), stan::math::pi())));
        } else if (as_bool(logical_eq(link, 5))) {
            current_statement_begin__ = 489;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::exp(eta));
        } else if (as_bool(logical_eq(link, 6))) {
            current_statement_begin__ = 490;
            return stan::math::promote_scalar<fun_return_scalar_t__>(subtract(1, inv_cloglog(minus(eta))));
        } else {
            current_statement_begin__ = 491;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 492;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_beta_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                 const int& link, std::ostream* pstream__) const {
        return linkinv_beta(eta, link, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv_beta_z(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                   const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 503;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 503;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::exp(eta));
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 504;
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 505;
            return stan::math::promote_scalar<fun_return_scalar_t__>(square(eta));
        } else {
            current_statement_begin__ = 506;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 507;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_beta_z_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
                   const int& link, std::ostream* pstream__) const {
        return linkinv_beta_z(eta, link, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
pw_beta(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
            const T2__& dispersion,
            const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 520;
        validate_non_negative_index("ll", "rows(y)", rows(y));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ll(rows(y));
        stan::math::initialize(ll, DUMMY_VAR__);
        stan::math::fill(ll, DUMMY_VAR__);
        current_statement_begin__ = 521;
        validate_non_negative_index("mu", "rows(y)", rows(y));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(rows(y));
        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu, DUMMY_VAR__);
        stan::math::assign(mu,linkinv_beta(eta, link, pstream__));
        current_statement_begin__ = 522;
        for (int n = 1; n <= rows(y); ++n) {
            current_statement_begin__ = 523;
            stan::model::assign(ll, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        beta_log(get_base1(y, n, "y", 1), (get_base1(mu, n, "mu", 1) * dispersion), ((1 - get_base1(mu, n, "mu", 1)) * dispersion)), 
                        "assigning variable ll");
        }
        current_statement_begin__ = 525;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pw_beta_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
            const T2__& dispersion,
            const int& link, std::ostream* pstream__) const {
        return pw_beta(y, eta, dispersion, link, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
pw_beta_z(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& eta_z,
              const int& link,
              const int& link_phi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 539;
        validate_non_negative_index("ll", "rows(y)", rows(y));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ll(rows(y));
        stan::math::initialize(ll, DUMMY_VAR__);
        stan::math::fill(ll, DUMMY_VAR__);
        current_statement_begin__ = 540;
        validate_non_negative_index("mu", "rows(y)", rows(y));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(rows(y));
        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu, DUMMY_VAR__);
        stan::math::assign(mu,linkinv_beta(eta, link, pstream__));
        current_statement_begin__ = 541;
        validate_non_negative_index("mu_z", "rows(y)", rows(y));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_z(rows(y));
        stan::math::initialize(mu_z, DUMMY_VAR__);
        stan::math::fill(mu_z, DUMMY_VAR__);
        stan::math::assign(mu_z,linkinv_beta_z(eta_z, link_phi, pstream__));
        current_statement_begin__ = 542;
        for (int n = 1; n <= rows(y); ++n) {
            current_statement_begin__ = 543;
            stan::model::assign(ll, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        beta_log(get_base1(y, n, "y", 1), (get_base1(mu, n, "mu", 1) * get_base1(mu_z, n, "mu_z", 1)), ((1 - get_base1(mu, n, "mu", 1)) * get_base1(mu_z, n, "mu_z", 1))), 
                        "assigning variable ll");
        }
        current_statement_begin__ = 545;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pw_beta_z_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& eta,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& eta_z,
              const int& link,
              const int& link_phi, std::ostream* pstream__) const {
        return pw_beta_z(y, eta, eta_z, link, link_phi, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
            const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 557;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 557;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_logit(eta));
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 558;
            return stan::math::promote_scalar<fun_return_scalar_t__>(Phi(eta));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 559;
            return stan::math::promote_scalar<fun_return_scalar_t__>(add(divide(stan::math::atan(eta), stan::math::pi()), 0.5));
        } else if (as_bool(logical_eq(link, 4))) {
            current_statement_begin__ = 560;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_cloglog(eta));
        } else if (as_bool(logical_eq(link, 5))) {
            current_statement_begin__ = 561;
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else {
            current_statement_begin__ = 562;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 563;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
            const int& link, std::ostream* pstream__) const {
        return linkinv(eta, link, pstream__);
    }
};
template <typename T2__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T5__>::type, Eigen::Dynamic, 1>
test_csr_matrix_times_vector(const int& m,
                                 const int& n,
                                 const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& w,
                                 const std::vector<int>& v,
                                 const std::vector<int>& u,
                                 const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& b, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T5__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 568;
        return stan::math::promote_scalar<fun_return_scalar_t__>(csr_matrix_times_vector(m, n, w, v, u, b));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct test_csr_matrix_times_vector_functor__ {
    template <typename T2__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T5__>::type, Eigen::Dynamic, 1>
    operator()(const int& m,
                                 const int& n,
                                 const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& w,
                                 const std::vector<int>& v,
                                 const std::vector<int>& u,
                                 const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& b, std::ostream* pstream__) const {
        return test_csr_matrix_times_vector(m, n, w, v, u, b, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_epidemia_base
  : public stan::model::model_base_crtp<model_epidemia_base> {
private:
        int M;
        int N0;
        std::vector<int> starts;
        std::vector<int> NC;
        int N;
        int N2;
        int NS;
        int N_obs;
        std::vector<int> obs_group;
        std::vector<int> obs_type;
        std::vector<int> obs_date;
        int R;
        std::vector<int> oN;
        std::vector<int> pvecs_len;
        std::vector<vector_d> pvecs;
        std::vector<int> has_offset;
        vector_d offset_;
        std::vector<int> ofamily;
        std::vector<int> olink;
        int num_oaux;
        std::vector<int> has_oaux;
        std::vector<int> obs;
        std::vector<double> obs_real;
        std::vector<int> oK;
        int K_all;
        int num_ointercepts;
        std::vector<int> has_ointercept;
        vector_d oxbar;
        matrix_d oX1;
        matrix_d oX2;
        matrix_d oX3;
        matrix_d oX4;
        matrix_d oX5;
        matrix_d oX6;
        matrix_d oX7;
        matrix_d oX8;
        matrix_d oX9;
        matrix_d oX10;
        double carry;
        int link;
        matrix_d vacc;
        std::vector<double> pops;
        int gen_len;
        vector_d gen;
        int pop_adjust;
        int K;
        vector_d xbar;
        matrix_d X;
        int prior_PD;
        int has_intercept;
        int prior_dist;
        std::vector<int> prior_dist_for_intercept;
        int ac_nterms;
        int ac_nproc;
        int ac_q;
        int ac_nnz;
        std::vector<int> ac_ntime;
        std::vector<int> ac_v;
        int obs_ac_nterms;
        int obs_ac_nproc;
        int obs_ac_q;
        int obs_ac_nnz;
        std::vector<int> obs_ac_ntime;
        std::vector<std::vector<int> > obs_ac_V;
        int hseeds;
        int latent;
        int inf_family;
        int S0_fixed;
        int veps_fixed;
        int fixed_vtm;
        vector_d prior_scale;
        std::vector<double> prior_scale_for_intercept;
        vector_d prior_mean;
        vector_d prior_shape;
        vector_d prior_shift;
        std::vector<double> prior_mean_for_intercept;
        vector_d prior_df;
        std::vector<double> prior_df_for_intercept;
        double global_prior_df;
        double global_prior_scale;
        double slab_df;
        double slab_scale;
        std::vector<int> num_normals;
        vector_d prior_omean;
        vector_d prior_oscale;
        vector_d prior_mean_for_ointercept;
        vector_d prior_scale_for_ointercept;
        std::vector<int> prior_dist_for_oaux;
        vector_d prior_mean_for_oaux;
        vector_d prior_scale_for_oaux;
        vector_d prior_df_for_oaux;
        std::vector<int> prior_dist_for_inf_aux;
        std::vector<double> prior_mean_for_inf_aux;
        std::vector<double> prior_scale_for_inf_aux;
        std::vector<double> prior_df_for_inf_aux;
        std::vector<int> prior_dist_for_seeds_aux;
        vector_d prior_mean_for_seeds_aux;
        vector_d prior_scale_for_seeds_aux;
        vector_d prior_df_for_seeds_aux;
        int prior_dist_for_seeds;
        vector_d prior_mean_for_seeds;
        vector_d prior_scale_for_seeds;
        vector_d prior_df_for_seeds;
        vector_d ac_prior_scales;
        vector_d obs_ac_prior_scales;
        std::vector<double> prior_mean_for_S0;
        std::vector<double> prior_scale_for_S0;
        std::vector<double> prior_mean_for_veps;
        std::vector<double> prior_scale_for_veps;
        int t;
        std::vector<int> p;
        std::vector<int> l;
        int q;
        int len_theta_L;
        vector_d shape;
        vector_d scale;
        int len_concentration;
        std::vector<double> concentration;
        int len_regularization;
        std::vector<double> regularization;
        int num_non_zero;
        vector_d w;
        std::vector<int> v;
        std::vector<int> u;
        int special_case;
        double aux;
        std::vector<std::vector<int> > V;
        std::vector<std::vector<int> > ac_V;
        vector_d gen_rev;
        std::vector<vector_d> pvecs_rev;
        int len_z_T;
        int len_var_group;
        int len_rho;
        int pos;
        std::vector<double> delta;
        int hs;
public:
    model_epidemia_base(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_epidemia_base(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_epidemia_base_namespace::model_epidemia_base";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 574;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 1);
            current_statement_begin__ = 575;
            context__.validate_dims("data initialization", "N0", "int", context__.to_vec());
            N0 = int(0);
            vals_i__ = context__.vals_i("N0");
            pos__ = 0;
            N0 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N0", N0, 1);
            current_statement_begin__ = 576;
            validate_non_negative_index("starts", "M", M);
            context__.validate_dims("data initialization", "starts", "int", context__.to_vec(M));
            starts = std::vector<int>(M, int(0));
            vals_i__ = context__.vals_i("starts");
            pos__ = 0;
            size_t starts_k_0_max__ = M;
            for (size_t k_0__ = 0; k_0__ < starts_k_0_max__; ++k_0__) {
                starts[k_0__] = vals_i__[pos__++];
            }
            size_t starts_i_0_max__ = M;
            for (size_t i_0__ = 0; i_0__ < starts_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "starts[i_0__]", starts[i_0__], 1);
            }
            current_statement_begin__ = 577;
            validate_non_negative_index("NC", "M", M);
            context__.validate_dims("data initialization", "NC", "int", context__.to_vec(M));
            NC = std::vector<int>(M, int(0));
            vals_i__ = context__.vals_i("NC");
            pos__ = 0;
            size_t NC_k_0_max__ = M;
            for (size_t k_0__ = 0; k_0__ < NC_k_0_max__; ++k_0__) {
                NC[k_0__] = vals_i__[pos__++];
            }
            size_t NC_i_0_max__ = M;
            for (size_t i_0__ = 0; i_0__ < NC_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "NC[i_0__]", NC[i_0__], 1);
            }
            current_statement_begin__ = 578;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 579;
            context__.validate_dims("data initialization", "N2", "int", context__.to_vec());
            N2 = int(0);
            vals_i__ = context__.vals_i("N2");
            pos__ = 0;
            N2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N2", N2, 1);
            current_statement_begin__ = 580;
            context__.validate_dims("data initialization", "NS", "int", context__.to_vec());
            NS = int(0);
            vals_i__ = context__.vals_i("NS");
            pos__ = 0;
            NS = vals_i__[pos__++];
            check_greater_or_equal(function__, "NS", NS, 1);
            current_statement_begin__ = 583;
            context__.validate_dims("data initialization", "N_obs", "int", context__.to_vec());
            N_obs = int(0);
            vals_i__ = context__.vals_i("N_obs");
            pos__ = 0;
            N_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_obs", N_obs, 0);
            current_statement_begin__ = 584;
            validate_non_negative_index("obs_group", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_group", "int", context__.to_vec(N_obs));
            obs_group = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs_group");
            pos__ = 0;
            size_t obs_group_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_group_k_0_max__; ++k_0__) {
                obs_group[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 585;
            validate_non_negative_index("obs_type", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_type", "int", context__.to_vec(N_obs));
            obs_type = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs_type");
            pos__ = 0;
            size_t obs_type_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_type_k_0_max__; ++k_0__) {
                obs_type[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 586;
            validate_non_negative_index("obs_date", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_date", "int", context__.to_vec(N_obs));
            obs_date = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs_date");
            pos__ = 0;
            size_t obs_date_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_date_k_0_max__; ++k_0__) {
                obs_date[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 588;
            context__.validate_dims("data initialization", "R", "int", context__.to_vec());
            R = int(0);
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            R = vals_i__[pos__++];
            check_greater_or_equal(function__, "R", R, 0);
            current_statement_begin__ = 589;
            validate_non_negative_index("oN", "10", 10);
            context__.validate_dims("data initialization", "oN", "int", context__.to_vec(10));
            oN = std::vector<int>(10, int(0));
            vals_i__ = context__.vals_i("oN");
            pos__ = 0;
            size_t oN_k_0_max__ = 10;
            for (size_t k_0__ = 0; k_0__ < oN_k_0_max__; ++k_0__) {
                oN[k_0__] = vals_i__[pos__++];
            }
            size_t oN_i_0_max__ = 10;
            for (size_t i_0__ = 0; i_0__ < oN_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "oN[i_0__]", oN[i_0__], 0);
            }
            current_statement_begin__ = 590;
            validate_non_negative_index("pvecs_len", "R", R);
            context__.validate_dims("data initialization", "pvecs_len", "int", context__.to_vec(R));
            pvecs_len = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("pvecs_len");
            pos__ = 0;
            size_t pvecs_len_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < pvecs_len_k_0_max__; ++k_0__) {
                pvecs_len[k_0__] = vals_i__[pos__++];
            }
            size_t pvecs_len_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < pvecs_len_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pvecs_len[i_0__]", pvecs_len[i_0__], 1);
            }
            current_statement_begin__ = 591;
            validate_non_negative_index("pvecs", "NS", NS);
            validate_non_negative_index("pvecs", "R", R);
            context__.validate_dims("data initialization", "pvecs", "vector_d", context__.to_vec(R,NS));
            pvecs = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(R, Eigen::Matrix<double, Eigen::Dynamic, 1>(NS));
            vals_r__ = context__.vals_r("pvecs");
            pos__ = 0;
            size_t pvecs_j_1_max__ = NS;
            size_t pvecs_k_0_max__ = R;
            for (size_t j_1__ = 0; j_1__ < pvecs_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < pvecs_k_0_max__; ++k_0__) {
                    pvecs[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            size_t pvecs_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < pvecs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pvecs[i_0__]", pvecs[i_0__], 0);
            }
            current_statement_begin__ = 593;
            validate_non_negative_index("has_offset", "R", R);
            context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec(R));
            has_offset = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("has_offset");
            pos__ = 0;
            size_t has_offset_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < has_offset_k_0_max__; ++k_0__) {
                has_offset[k_0__] = vals_i__[pos__++];
            }
            size_t has_offset_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < has_offset_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "has_offset[i_0__]", has_offset[i_0__], 0);
                check_less_or_equal(function__, "has_offset[i_0__]", has_offset[i_0__], 1);
            }
            current_statement_begin__ = 594;
            validate_non_negative_index("offset_", "N_obs", N_obs);
            context__.validate_dims("data initialization", "offset_", "vector_d", context__.to_vec(N_obs));
            offset_ = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_obs);
            vals_r__ = context__.vals_r("offset_");
            pos__ = 0;
            size_t offset__j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < offset__j_1_max__; ++j_1__) {
                offset_(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 597;
            validate_non_negative_index("ofamily", "R", R);
            context__.validate_dims("data initialization", "ofamily", "int", context__.to_vec(R));
            ofamily = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("ofamily");
            pos__ = 0;
            size_t ofamily_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < ofamily_k_0_max__; ++k_0__) {
                ofamily[k_0__] = vals_i__[pos__++];
            }
            size_t ofamily_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < ofamily_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ofamily[i_0__]", ofamily[i_0__], 1);
                check_less_or_equal(function__, "ofamily[i_0__]", ofamily[i_0__], 5);
            }
            current_statement_begin__ = 598;
            validate_non_negative_index("olink", "R", R);
            context__.validate_dims("data initialization", "olink", "int", context__.to_vec(R));
            olink = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("olink");
            pos__ = 0;
            size_t olink_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < olink_k_0_max__; ++k_0__) {
                olink[k_0__] = vals_i__[pos__++];
            }
            size_t olink_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < olink_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "olink[i_0__]", olink[i_0__], 1);
                check_less_or_equal(function__, "olink[i_0__]", olink[i_0__], 5);
            }
            current_statement_begin__ = 601;
            context__.validate_dims("data initialization", "num_oaux", "int", context__.to_vec());
            num_oaux = int(0);
            vals_i__ = context__.vals_i("num_oaux");
            pos__ = 0;
            num_oaux = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_oaux", num_oaux, 0);
            current_statement_begin__ = 602;
            validate_non_negative_index("has_oaux", "R", R);
            context__.validate_dims("data initialization", "has_oaux", "int", context__.to_vec(R));
            has_oaux = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("has_oaux");
            pos__ = 0;
            size_t has_oaux_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < has_oaux_k_0_max__; ++k_0__) {
                has_oaux[k_0__] = vals_i__[pos__++];
            }
            size_t has_oaux_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < has_oaux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "has_oaux[i_0__]", has_oaux[i_0__], 0);
                check_less_or_equal(function__, "has_oaux[i_0__]", has_oaux[i_0__], num_oaux);
            }
            current_statement_begin__ = 603;
            validate_non_negative_index("obs", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs", "int", context__.to_vec(N_obs));
            obs = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs");
            pos__ = 0;
            size_t obs_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_k_0_max__; ++k_0__) {
                obs[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 604;
            validate_non_negative_index("obs_real", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_real", "double", context__.to_vec(N_obs));
            obs_real = std::vector<double>(N_obs, double(0));
            vals_r__ = context__.vals_r("obs_real");
            pos__ = 0;
            size_t obs_real_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_real_k_0_max__; ++k_0__) {
                obs_real[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 607;
            validate_non_negative_index("oK", "10", 10);
            context__.validate_dims("data initialization", "oK", "int", context__.to_vec(10));
            oK = std::vector<int>(10, int(0));
            vals_i__ = context__.vals_i("oK");
            pos__ = 0;
            size_t oK_k_0_max__ = 10;
            for (size_t k_0__ = 0; k_0__ < oK_k_0_max__; ++k_0__) {
                oK[k_0__] = vals_i__[pos__++];
            }
            size_t oK_i_0_max__ = 10;
            for (size_t i_0__ = 0; i_0__ < oK_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "oK[i_0__]", oK[i_0__], 0);
            }
            current_statement_begin__ = 608;
            context__.validate_dims("data initialization", "K_all", "int", context__.to_vec());
            K_all = int(0);
            vals_i__ = context__.vals_i("K_all");
            pos__ = 0;
            K_all = vals_i__[pos__++];
            check_greater_or_equal(function__, "K_all", K_all, 0);
            current_statement_begin__ = 609;
            context__.validate_dims("data initialization", "num_ointercepts", "int", context__.to_vec());
            num_ointercepts = int(0);
            vals_i__ = context__.vals_i("num_ointercepts");
            pos__ = 0;
            num_ointercepts = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_ointercepts", num_ointercepts, 0);
            current_statement_begin__ = 610;
            validate_non_negative_index("has_ointercept", "R", R);
            context__.validate_dims("data initialization", "has_ointercept", "int", context__.to_vec(R));
            has_ointercept = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("has_ointercept");
            pos__ = 0;
            size_t has_ointercept_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < has_ointercept_k_0_max__; ++k_0__) {
                has_ointercept[k_0__] = vals_i__[pos__++];
            }
            size_t has_ointercept_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < has_ointercept_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "has_ointercept[i_0__]", has_ointercept[i_0__], 0);
                check_less_or_equal(function__, "has_ointercept[i_0__]", has_ointercept[i_0__], num_ointercepts);
            }
            current_statement_begin__ = 614;
            validate_non_negative_index("oxbar", "K_all", K_all);
            context__.validate_dims("data initialization", "oxbar", "vector_d", context__.to_vec(K_all));
            oxbar = Eigen::Matrix<double, Eigen::Dynamic, 1>(K_all);
            vals_r__ = context__.vals_r("oxbar");
            pos__ = 0;
            size_t oxbar_j_1_max__ = K_all;
            for (size_t j_1__ = 0; j_1__ < oxbar_j_1_max__; ++j_1__) {
                oxbar(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 615;
            validate_non_negative_index("oX1", "get_base1(oN, 1, \"oN\", 1)", get_base1(oN, 1, "oN", 1));
            validate_non_negative_index("oX1", "get_base1(oK, 1, \"oK\", 1)", get_base1(oK, 1, "oK", 1));
            context__.validate_dims("data initialization", "oX1", "matrix_d", context__.to_vec(get_base1(oN, 1, "oN", 1),get_base1(oK, 1, "oK", 1)));
            oX1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 1, "oN", 1), get_base1(oK, 1, "oK", 1));
            vals_r__ = context__.vals_r("oX1");
            pos__ = 0;
            size_t oX1_j_2_max__ = get_base1(oK, 1, "oK", 1);
            size_t oX1_j_1_max__ = get_base1(oN, 1, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX1_j_1_max__; ++j_1__) {
                    oX1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 616;
            validate_non_negative_index("oX2", "get_base1(oN, 2, \"oN\", 1)", get_base1(oN, 2, "oN", 1));
            validate_non_negative_index("oX2", "get_base1(oK, 2, \"oK\", 1)", get_base1(oK, 2, "oK", 1));
            context__.validate_dims("data initialization", "oX2", "matrix_d", context__.to_vec(get_base1(oN, 2, "oN", 1),get_base1(oK, 2, "oK", 1)));
            oX2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 2, "oN", 1), get_base1(oK, 2, "oK", 1));
            vals_r__ = context__.vals_r("oX2");
            pos__ = 0;
            size_t oX2_j_2_max__ = get_base1(oK, 2, "oK", 1);
            size_t oX2_j_1_max__ = get_base1(oN, 2, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX2_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX2_j_1_max__; ++j_1__) {
                    oX2(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 617;
            validate_non_negative_index("oX3", "get_base1(oN, 3, \"oN\", 1)", get_base1(oN, 3, "oN", 1));
            validate_non_negative_index("oX3", "get_base1(oK, 3, \"oK\", 1)", get_base1(oK, 3, "oK", 1));
            context__.validate_dims("data initialization", "oX3", "matrix_d", context__.to_vec(get_base1(oN, 3, "oN", 1),get_base1(oK, 3, "oK", 1)));
            oX3 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 3, "oN", 1), get_base1(oK, 3, "oK", 1));
            vals_r__ = context__.vals_r("oX3");
            pos__ = 0;
            size_t oX3_j_2_max__ = get_base1(oK, 3, "oK", 1);
            size_t oX3_j_1_max__ = get_base1(oN, 3, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX3_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX3_j_1_max__; ++j_1__) {
                    oX3(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 618;
            validate_non_negative_index("oX4", "get_base1(oN, 4, \"oN\", 1)", get_base1(oN, 4, "oN", 1));
            validate_non_negative_index("oX4", "get_base1(oK, 4, \"oK\", 1)", get_base1(oK, 4, "oK", 1));
            context__.validate_dims("data initialization", "oX4", "matrix_d", context__.to_vec(get_base1(oN, 4, "oN", 1),get_base1(oK, 4, "oK", 1)));
            oX4 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 4, "oN", 1), get_base1(oK, 4, "oK", 1));
            vals_r__ = context__.vals_r("oX4");
            pos__ = 0;
            size_t oX4_j_2_max__ = get_base1(oK, 4, "oK", 1);
            size_t oX4_j_1_max__ = get_base1(oN, 4, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX4_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX4_j_1_max__; ++j_1__) {
                    oX4(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 619;
            validate_non_negative_index("oX5", "get_base1(oN, 5, \"oN\", 1)", get_base1(oN, 5, "oN", 1));
            validate_non_negative_index("oX5", "get_base1(oK, 5, \"oK\", 1)", get_base1(oK, 5, "oK", 1));
            context__.validate_dims("data initialization", "oX5", "matrix_d", context__.to_vec(get_base1(oN, 5, "oN", 1),get_base1(oK, 5, "oK", 1)));
            oX5 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 5, "oN", 1), get_base1(oK, 5, "oK", 1));
            vals_r__ = context__.vals_r("oX5");
            pos__ = 0;
            size_t oX5_j_2_max__ = get_base1(oK, 5, "oK", 1);
            size_t oX5_j_1_max__ = get_base1(oN, 5, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX5_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX5_j_1_max__; ++j_1__) {
                    oX5(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 620;
            validate_non_negative_index("oX6", "get_base1(oN, 6, \"oN\", 1)", get_base1(oN, 6, "oN", 1));
            validate_non_negative_index("oX6", "get_base1(oK, 6, \"oK\", 1)", get_base1(oK, 6, "oK", 1));
            context__.validate_dims("data initialization", "oX6", "matrix_d", context__.to_vec(get_base1(oN, 6, "oN", 1),get_base1(oK, 6, "oK", 1)));
            oX6 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 6, "oN", 1), get_base1(oK, 6, "oK", 1));
            vals_r__ = context__.vals_r("oX6");
            pos__ = 0;
            size_t oX6_j_2_max__ = get_base1(oK, 6, "oK", 1);
            size_t oX6_j_1_max__ = get_base1(oN, 6, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX6_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX6_j_1_max__; ++j_1__) {
                    oX6(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 621;
            validate_non_negative_index("oX7", "get_base1(oN, 7, \"oN\", 1)", get_base1(oN, 7, "oN", 1));
            validate_non_negative_index("oX7", "get_base1(oK, 7, \"oK\", 1)", get_base1(oK, 7, "oK", 1));
            context__.validate_dims("data initialization", "oX7", "matrix_d", context__.to_vec(get_base1(oN, 7, "oN", 1),get_base1(oK, 7, "oK", 1)));
            oX7 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 7, "oN", 1), get_base1(oK, 7, "oK", 1));
            vals_r__ = context__.vals_r("oX7");
            pos__ = 0;
            size_t oX7_j_2_max__ = get_base1(oK, 7, "oK", 1);
            size_t oX7_j_1_max__ = get_base1(oN, 7, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX7_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX7_j_1_max__; ++j_1__) {
                    oX7(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 622;
            validate_non_negative_index("oX8", "get_base1(oN, 8, \"oN\", 1)", get_base1(oN, 8, "oN", 1));
            validate_non_negative_index("oX8", "get_base1(oK, 8, \"oK\", 1)", get_base1(oK, 8, "oK", 1));
            context__.validate_dims("data initialization", "oX8", "matrix_d", context__.to_vec(get_base1(oN, 8, "oN", 1),get_base1(oK, 8, "oK", 1)));
            oX8 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 8, "oN", 1), get_base1(oK, 8, "oK", 1));
            vals_r__ = context__.vals_r("oX8");
            pos__ = 0;
            size_t oX8_j_2_max__ = get_base1(oK, 8, "oK", 1);
            size_t oX8_j_1_max__ = get_base1(oN, 8, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX8_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX8_j_1_max__; ++j_1__) {
                    oX8(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 623;
            validate_non_negative_index("oX9", "get_base1(oN, 9, \"oN\", 1)", get_base1(oN, 9, "oN", 1));
            validate_non_negative_index("oX9", "get_base1(oK, 9, \"oK\", 1)", get_base1(oK, 9, "oK", 1));
            context__.validate_dims("data initialization", "oX9", "matrix_d", context__.to_vec(get_base1(oN, 9, "oN", 1),get_base1(oK, 9, "oK", 1)));
            oX9 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 9, "oN", 1), get_base1(oK, 9, "oK", 1));
            vals_r__ = context__.vals_r("oX9");
            pos__ = 0;
            size_t oX9_j_2_max__ = get_base1(oK, 9, "oK", 1);
            size_t oX9_j_1_max__ = get_base1(oN, 9, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX9_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX9_j_1_max__; ++j_1__) {
                    oX9(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 624;
            validate_non_negative_index("oX10", "get_base1(oN, 10, \"oN\", 1)", get_base1(oN, 10, "oN", 1));
            validate_non_negative_index("oX10", "get_base1(oK, 10, \"oK\", 1)", get_base1(oK, 10, "oK", 1));
            context__.validate_dims("data initialization", "oX10", "matrix_d", context__.to_vec(get_base1(oN, 10, "oN", 1),get_base1(oK, 10, "oK", 1)));
            oX10 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(get_base1(oN, 10, "oN", 1), get_base1(oK, 10, "oK", 1));
            vals_r__ = context__.vals_r("oX10");
            pos__ = 0;
            size_t oX10_j_2_max__ = get_base1(oK, 10, "oK", 1);
            size_t oX10_j_1_max__ = get_base1(oN, 10, "oN", 1);
            for (size_t j_2__ = 0; j_2__ < oX10_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < oX10_j_1_max__; ++j_1__) {
                    oX10(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 625;
            context__.validate_dims("data initialization", "carry", "double", context__.to_vec());
            carry = double(0);
            vals_r__ = context__.vals_r("carry");
            pos__ = 0;
            carry = vals_r__[pos__++];
            check_greater_or_equal(function__, "carry", carry, 0);
            current_statement_begin__ = 626;
            context__.validate_dims("data initialization", "link", "int", context__.to_vec());
            link = int(0);
            vals_i__ = context__.vals_i("link");
            pos__ = 0;
            link = vals_i__[pos__++];
            check_greater_or_equal(function__, "link", link, 1);
            check_less_or_equal(function__, "link", link, 3);
            current_statement_begin__ = 627;
            validate_non_negative_index("vacc", "N2", N2);
            validate_non_negative_index("vacc", "M", M);
            context__.validate_dims("data initialization", "vacc", "matrix_d", context__.to_vec(N2,M));
            vacc = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N2, M);
            vals_r__ = context__.vals_r("vacc");
            pos__ = 0;
            size_t vacc_j_2_max__ = M;
            size_t vacc_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < vacc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < vacc_j_1_max__; ++j_1__) {
                    vacc(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "vacc", vacc, 0);
            check_less_or_equal(function__, "vacc", vacc, 1);
            current_statement_begin__ = 628;
            validate_non_negative_index("pops", "M", M);
            context__.validate_dims("data initialization", "pops", "double", context__.to_vec(M));
            pops = std::vector<double>(M, double(0));
            vals_r__ = context__.vals_r("pops");
            pos__ = 0;
            size_t pops_k_0_max__ = M;
            for (size_t k_0__ = 0; k_0__ < pops_k_0_max__; ++k_0__) {
                pops[k_0__] = vals_r__[pos__++];
            }
            size_t pops_i_0_max__ = M;
            for (size_t i_0__ = 0; i_0__ < pops_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pops[i_0__]", pops[i_0__], 0);
            }
            current_statement_begin__ = 629;
            context__.validate_dims("data initialization", "gen_len", "int", context__.to_vec());
            gen_len = int(0);
            vals_i__ = context__.vals_i("gen_len");
            pos__ = 0;
            gen_len = vals_i__[pos__++];
            check_greater_or_equal(function__, "gen_len", gen_len, 1);
            current_statement_begin__ = 630;
            validate_non_negative_index("gen", "gen_len", gen_len);
            context__.validate_dims("data initialization", "gen", "vector_d", context__.to_vec(gen_len));
            gen = Eigen::Matrix<double, Eigen::Dynamic, 1>(gen_len);
            vals_r__ = context__.vals_r("gen");
            pos__ = 0;
            size_t gen_j_1_max__ = gen_len;
            for (size_t j_1__ = 0; j_1__ < gen_j_1_max__; ++j_1__) {
                gen(j_1__) = vals_r__[pos__++];
            }
            stan::math::check_simplex(function__, "gen", gen);
            current_statement_begin__ = 631;
            context__.validate_dims("data initialization", "pop_adjust", "int", context__.to_vec());
            pop_adjust = int(0);
            vals_i__ = context__.vals_i("pop_adjust");
            pos__ = 0;
            pop_adjust = vals_i__[pos__++];
            check_greater_or_equal(function__, "pop_adjust", pop_adjust, 0);
            check_less_or_equal(function__, "pop_adjust", pop_adjust, 1);
            current_statement_begin__ = 633;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 635;
            validate_non_negative_index("xbar", "K", K);
            context__.validate_dims("data initialization", "xbar", "vector_d", context__.to_vec(K));
            xbar = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("xbar");
            pos__ = 0;
            size_t xbar_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < xbar_j_1_max__; ++j_1__) {
                xbar(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 636;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 640;
            context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
            prior_PD = int(0);
            vals_i__ = context__.vals_i("prior_PD");
            pos__ = 0;
            prior_PD = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_PD", prior_PD, 0);
            check_less_or_equal(function__, "prior_PD", prior_PD, 1);
            current_statement_begin__ = 643;
            context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
            has_intercept = int(0);
            vals_i__ = context__.vals_i("has_intercept");
            pos__ = 0;
            has_intercept = vals_i__[pos__++];
            check_greater_or_equal(function__, "has_intercept", has_intercept, 0);
            check_less_or_equal(function__, "has_intercept", has_intercept, 1);
            current_statement_begin__ = 647;
            context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
            prior_dist = int(0);
            vals_i__ = context__.vals_i("prior_dist");
            pos__ = 0;
            prior_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_dist", prior_dist, 0);
            check_less_or_equal(function__, "prior_dist", prior_dist, 8);
            current_statement_begin__ = 648;
            validate_non_negative_index("prior_dist_for_intercept", "has_intercept", has_intercept);
            context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec(has_intercept));
            prior_dist_for_intercept = std::vector<int>(has_intercept, int(0));
            vals_i__ = context__.vals_i("prior_dist_for_intercept");
            pos__ = 0;
            size_t prior_dist_for_intercept_k_0_max__ = has_intercept;
            for (size_t k_0__ = 0; k_0__ < prior_dist_for_intercept_k_0_max__; ++k_0__) {
                prior_dist_for_intercept[k_0__] = vals_i__[pos__++];
            }
            size_t prior_dist_for_intercept_i_0_max__ = has_intercept;
            for (size_t i_0__ = 0; i_0__ < prior_dist_for_intercept_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_dist_for_intercept[i_0__]", prior_dist_for_intercept[i_0__], 0);
                check_less_or_equal(function__, "prior_dist_for_intercept[i_0__]", prior_dist_for_intercept[i_0__], 2);
            }
            current_statement_begin__ = 649;
            context__.validate_dims("data initialization", "ac_nterms", "int", context__.to_vec());
            ac_nterms = int(0);
            vals_i__ = context__.vals_i("ac_nterms");
            pos__ = 0;
            ac_nterms = vals_i__[pos__++];
            check_greater_or_equal(function__, "ac_nterms", ac_nterms, 0);
            current_statement_begin__ = 650;
            context__.validate_dims("data initialization", "ac_nproc", "int", context__.to_vec());
            ac_nproc = int(0);
            vals_i__ = context__.vals_i("ac_nproc");
            pos__ = 0;
            ac_nproc = vals_i__[pos__++];
            check_greater_or_equal(function__, "ac_nproc", ac_nproc, 0);
            current_statement_begin__ = 651;
            context__.validate_dims("data initialization", "ac_q", "int", context__.to_vec());
            ac_q = int(0);
            vals_i__ = context__.vals_i("ac_q");
            pos__ = 0;
            ac_q = vals_i__[pos__++];
            check_greater_or_equal(function__, "ac_q", ac_q, 0);
            current_statement_begin__ = 652;
            context__.validate_dims("data initialization", "ac_nnz", "int", context__.to_vec());
            ac_nnz = int(0);
            vals_i__ = context__.vals_i("ac_nnz");
            pos__ = 0;
            ac_nnz = vals_i__[pos__++];
            check_greater_or_equal(function__, "ac_nnz", ac_nnz, 0);
            current_statement_begin__ = 653;
            validate_non_negative_index("ac_ntime", "ac_nproc", ac_nproc);
            context__.validate_dims("data initialization", "ac_ntime", "int", context__.to_vec(ac_nproc));
            ac_ntime = std::vector<int>(ac_nproc, int(0));
            vals_i__ = context__.vals_i("ac_ntime");
            pos__ = 0;
            size_t ac_ntime_k_0_max__ = ac_nproc;
            for (size_t k_0__ = 0; k_0__ < ac_ntime_k_0_max__; ++k_0__) {
                ac_ntime[k_0__] = vals_i__[pos__++];
            }
            size_t ac_ntime_i_0_max__ = ac_nproc;
            for (size_t i_0__ = 0; i_0__ < ac_ntime_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ac_ntime[i_0__]", ac_ntime[i_0__], 0);
            }
            current_statement_begin__ = 654;
            validate_non_negative_index("ac_v", "ac_nnz", ac_nnz);
            context__.validate_dims("data initialization", "ac_v", "int", context__.to_vec(ac_nnz));
            ac_v = std::vector<int>(ac_nnz, int(0));
            vals_i__ = context__.vals_i("ac_v");
            pos__ = 0;
            size_t ac_v_k_0_max__ = ac_nnz;
            for (size_t k_0__ = 0; k_0__ < ac_v_k_0_max__; ++k_0__) {
                ac_v[k_0__] = vals_i__[pos__++];
            }
            size_t ac_v_i_0_max__ = ac_nnz;
            for (size_t i_0__ = 0; i_0__ < ac_v_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ac_v[i_0__]", ac_v[i_0__], -(1));
                check_less_or_equal(function__, "ac_v[i_0__]", ac_v[i_0__], (ac_q - 1));
            }
            current_statement_begin__ = 657;
            context__.validate_dims("data initialization", "obs_ac_nterms", "int", context__.to_vec());
            obs_ac_nterms = int(0);
            vals_i__ = context__.vals_i("obs_ac_nterms");
            pos__ = 0;
            obs_ac_nterms = vals_i__[pos__++];
            check_greater_or_equal(function__, "obs_ac_nterms", obs_ac_nterms, 0);
            current_statement_begin__ = 658;
            context__.validate_dims("data initialization", "obs_ac_nproc", "int", context__.to_vec());
            obs_ac_nproc = int(0);
            vals_i__ = context__.vals_i("obs_ac_nproc");
            pos__ = 0;
            obs_ac_nproc = vals_i__[pos__++];
            check_greater_or_equal(function__, "obs_ac_nproc", obs_ac_nproc, 0);
            current_statement_begin__ = 659;
            context__.validate_dims("data initialization", "obs_ac_q", "int", context__.to_vec());
            obs_ac_q = int(0);
            vals_i__ = context__.vals_i("obs_ac_q");
            pos__ = 0;
            obs_ac_q = vals_i__[pos__++];
            check_greater_or_equal(function__, "obs_ac_q", obs_ac_q, 0);
            current_statement_begin__ = 660;
            context__.validate_dims("data initialization", "obs_ac_nnz", "int", context__.to_vec());
            obs_ac_nnz = int(0);
            vals_i__ = context__.vals_i("obs_ac_nnz");
            pos__ = 0;
            obs_ac_nnz = vals_i__[pos__++];
            check_greater_or_equal(function__, "obs_ac_nnz", obs_ac_nnz, 0);
            current_statement_begin__ = 661;
            validate_non_negative_index("obs_ac_ntime", "obs_ac_nproc", obs_ac_nproc);
            context__.validate_dims("data initialization", "obs_ac_ntime", "int", context__.to_vec(obs_ac_nproc));
            obs_ac_ntime = std::vector<int>(obs_ac_nproc, int(0));
            vals_i__ = context__.vals_i("obs_ac_ntime");
            pos__ = 0;
            size_t obs_ac_ntime_k_0_max__ = obs_ac_nproc;
            for (size_t k_0__ = 0; k_0__ < obs_ac_ntime_k_0_max__; ++k_0__) {
                obs_ac_ntime[k_0__] = vals_i__[pos__++];
            }
            size_t obs_ac_ntime_i_0_max__ = obs_ac_nproc;
            for (size_t i_0__ = 0; i_0__ < obs_ac_ntime_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "obs_ac_ntime[i_0__]", obs_ac_ntime[i_0__], 0);
            }
            current_statement_begin__ = 662;
            validate_non_negative_index("obs_ac_V", "obs_ac_nterms", obs_ac_nterms);
            validate_non_negative_index("obs_ac_V", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_ac_V", "int", context__.to_vec(obs_ac_nterms,N_obs));
            obs_ac_V = std::vector<std::vector<int> >(obs_ac_nterms, std::vector<int>(N_obs, int(0)));
            vals_i__ = context__.vals_i("obs_ac_V");
            pos__ = 0;
            size_t obs_ac_V_k_0_max__ = obs_ac_nterms;
            size_t obs_ac_V_k_1_max__ = N_obs;
            for (size_t k_1__ = 0; k_1__ < obs_ac_V_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < obs_ac_V_k_0_max__; ++k_0__) {
                    obs_ac_V[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t obs_ac_V_i_0_max__ = obs_ac_nterms;
            size_t obs_ac_V_i_1_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < obs_ac_V_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < obs_ac_V_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "obs_ac_V[i_0__][i_1__]", obs_ac_V[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 663;
            context__.validate_dims("data initialization", "hseeds", "int", context__.to_vec());
            hseeds = int(0);
            vals_i__ = context__.vals_i("hseeds");
            pos__ = 0;
            hseeds = vals_i__[pos__++];
            check_greater_or_equal(function__, "hseeds", hseeds, 0);
            check_less_or_equal(function__, "hseeds", hseeds, 1);
            current_statement_begin__ = 664;
            context__.validate_dims("data initialization", "latent", "int", context__.to_vec());
            latent = int(0);
            vals_i__ = context__.vals_i("latent");
            pos__ = 0;
            latent = vals_i__[pos__++];
            check_greater_or_equal(function__, "latent", latent, 0);
            check_less_or_equal(function__, "latent", latent, 1);
            current_statement_begin__ = 665;
            context__.validate_dims("data initialization", "inf_family", "int", context__.to_vec());
            inf_family = int(0);
            vals_i__ = context__.vals_i("inf_family");
            pos__ = 0;
            inf_family = vals_i__[pos__++];
            check_greater_or_equal(function__, "inf_family", inf_family, 0);
            check_less_or_equal(function__, "inf_family", inf_family, 1);
            current_statement_begin__ = 666;
            context__.validate_dims("data initialization", "S0_fixed", "int", context__.to_vec());
            S0_fixed = int(0);
            vals_i__ = context__.vals_i("S0_fixed");
            pos__ = 0;
            S0_fixed = vals_i__[pos__++];
            check_greater_or_equal(function__, "S0_fixed", S0_fixed, 0);
            check_less_or_equal(function__, "S0_fixed", S0_fixed, 1);
            current_statement_begin__ = 667;
            context__.validate_dims("data initialization", "veps_fixed", "int", context__.to_vec());
            veps_fixed = int(0);
            vals_i__ = context__.vals_i("veps_fixed");
            pos__ = 0;
            veps_fixed = vals_i__[pos__++];
            check_greater_or_equal(function__, "veps_fixed", veps_fixed, 0);
            check_less_or_equal(function__, "veps_fixed", veps_fixed, 1);
            current_statement_begin__ = 668;
            context__.validate_dims("data initialization", "fixed_vtm", "int", context__.to_vec());
            fixed_vtm = int(0);
            vals_i__ = context__.vals_i("fixed_vtm");
            pos__ = 0;
            fixed_vtm = vals_i__[pos__++];
            check_greater_or_equal(function__, "fixed_vtm", fixed_vtm, 0);
            check_less_or_equal(function__, "fixed_vtm", fixed_vtm, 1);
            current_statement_begin__ = 670;
            validate_non_negative_index("prior_scale", "K", K);
            context__.validate_dims("data initialization", "prior_scale", "vector_d", context__.to_vec(K));
            prior_scale = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_scale");
            pos__ = 0;
            size_t prior_scale_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_scale_j_1_max__; ++j_1__) {
                prior_scale(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_scale", prior_scale, 0);
            current_statement_begin__ = 671;
            validate_non_negative_index("prior_scale_for_intercept", "has_intercept", has_intercept);
            context__.validate_dims("data initialization", "prior_scale_for_intercept", "double", context__.to_vec(has_intercept));
            prior_scale_for_intercept = std::vector<double>(has_intercept, double(0));
            vals_r__ = context__.vals_r("prior_scale_for_intercept");
            pos__ = 0;
            size_t prior_scale_for_intercept_k_0_max__ = has_intercept;
            for (size_t k_0__ = 0; k_0__ < prior_scale_for_intercept_k_0_max__; ++k_0__) {
                prior_scale_for_intercept[k_0__] = vals_r__[pos__++];
            }
            size_t prior_scale_for_intercept_i_0_max__ = has_intercept;
            for (size_t i_0__ = 0; i_0__ < prior_scale_for_intercept_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_scale_for_intercept[i_0__]", prior_scale_for_intercept[i_0__], 0);
            }
            current_statement_begin__ = 672;
            validate_non_negative_index("prior_mean", "K", K);
            context__.validate_dims("data initialization", "prior_mean", "vector_d", context__.to_vec(K));
            prior_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_mean");
            pos__ = 0;
            size_t prior_mean_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_mean_j_1_max__; ++j_1__) {
                prior_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 673;
            validate_non_negative_index("prior_shape", "K", K);
            context__.validate_dims("data initialization", "prior_shape", "vector_d", context__.to_vec(K));
            prior_shape = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_shape");
            pos__ = 0;
            size_t prior_shape_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_shape_j_1_max__; ++j_1__) {
                prior_shape(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_shape", prior_shape, 0);
            current_statement_begin__ = 674;
            validate_non_negative_index("prior_shift", "K", K);
            context__.validate_dims("data initialization", "prior_shift", "vector_d", context__.to_vec(K));
            prior_shift = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_shift");
            pos__ = 0;
            size_t prior_shift_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_shift_j_1_max__; ++j_1__) {
                prior_shift(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 675;
            validate_non_negative_index("prior_mean_for_intercept", "has_intercept", has_intercept);
            context__.validate_dims("data initialization", "prior_mean_for_intercept", "double", context__.to_vec(has_intercept));
            prior_mean_for_intercept = std::vector<double>(has_intercept, double(0));
            vals_r__ = context__.vals_r("prior_mean_for_intercept");
            pos__ = 0;
            size_t prior_mean_for_intercept_k_0_max__ = has_intercept;
            for (size_t k_0__ = 0; k_0__ < prior_mean_for_intercept_k_0_max__; ++k_0__) {
                prior_mean_for_intercept[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 676;
            validate_non_negative_index("prior_df", "K", K);
            context__.validate_dims("data initialization", "prior_df", "vector_d", context__.to_vec(K));
            prior_df = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_df");
            pos__ = 0;
            size_t prior_df_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_df_j_1_max__; ++j_1__) {
                prior_df(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_df", prior_df, 0);
            current_statement_begin__ = 677;
            validate_non_negative_index("prior_df_for_intercept", "has_intercept", has_intercept);
            context__.validate_dims("data initialization", "prior_df_for_intercept", "double", context__.to_vec(has_intercept));
            prior_df_for_intercept = std::vector<double>(has_intercept, double(0));
            vals_r__ = context__.vals_r("prior_df_for_intercept");
            pos__ = 0;
            size_t prior_df_for_intercept_k_0_max__ = has_intercept;
            for (size_t k_0__ = 0; k_0__ < prior_df_for_intercept_k_0_max__; ++k_0__) {
                prior_df_for_intercept[k_0__] = vals_r__[pos__++];
            }
            size_t prior_df_for_intercept_i_0_max__ = has_intercept;
            for (size_t i_0__ = 0; i_0__ < prior_df_for_intercept_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_df_for_intercept[i_0__]", prior_df_for_intercept[i_0__], 0);
            }
            current_statement_begin__ = 678;
            context__.validate_dims("data initialization", "global_prior_df", "double", context__.to_vec());
            global_prior_df = double(0);
            vals_r__ = context__.vals_r("global_prior_df");
            pos__ = 0;
            global_prior_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "global_prior_df", global_prior_df, 0);
            current_statement_begin__ = 679;
            context__.validate_dims("data initialization", "global_prior_scale", "double", context__.to_vec());
            global_prior_scale = double(0);
            vals_r__ = context__.vals_r("global_prior_scale");
            pos__ = 0;
            global_prior_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "global_prior_scale", global_prior_scale, 0);
            current_statement_begin__ = 680;
            context__.validate_dims("data initialization", "slab_df", "double", context__.to_vec());
            slab_df = double(0);
            vals_r__ = context__.vals_r("slab_df");
            pos__ = 0;
            slab_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_df", slab_df, 0);
            current_statement_begin__ = 681;
            context__.validate_dims("data initialization", "slab_scale", "double", context__.to_vec());
            slab_scale = double(0);
            vals_r__ = context__.vals_r("slab_scale");
            pos__ = 0;
            slab_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_scale", slab_scale, 0);
            current_statement_begin__ = 682;
            validate_non_negative_index("num_normals", "(logical_eq(prior_dist, 7) ? K : 0 )", (logical_eq(prior_dist, 7) ? K : 0 ));
            context__.validate_dims("data initialization", "num_normals", "int", context__.to_vec((logical_eq(prior_dist, 7) ? K : 0 )));
            num_normals = std::vector<int>((logical_eq(prior_dist, 7) ? K : 0 ), int(0));
            vals_i__ = context__.vals_i("num_normals");
            pos__ = 0;
            size_t num_normals_k_0_max__ = (logical_eq(prior_dist, 7) ? K : 0 );
            for (size_t k_0__ = 0; k_0__ < num_normals_k_0_max__; ++k_0__) {
                num_normals[k_0__] = vals_i__[pos__++];
            }
            size_t num_normals_i_0_max__ = (logical_eq(prior_dist, 7) ? K : 0 );
            for (size_t i_0__ = 0; i_0__ < num_normals_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "num_normals[i_0__]", num_normals[i_0__], 2);
            }
            current_statement_begin__ = 685;
            validate_non_negative_index("prior_omean", "K_all", K_all);
            context__.validate_dims("data initialization", "prior_omean", "vector_d", context__.to_vec(K_all));
            prior_omean = Eigen::Matrix<double, Eigen::Dynamic, 1>(K_all);
            vals_r__ = context__.vals_r("prior_omean");
            pos__ = 0;
            size_t prior_omean_j_1_max__ = K_all;
            for (size_t j_1__ = 0; j_1__ < prior_omean_j_1_max__; ++j_1__) {
                prior_omean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 686;
            validate_non_negative_index("prior_oscale", "K_all", K_all);
            context__.validate_dims("data initialization", "prior_oscale", "vector_d", context__.to_vec(K_all));
            prior_oscale = Eigen::Matrix<double, Eigen::Dynamic, 1>(K_all);
            vals_r__ = context__.vals_r("prior_oscale");
            pos__ = 0;
            size_t prior_oscale_j_1_max__ = K_all;
            for (size_t j_1__ = 0; j_1__ < prior_oscale_j_1_max__; ++j_1__) {
                prior_oscale(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_oscale", prior_oscale, 0);
            current_statement_begin__ = 687;
            validate_non_negative_index("prior_mean_for_ointercept", "num_ointercepts", num_ointercepts);
            context__.validate_dims("data initialization", "prior_mean_for_ointercept", "vector_d", context__.to_vec(num_ointercepts));
            prior_mean_for_ointercept = Eigen::Matrix<double, Eigen::Dynamic, 1>(num_ointercepts);
            vals_r__ = context__.vals_r("prior_mean_for_ointercept");
            pos__ = 0;
            size_t prior_mean_for_ointercept_j_1_max__ = num_ointercepts;
            for (size_t j_1__ = 0; j_1__ < prior_mean_for_ointercept_j_1_max__; ++j_1__) {
                prior_mean_for_ointercept(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 688;
            validate_non_negative_index("prior_scale_for_ointercept", "num_ointercepts", num_ointercepts);
            context__.validate_dims("data initialization", "prior_scale_for_ointercept", "vector_d", context__.to_vec(num_ointercepts));
            prior_scale_for_ointercept = Eigen::Matrix<double, Eigen::Dynamic, 1>(num_ointercepts);
            vals_r__ = context__.vals_r("prior_scale_for_ointercept");
            pos__ = 0;
            size_t prior_scale_for_ointercept_j_1_max__ = num_ointercepts;
            for (size_t j_1__ = 0; j_1__ < prior_scale_for_ointercept_j_1_max__; ++j_1__) {
                prior_scale_for_ointercept(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_scale_for_ointercept", prior_scale_for_ointercept, 0);
            current_statement_begin__ = 691;
            validate_non_negative_index("prior_dist_for_oaux", "num_oaux", num_oaux);
            context__.validate_dims("data initialization", "prior_dist_for_oaux", "int", context__.to_vec(num_oaux));
            prior_dist_for_oaux = std::vector<int>(num_oaux, int(0));
            vals_i__ = context__.vals_i("prior_dist_for_oaux");
            pos__ = 0;
            size_t prior_dist_for_oaux_k_0_max__ = num_oaux;
            for (size_t k_0__ = 0; k_0__ < prior_dist_for_oaux_k_0_max__; ++k_0__) {
                prior_dist_for_oaux[k_0__] = vals_i__[pos__++];
            }
            size_t prior_dist_for_oaux_i_0_max__ = num_oaux;
            for (size_t i_0__ = 0; i_0__ < prior_dist_for_oaux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_dist_for_oaux[i_0__]", prior_dist_for_oaux[i_0__], 0);
                check_less_or_equal(function__, "prior_dist_for_oaux[i_0__]", prior_dist_for_oaux[i_0__], 3);
            }
            current_statement_begin__ = 692;
            validate_non_negative_index("prior_mean_for_oaux", "num_oaux", num_oaux);
            context__.validate_dims("data initialization", "prior_mean_for_oaux", "vector_d", context__.to_vec(num_oaux));
            prior_mean_for_oaux = Eigen::Matrix<double, Eigen::Dynamic, 1>(num_oaux);
            vals_r__ = context__.vals_r("prior_mean_for_oaux");
            pos__ = 0;
            size_t prior_mean_for_oaux_j_1_max__ = num_oaux;
            for (size_t j_1__ = 0; j_1__ < prior_mean_for_oaux_j_1_max__; ++j_1__) {
                prior_mean_for_oaux(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 693;
            validate_non_negative_index("prior_scale_for_oaux", "num_oaux", num_oaux);
            context__.validate_dims("data initialization", "prior_scale_for_oaux", "vector_d", context__.to_vec(num_oaux));
            prior_scale_for_oaux = Eigen::Matrix<double, Eigen::Dynamic, 1>(num_oaux);
            vals_r__ = context__.vals_r("prior_scale_for_oaux");
            pos__ = 0;
            size_t prior_scale_for_oaux_j_1_max__ = num_oaux;
            for (size_t j_1__ = 0; j_1__ < prior_scale_for_oaux_j_1_max__; ++j_1__) {
                prior_scale_for_oaux(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_scale_for_oaux", prior_scale_for_oaux, 0);
            current_statement_begin__ = 694;
            validate_non_negative_index("prior_df_for_oaux", "num_oaux", num_oaux);
            context__.validate_dims("data initialization", "prior_df_for_oaux", "vector_d", context__.to_vec(num_oaux));
            prior_df_for_oaux = Eigen::Matrix<double, Eigen::Dynamic, 1>(num_oaux);
            vals_r__ = context__.vals_r("prior_df_for_oaux");
            pos__ = 0;
            size_t prior_df_for_oaux_j_1_max__ = num_oaux;
            for (size_t j_1__ = 0; j_1__ < prior_df_for_oaux_j_1_max__; ++j_1__) {
                prior_df_for_oaux(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_df_for_oaux", prior_df_for_oaux, 0);
            current_statement_begin__ = 697;
            validate_non_negative_index("prior_dist_for_inf_aux", "latent", latent);
            context__.validate_dims("data initialization", "prior_dist_for_inf_aux", "int", context__.to_vec(latent));
            prior_dist_for_inf_aux = std::vector<int>(latent, int(0));
            vals_i__ = context__.vals_i("prior_dist_for_inf_aux");
            pos__ = 0;
            size_t prior_dist_for_inf_aux_k_0_max__ = latent;
            for (size_t k_0__ = 0; k_0__ < prior_dist_for_inf_aux_k_0_max__; ++k_0__) {
                prior_dist_for_inf_aux[k_0__] = vals_i__[pos__++];
            }
            size_t prior_dist_for_inf_aux_i_0_max__ = latent;
            for (size_t i_0__ = 0; i_0__ < prior_dist_for_inf_aux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_dist_for_inf_aux[i_0__]", prior_dist_for_inf_aux[i_0__], 0);
                check_less_or_equal(function__, "prior_dist_for_inf_aux[i_0__]", prior_dist_for_inf_aux[i_0__], 3);
            }
            current_statement_begin__ = 698;
            validate_non_negative_index("prior_mean_for_inf_aux", "latent", latent);
            context__.validate_dims("data initialization", "prior_mean_for_inf_aux", "double", context__.to_vec(latent));
            prior_mean_for_inf_aux = std::vector<double>(latent, double(0));
            vals_r__ = context__.vals_r("prior_mean_for_inf_aux");
            pos__ = 0;
            size_t prior_mean_for_inf_aux_k_0_max__ = latent;
            for (size_t k_0__ = 0; k_0__ < prior_mean_for_inf_aux_k_0_max__; ++k_0__) {
                prior_mean_for_inf_aux[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 699;
            validate_non_negative_index("prior_scale_for_inf_aux", "latent", latent);
            context__.validate_dims("data initialization", "prior_scale_for_inf_aux", "double", context__.to_vec(latent));
            prior_scale_for_inf_aux = std::vector<double>(latent, double(0));
            vals_r__ = context__.vals_r("prior_scale_for_inf_aux");
            pos__ = 0;
            size_t prior_scale_for_inf_aux_k_0_max__ = latent;
            for (size_t k_0__ = 0; k_0__ < prior_scale_for_inf_aux_k_0_max__; ++k_0__) {
                prior_scale_for_inf_aux[k_0__] = vals_r__[pos__++];
            }
            size_t prior_scale_for_inf_aux_i_0_max__ = latent;
            for (size_t i_0__ = 0; i_0__ < prior_scale_for_inf_aux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_scale_for_inf_aux[i_0__]", prior_scale_for_inf_aux[i_0__], 0);
            }
            current_statement_begin__ = 700;
            validate_non_negative_index("prior_df_for_inf_aux", "latent", latent);
            context__.validate_dims("data initialization", "prior_df_for_inf_aux", "double", context__.to_vec(latent));
            prior_df_for_inf_aux = std::vector<double>(latent, double(0));
            vals_r__ = context__.vals_r("prior_df_for_inf_aux");
            pos__ = 0;
            size_t prior_df_for_inf_aux_k_0_max__ = latent;
            for (size_t k_0__ = 0; k_0__ < prior_df_for_inf_aux_k_0_max__; ++k_0__) {
                prior_df_for_inf_aux[k_0__] = vals_r__[pos__++];
            }
            size_t prior_df_for_inf_aux_i_0_max__ = latent;
            for (size_t i_0__ = 0; i_0__ < prior_df_for_inf_aux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_df_for_inf_aux[i_0__]", prior_df_for_inf_aux[i_0__], 0);
            }
            current_statement_begin__ = 703;
            validate_non_negative_index("prior_dist_for_seeds_aux", "hseeds", hseeds);
            context__.validate_dims("data initialization", "prior_dist_for_seeds_aux", "int", context__.to_vec(hseeds));
            prior_dist_for_seeds_aux = std::vector<int>(hseeds, int(0));
            vals_i__ = context__.vals_i("prior_dist_for_seeds_aux");
            pos__ = 0;
            size_t prior_dist_for_seeds_aux_k_0_max__ = hseeds;
            for (size_t k_0__ = 0; k_0__ < prior_dist_for_seeds_aux_k_0_max__; ++k_0__) {
                prior_dist_for_seeds_aux[k_0__] = vals_i__[pos__++];
            }
            size_t prior_dist_for_seeds_aux_i_0_max__ = hseeds;
            for (size_t i_0__ = 0; i_0__ < prior_dist_for_seeds_aux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_dist_for_seeds_aux[i_0__]", prior_dist_for_seeds_aux[i_0__], 0);
                check_less_or_equal(function__, "prior_dist_for_seeds_aux[i_0__]", prior_dist_for_seeds_aux[i_0__], 3);
            }
            current_statement_begin__ = 704;
            validate_non_negative_index("prior_mean_for_seeds_aux", "hseeds", hseeds);
            context__.validate_dims("data initialization", "prior_mean_for_seeds_aux", "vector_d", context__.to_vec(hseeds));
            prior_mean_for_seeds_aux = Eigen::Matrix<double, Eigen::Dynamic, 1>(hseeds);
            vals_r__ = context__.vals_r("prior_mean_for_seeds_aux");
            pos__ = 0;
            size_t prior_mean_for_seeds_aux_j_1_max__ = hseeds;
            for (size_t j_1__ = 0; j_1__ < prior_mean_for_seeds_aux_j_1_max__; ++j_1__) {
                prior_mean_for_seeds_aux(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 705;
            validate_non_negative_index("prior_scale_for_seeds_aux", "hseeds", hseeds);
            context__.validate_dims("data initialization", "prior_scale_for_seeds_aux", "vector_d", context__.to_vec(hseeds));
            prior_scale_for_seeds_aux = Eigen::Matrix<double, Eigen::Dynamic, 1>(hseeds);
            vals_r__ = context__.vals_r("prior_scale_for_seeds_aux");
            pos__ = 0;
            size_t prior_scale_for_seeds_aux_j_1_max__ = hseeds;
            for (size_t j_1__ = 0; j_1__ < prior_scale_for_seeds_aux_j_1_max__; ++j_1__) {
                prior_scale_for_seeds_aux(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_scale_for_seeds_aux", prior_scale_for_seeds_aux, 0);
            current_statement_begin__ = 706;
            validate_non_negative_index("prior_df_for_seeds_aux", "hseeds", hseeds);
            context__.validate_dims("data initialization", "prior_df_for_seeds_aux", "vector_d", context__.to_vec(hseeds));
            prior_df_for_seeds_aux = Eigen::Matrix<double, Eigen::Dynamic, 1>(hseeds);
            vals_r__ = context__.vals_r("prior_df_for_seeds_aux");
            pos__ = 0;
            size_t prior_df_for_seeds_aux_j_1_max__ = hseeds;
            for (size_t j_1__ = 0; j_1__ < prior_df_for_seeds_aux_j_1_max__; ++j_1__) {
                prior_df_for_seeds_aux(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_df_for_seeds_aux", prior_df_for_seeds_aux, 0);
            current_statement_begin__ = 709;
            context__.validate_dims("data initialization", "prior_dist_for_seeds", "int", context__.to_vec());
            prior_dist_for_seeds = int(0);
            vals_i__ = context__.vals_i("prior_dist_for_seeds");
            pos__ = 0;
            prior_dist_for_seeds = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_dist_for_seeds", prior_dist_for_seeds, 0);
            check_less_or_equal(function__, "prior_dist_for_seeds", prior_dist_for_seeds, 9);
            current_statement_begin__ = 710;
            validate_non_negative_index("prior_mean_for_seeds", "M", M);
            context__.validate_dims("data initialization", "prior_mean_for_seeds", "vector_d", context__.to_vec(M));
            prior_mean_for_seeds = Eigen::Matrix<double, Eigen::Dynamic, 1>(M);
            vals_r__ = context__.vals_r("prior_mean_for_seeds");
            pos__ = 0;
            size_t prior_mean_for_seeds_j_1_max__ = M;
            for (size_t j_1__ = 0; j_1__ < prior_mean_for_seeds_j_1_max__; ++j_1__) {
                prior_mean_for_seeds(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 711;
            validate_non_negative_index("prior_scale_for_seeds", "M", M);
            context__.validate_dims("data initialization", "prior_scale_for_seeds", "vector_d", context__.to_vec(M));
            prior_scale_for_seeds = Eigen::Matrix<double, Eigen::Dynamic, 1>(M);
            vals_r__ = context__.vals_r("prior_scale_for_seeds");
            pos__ = 0;
            size_t prior_scale_for_seeds_j_1_max__ = M;
            for (size_t j_1__ = 0; j_1__ < prior_scale_for_seeds_j_1_max__; ++j_1__) {
                prior_scale_for_seeds(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_scale_for_seeds", prior_scale_for_seeds, 0);
            current_statement_begin__ = 712;
            validate_non_negative_index("prior_df_for_seeds", "M", M);
            context__.validate_dims("data initialization", "prior_df_for_seeds", "vector_d", context__.to_vec(M));
            prior_df_for_seeds = Eigen::Matrix<double, Eigen::Dynamic, 1>(M);
            vals_r__ = context__.vals_r("prior_df_for_seeds");
            pos__ = 0;
            size_t prior_df_for_seeds_j_1_max__ = M;
            for (size_t j_1__ = 0; j_1__ < prior_df_for_seeds_j_1_max__; ++j_1__) {
                prior_df_for_seeds(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_df_for_seeds", prior_df_for_seeds, 0);
            current_statement_begin__ = 714;
            validate_non_negative_index("ac_prior_scales", "ac_nproc", ac_nproc);
            context__.validate_dims("data initialization", "ac_prior_scales", "vector_d", context__.to_vec(ac_nproc));
            ac_prior_scales = Eigen::Matrix<double, Eigen::Dynamic, 1>(ac_nproc);
            vals_r__ = context__.vals_r("ac_prior_scales");
            pos__ = 0;
            size_t ac_prior_scales_j_1_max__ = ac_nproc;
            for (size_t j_1__ = 0; j_1__ < ac_prior_scales_j_1_max__; ++j_1__) {
                ac_prior_scales(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "ac_prior_scales", ac_prior_scales, 0);
            current_statement_begin__ = 715;
            validate_non_negative_index("obs_ac_prior_scales", "obs_ac_nproc", obs_ac_nproc);
            context__.validate_dims("data initialization", "obs_ac_prior_scales", "vector_d", context__.to_vec(obs_ac_nproc));
            obs_ac_prior_scales = Eigen::Matrix<double, Eigen::Dynamic, 1>(obs_ac_nproc);
            vals_r__ = context__.vals_r("obs_ac_prior_scales");
            pos__ = 0;
            size_t obs_ac_prior_scales_j_1_max__ = obs_ac_nproc;
            for (size_t j_1__ = 0; j_1__ < obs_ac_prior_scales_j_1_max__; ++j_1__) {
                obs_ac_prior_scales(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "obs_ac_prior_scales", obs_ac_prior_scales, 0);
            current_statement_begin__ = 717;
            validate_non_negative_index("prior_mean_for_S0", "(S0_fixed ? 0 : M )", (S0_fixed ? 0 : M ));
            context__.validate_dims("data initialization", "prior_mean_for_S0", "double", context__.to_vec((S0_fixed ? 0 : M )));
            prior_mean_for_S0 = std::vector<double>((S0_fixed ? 0 : M ), double(0));
            vals_r__ = context__.vals_r("prior_mean_for_S0");
            pos__ = 0;
            size_t prior_mean_for_S0_k_0_max__ = (S0_fixed ? 0 : M );
            for (size_t k_0__ = 0; k_0__ < prior_mean_for_S0_k_0_max__; ++k_0__) {
                prior_mean_for_S0[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 718;
            validate_non_negative_index("prior_scale_for_S0", "(S0_fixed ? 0 : M )", (S0_fixed ? 0 : M ));
            context__.validate_dims("data initialization", "prior_scale_for_S0", "double", context__.to_vec((S0_fixed ? 0 : M )));
            prior_scale_for_S0 = std::vector<double>((S0_fixed ? 0 : M ), double(0));
            vals_r__ = context__.vals_r("prior_scale_for_S0");
            pos__ = 0;
            size_t prior_scale_for_S0_k_0_max__ = (S0_fixed ? 0 : M );
            for (size_t k_0__ = 0; k_0__ < prior_scale_for_S0_k_0_max__; ++k_0__) {
                prior_scale_for_S0[k_0__] = vals_r__[pos__++];
            }
            size_t prior_scale_for_S0_i_0_max__ = (S0_fixed ? 0 : M );
            for (size_t i_0__ = 0; i_0__ < prior_scale_for_S0_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_scale_for_S0[i_0__]", prior_scale_for_S0[i_0__], 0);
            }
            current_statement_begin__ = 720;
            validate_non_negative_index("prior_mean_for_veps", "(veps_fixed ? 0 : M )", (veps_fixed ? 0 : M ));
            context__.validate_dims("data initialization", "prior_mean_for_veps", "double", context__.to_vec((veps_fixed ? 0 : M )));
            prior_mean_for_veps = std::vector<double>((veps_fixed ? 0 : M ), double(0));
            vals_r__ = context__.vals_r("prior_mean_for_veps");
            pos__ = 0;
            size_t prior_mean_for_veps_k_0_max__ = (veps_fixed ? 0 : M );
            for (size_t k_0__ = 0; k_0__ < prior_mean_for_veps_k_0_max__; ++k_0__) {
                prior_mean_for_veps[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 721;
            validate_non_negative_index("prior_scale_for_veps", "(veps_fixed ? 0 : M )", (veps_fixed ? 0 : M ));
            context__.validate_dims("data initialization", "prior_scale_for_veps", "double", context__.to_vec((veps_fixed ? 0 : M )));
            prior_scale_for_veps = std::vector<double>((veps_fixed ? 0 : M ), double(0));
            vals_r__ = context__.vals_r("prior_scale_for_veps");
            pos__ = 0;
            size_t prior_scale_for_veps_k_0_max__ = (veps_fixed ? 0 : M );
            for (size_t k_0__ = 0; k_0__ < prior_scale_for_veps_k_0_max__; ++k_0__) {
                prior_scale_for_veps[k_0__] = vals_r__[pos__++];
            }
            size_t prior_scale_for_veps_i_0_max__ = (veps_fixed ? 0 : M );
            for (size_t i_0__ = 0; i_0__ < prior_scale_for_veps_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_scale_for_veps[i_0__]", prior_scale_for_veps[i_0__], 0);
            }
            current_statement_begin__ = 725;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            check_greater_or_equal(function__, "t", t, 0);
            current_statement_begin__ = 726;
            validate_non_negative_index("p", "t", t);
            context__.validate_dims("data initialization", "p", "int", context__.to_vec(t));
            p = std::vector<int>(t, int(0));
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            size_t p_k_0_max__ = t;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                p[k_0__] = vals_i__[pos__++];
            }
            size_t p_i_0_max__ = t;
            for (size_t i_0__ = 0; i_0__ < p_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "p[i_0__]", p[i_0__], 1);
            }
            current_statement_begin__ = 727;
            validate_non_negative_index("l", "t", t);
            context__.validate_dims("data initialization", "l", "int", context__.to_vec(t));
            l = std::vector<int>(t, int(0));
            vals_i__ = context__.vals_i("l");
            pos__ = 0;
            size_t l_k_0_max__ = t;
            for (size_t k_0__ = 0; k_0__ < l_k_0_max__; ++k_0__) {
                l[k_0__] = vals_i__[pos__++];
            }
            size_t l_i_0_max__ = t;
            for (size_t i_0__ = 0; i_0__ < l_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "l[i_0__]", l[i_0__], 1);
            }
            current_statement_begin__ = 728;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 0);
            current_statement_begin__ = 729;
            context__.validate_dims("data initialization", "len_theta_L", "int", context__.to_vec());
            len_theta_L = int(0);
            vals_i__ = context__.vals_i("len_theta_L");
            pos__ = 0;
            len_theta_L = vals_i__[pos__++];
            check_greater_or_equal(function__, "len_theta_L", len_theta_L, 0);
            current_statement_begin__ = 732;
            validate_non_negative_index("shape", "t", t);
            context__.validate_dims("data initialization", "shape", "vector_d", context__.to_vec(t));
            shape = Eigen::Matrix<double, Eigen::Dynamic, 1>(t);
            vals_r__ = context__.vals_r("shape");
            pos__ = 0;
            size_t shape_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < shape_j_1_max__; ++j_1__) {
                shape(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "shape", shape, 0);
            current_statement_begin__ = 733;
            validate_non_negative_index("scale", "t", t);
            context__.validate_dims("data initialization", "scale", "vector_d", context__.to_vec(t));
            scale = Eigen::Matrix<double, Eigen::Dynamic, 1>(t);
            vals_r__ = context__.vals_r("scale");
            pos__ = 0;
            size_t scale_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < scale_j_1_max__; ++j_1__) {
                scale(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "scale", scale, 0);
            current_statement_begin__ = 734;
            context__.validate_dims("data initialization", "len_concentration", "int", context__.to_vec());
            len_concentration = int(0);
            vals_i__ = context__.vals_i("len_concentration");
            pos__ = 0;
            len_concentration = vals_i__[pos__++];
            check_greater_or_equal(function__, "len_concentration", len_concentration, 0);
            current_statement_begin__ = 735;
            validate_non_negative_index("concentration", "len_concentration", len_concentration);
            context__.validate_dims("data initialization", "concentration", "double", context__.to_vec(len_concentration));
            concentration = std::vector<double>(len_concentration, double(0));
            vals_r__ = context__.vals_r("concentration");
            pos__ = 0;
            size_t concentration_k_0_max__ = len_concentration;
            for (size_t k_0__ = 0; k_0__ < concentration_k_0_max__; ++k_0__) {
                concentration[k_0__] = vals_r__[pos__++];
            }
            size_t concentration_i_0_max__ = len_concentration;
            for (size_t i_0__ = 0; i_0__ < concentration_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "concentration[i_0__]", concentration[i_0__], 0);
            }
            current_statement_begin__ = 736;
            context__.validate_dims("data initialization", "len_regularization", "int", context__.to_vec());
            len_regularization = int(0);
            vals_i__ = context__.vals_i("len_regularization");
            pos__ = 0;
            len_regularization = vals_i__[pos__++];
            check_greater_or_equal(function__, "len_regularization", len_regularization, 0);
            current_statement_begin__ = 737;
            validate_non_negative_index("regularization", "len_regularization", len_regularization);
            context__.validate_dims("data initialization", "regularization", "double", context__.to_vec(len_regularization));
            regularization = std::vector<double>(len_regularization, double(0));
            vals_r__ = context__.vals_r("regularization");
            pos__ = 0;
            size_t regularization_k_0_max__ = len_regularization;
            for (size_t k_0__ = 0; k_0__ < regularization_k_0_max__; ++k_0__) {
                regularization[k_0__] = vals_r__[pos__++];
            }
            size_t regularization_i_0_max__ = len_regularization;
            for (size_t i_0__ = 0; i_0__ < regularization_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "regularization[i_0__]", regularization[i_0__], 0);
            }
            current_statement_begin__ = 738;
            context__.validate_dims("data initialization", "num_non_zero", "int", context__.to_vec());
            num_non_zero = int(0);
            vals_i__ = context__.vals_i("num_non_zero");
            pos__ = 0;
            num_non_zero = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_non_zero", num_non_zero, 0);
            current_statement_begin__ = 739;
            validate_non_negative_index("w", "num_non_zero", num_non_zero);
            context__.validate_dims("data initialization", "w", "vector_d", context__.to_vec(num_non_zero));
            w = Eigen::Matrix<double, Eigen::Dynamic, 1>(num_non_zero);
            vals_r__ = context__.vals_r("w");
            pos__ = 0;
            size_t w_j_1_max__ = num_non_zero;
            for (size_t j_1__ = 0; j_1__ < w_j_1_max__; ++j_1__) {
                w(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 740;
            validate_non_negative_index("v", "num_non_zero", num_non_zero);
            context__.validate_dims("data initialization", "v", "int", context__.to_vec(num_non_zero));
            v = std::vector<int>(num_non_zero, int(0));
            vals_i__ = context__.vals_i("v");
            pos__ = 0;
            size_t v_k_0_max__ = num_non_zero;
            for (size_t k_0__ = 0; k_0__ < v_k_0_max__; ++k_0__) {
                v[k_0__] = vals_i__[pos__++];
            }
            size_t v_i_0_max__ = num_non_zero;
            for (size_t i_0__ = 0; i_0__ < v_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "v[i_0__]", v[i_0__], 0);
                check_less_or_equal(function__, "v[i_0__]", v[i_0__], (q - 1));
            }
            current_statement_begin__ = 741;
            validate_non_negative_index("u", "(logical_gt(t, 0) ? (N + 1) : 0 )", (logical_gt(t, 0) ? (N + 1) : 0 ));
            context__.validate_dims("data initialization", "u", "int", context__.to_vec((logical_gt(t, 0) ? (N + 1) : 0 )));
            u = std::vector<int>((logical_gt(t, 0) ? (N + 1) : 0 ), int(0));
            vals_i__ = context__.vals_i("u");
            pos__ = 0;
            size_t u_k_0_max__ = (logical_gt(t, 0) ? (N + 1) : 0 );
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                u[k_0__] = vals_i__[pos__++];
            }
            size_t u_i_0_max__ = (logical_gt(t, 0) ? (N + 1) : 0 );
            for (size_t i_0__ = 0; i_0__ < u_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "u[i_0__]", u[i_0__], 0);
                check_less_or_equal(function__, "u[i_0__]", u[i_0__], (rows(w) + 1));
            }
            current_statement_begin__ = 742;
            context__.validate_dims("data initialization", "special_case", "int", context__.to_vec());
            special_case = int(0);
            vals_i__ = context__.vals_i("special_case");
            pos__ = 0;
            special_case = vals_i__[pos__++];
            check_greater_or_equal(function__, "special_case", special_case, 0);
            check_less_or_equal(function__, "special_case", special_case, 1);
            // initialize transformed data variables
            current_statement_begin__ = 746;
            aux = double(0);
            stan::math::fill(aux, DUMMY_VAR__);
            stan::math::assign(aux,stan::math::not_a_number());
            current_statement_begin__ = 747;
            validate_non_negative_index("V", "(special_case ? t : 0 )", (special_case ? t : 0 ));
            validate_non_negative_index("V", "N", N);
            V = std::vector<std::vector<int> >((special_case ? t : 0 ), std::vector<int>(N, int(0)));
            stan::math::fill(V, std::numeric_limits<int>::min());
            stan::math::assign(V,make_V(N, (special_case ? t : 0 ), v, pstream__));
            current_statement_begin__ = 748;
            validate_non_negative_index("ac_V", "ac_nterms", ac_nterms);
            validate_non_negative_index("ac_V", "N", N);
            ac_V = std::vector<std::vector<int> >(ac_nterms, std::vector<int>(N, int(0)));
            stan::math::fill(ac_V, std::numeric_limits<int>::min());
            stan::math::assign(ac_V,make_V(N, ac_nterms, ac_v, pstream__));
            current_statement_begin__ = 750;
            validate_non_negative_index("gen_rev", "gen_len", gen_len);
            gen_rev = Eigen::Matrix<double, Eigen::Dynamic, 1>(gen_len);
            stan::math::fill(gen_rev, DUMMY_VAR__);
            stan::math::assign(gen_rev,reverse2(gen, pstream__));
            current_statement_begin__ = 751;
            validate_non_negative_index("pvecs_rev", "NS", NS);
            validate_non_negative_index("pvecs_rev", "R", R);
            pvecs_rev = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(R, Eigen::Matrix<double, Eigen::Dynamic, 1>(NS));
            stan::math::fill(pvecs_rev, DUMMY_VAR__);
            current_statement_begin__ = 753;
            len_z_T = int(0);
            stan::math::fill(len_z_T, std::numeric_limits<int>::min());
            stan::math::assign(len_z_T,0);
            current_statement_begin__ = 754;
            len_var_group = int(0);
            stan::math::fill(len_var_group, std::numeric_limits<int>::min());
            stan::math::assign(len_var_group,(sum(p) * logical_gt(t, 0)));
            current_statement_begin__ = 755;
            len_rho = int(0);
            stan::math::fill(len_rho, std::numeric_limits<int>::min());
            stan::math::assign(len_rho,(sum(p) - t));
            current_statement_begin__ = 756;
            pos = int(0);
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);
            current_statement_begin__ = 757;
            validate_non_negative_index("delta", "len_concentration", len_concentration);
            delta = std::vector<double>(len_concentration, double(0));
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 758;
            hs = int(0);
            stan::math::fill(hs, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 759;
            if (as_bool(logical_lte(prior_dist, 2))) {
                current_statement_begin__ = 759;
                stan::math::assign(hs, 0);
            } else if (as_bool(logical_eq(prior_dist, 3))) {
                current_statement_begin__ = 760;
                stan::math::assign(hs, 2);
            } else if (as_bool(logical_eq(prior_dist, 4))) {
                current_statement_begin__ = 761;
                stan::math::assign(hs, 4);
            } else {
                current_statement_begin__ = 762;
                stan::math::assign(hs, 0);
            }
            current_statement_begin__ = 764;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 765;
                if (as_bool(logical_gt(get_base1(p, i, "p", 1), 1))) {
                    current_statement_begin__ = 766;
                    for (int j = 1; j <= get_base1(p, i, "p", 1); ++j) {
                        current_statement_begin__ = 767;
                        stan::model::assign(delta, 
                                    stan::model::cons_list(stan::model::index_uni(pos), stan::model::nil_index_list()), 
                                    get_base1(concentration, j, "concentration", 1), 
                                    "assigning variable delta");
                        current_statement_begin__ = 768;
                        stan::math::assign(pos, (pos + 1));
                    }
                }
                current_statement_begin__ = 771;
                for (int j = 3; j <= get_base1(p, i, "p", 1); ++j) {
                    current_statement_begin__ = 771;
                    stan::math::assign(len_z_T, (len_z_T + (get_base1(p, i, "p", 1) - 1)));
                }
            }
            current_statement_begin__ = 774;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 775;
                stan::model::assign(pvecs_rev, 
                            stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list()), 
                            reverse2(get_base1(pvecs, r, "pvecs", 1), pstream__), 
                            "assigning variable pvecs_rev");
            }
            // validate transformed data
            current_statement_begin__ = 747;
            size_t V_i_0_max__ = (special_case ? t : 0 );
            size_t V_i_1_max__ = N;
            for (size_t i_0__ = 0; i_0__ < V_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < V_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "V[i_0__][i_1__]", V[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 748;
            size_t ac_V_i_0_max__ = ac_nterms;
            size_t ac_V_i_1_max__ = N;
            for (size_t i_0__ = 0; i_0__ < ac_V_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < ac_V_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "ac_V[i_0__][i_1__]", ac_V[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 750;
            stan::math::check_simplex(function__, "gen_rev", gen_rev);
            current_statement_begin__ = 751;
            size_t pvecs_rev_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < pvecs_rev_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pvecs_rev[i_0__]", pvecs_rev[i_0__], 0);
            }
            current_statement_begin__ = 753;
            check_greater_or_equal(function__, "len_z_T", len_z_T, 0);
            current_statement_begin__ = 754;
            check_greater_or_equal(function__, "len_var_group", len_var_group, 0);
            current_statement_begin__ = 755;
            check_greater_or_equal(function__, "len_rho", len_rho, 0);
            current_statement_begin__ = 756;
            check_greater_or_equal(function__, "pos", pos, 1);
            current_statement_begin__ = 757;
            size_t delta_i_0_max__ = len_concentration;
            for (size_t i_0__ = 0; i_0__ < delta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "delta[i_0__]", delta[i_0__], 0);
            }
            current_statement_begin__ = 758;
            check_greater_or_equal(function__, "hs", hs, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 780;
            validate_non_negative_index("ogamma", "num_ointercepts", num_ointercepts);
            num_params_r__ += num_ointercepts;
            current_statement_begin__ = 781;
            validate_non_negative_index("gamma_raw", "has_intercept", has_intercept);
            num_params_r__ += has_intercept;
            current_statement_begin__ = 782;
            validate_non_negative_index("oaux_raw", "num_oaux", num_oaux);
            num_params_r__ += num_oaux;
            current_statement_begin__ = 783;
            validate_non_negative_index("inf_aux_raw", "latent", latent);
            num_params_r__ += latent;
            current_statement_begin__ = 784;
            validate_non_negative_index("z_beta", "(logical_eq(prior_dist, 7) ? sum(num_normals) : K )", (logical_eq(prior_dist, 7) ? sum(num_normals) : K ));
            num_params_r__ += (logical_eq(prior_dist, 7) ? sum(num_normals) : K );
            current_statement_begin__ = 785;
            validate_non_negative_index("global", "hs", hs);
            num_params_r__ += (1 * hs);
            current_statement_begin__ = 786;
            validate_non_negative_index("local", "K", K);
            validate_non_negative_index("local", "hs", hs);
            num_params_r__ += (K * hs);
            current_statement_begin__ = 787;
            validate_non_negative_index("caux", "logical_gt(hs, 0)", logical_gt(hs, 0));
            num_params_r__ += (1 * logical_gt(hs, 0));
            current_statement_begin__ = 788;
            validate_non_negative_index("mix", "K", K);
            validate_non_negative_index("mix", "(primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)))", (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6))));
            num_params_r__ += (K * (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6))));
            current_statement_begin__ = 789;
            validate_non_negative_index("one_over_lambda", "logical_eq(prior_dist, 6)", logical_eq(prior_dist, 6));
            num_params_r__ += (1 * logical_eq(prior_dist, 6));
            current_statement_begin__ = 790;
            validate_non_negative_index("z_b", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 791;
            validate_non_negative_index("z_T", "len_z_T", len_z_T);
            num_params_r__ += len_z_T;
            current_statement_begin__ = 792;
            validate_non_negative_index("rho", "len_rho", len_rho);
            num_params_r__ += len_rho;
            current_statement_begin__ = 793;
            validate_non_negative_index("zeta", "len_concentration", len_concentration);
            num_params_r__ += len_concentration;
            current_statement_begin__ = 794;
            validate_non_negative_index("tau", "t", t);
            num_params_r__ += t;
            current_statement_begin__ = 796;
            validate_non_negative_index("ac_scale_raw", "ac_nproc", ac_nproc);
            num_params_r__ += ac_nproc;
            current_statement_begin__ = 797;
            validate_non_negative_index("ac_noise", "ac_q", ac_q);
            num_params_r__ += ac_q;
            current_statement_begin__ = 799;
            validate_non_negative_index("obs_ac_scale_raw", "obs_ac_nproc", obs_ac_nproc);
            num_params_r__ += obs_ac_nproc;
            current_statement_begin__ = 800;
            validate_non_negative_index("obs_ac_noise", "obs_ac_q", obs_ac_q);
            num_params_r__ += obs_ac_q;
            current_statement_begin__ = 801;
            validate_non_negative_index("oz_beta", "K_all", K_all);
            num_params_r__ += K_all;
            current_statement_begin__ = 803;
            validate_non_negative_index("seeds_aux_raw", "hseeds", hseeds);
            num_params_r__ += hseeds;
            current_statement_begin__ = 804;
            validate_non_negative_index("seeds_raw", "M", M);
            num_params_r__ += M;
            current_statement_begin__ = 805;
            validate_non_negative_index("infections_raw", "(latent ? (N - (M * N0)) : 0 )", (latent ? (N - (M * N0)) : 0 ));
            num_params_r__ += (latent ? (N - (M * N0)) : 0 );
            current_statement_begin__ = 806;
            validate_non_negative_index("S0", "(S0_fixed ? 0 : M )", (S0_fixed ? 0 : M ));
            num_params_r__ += (S0_fixed ? 0 : M );
            current_statement_begin__ = 807;
            validate_non_negative_index("veps", "(veps_fixed ? 0 : M )", (veps_fixed ? 0 : M ));
            num_params_r__ += (veps_fixed ? 0 : M );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_epidemia_base() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 780;
        if (!(context__.contains_r("ogamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ogamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ogamma");
        pos__ = 0U;
        validate_non_negative_index("ogamma", "num_ointercepts", num_ointercepts);
        context__.validate_dims("parameter initialization", "ogamma", "vector_d", context__.to_vec(num_ointercepts));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ogamma(num_ointercepts);
        size_t ogamma_j_1_max__ = num_ointercepts;
        for (size_t j_1__ = 0; j_1__ < ogamma_j_1_max__; ++j_1__) {
            ogamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(ogamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ogamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 781;
        if (!(context__.contains_r("gamma_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma_raw");
        pos__ = 0U;
        validate_non_negative_index("gamma_raw", "has_intercept", has_intercept);
        context__.validate_dims("parameter initialization", "gamma_raw", "vector_d", context__.to_vec(has_intercept));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_raw(has_intercept);
        size_t gamma_raw_j_1_max__ = has_intercept;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            gamma_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 782;
        if (!(context__.contains_r("oaux_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable oaux_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("oaux_raw");
        pos__ = 0U;
        validate_non_negative_index("oaux_raw", "num_oaux", num_oaux);
        context__.validate_dims("parameter initialization", "oaux_raw", "vector_d", context__.to_vec(num_oaux));
        Eigen::Matrix<double, Eigen::Dynamic, 1> oaux_raw(num_oaux);
        size_t oaux_raw_j_1_max__ = num_oaux;
        for (size_t j_1__ = 0; j_1__ < oaux_raw_j_1_max__; ++j_1__) {
            oaux_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, oaux_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable oaux_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 783;
        if (!(context__.contains_r("inf_aux_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable inf_aux_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("inf_aux_raw");
        pos__ = 0U;
        validate_non_negative_index("inf_aux_raw", "latent", latent);
        context__.validate_dims("parameter initialization", "inf_aux_raw", "vector_d", context__.to_vec(latent));
        Eigen::Matrix<double, Eigen::Dynamic, 1> inf_aux_raw(latent);
        size_t inf_aux_raw_j_1_max__ = latent;
        for (size_t j_1__ = 0; j_1__ < inf_aux_raw_j_1_max__; ++j_1__) {
            inf_aux_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, inf_aux_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable inf_aux_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 784;
        if (!(context__.contains_r("z_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_beta");
        pos__ = 0U;
        validate_non_negative_index("z_beta", "(logical_eq(prior_dist, 7) ? sum(num_normals) : K )", (logical_eq(prior_dist, 7) ? sum(num_normals) : K ));
        context__.validate_dims("parameter initialization", "z_beta", "vector_d", context__.to_vec((logical_eq(prior_dist, 7) ? sum(num_normals) : K )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_beta((logical_eq(prior_dist, 7) ? sum(num_normals) : K ));
        size_t z_beta_j_1_max__ = (logical_eq(prior_dist, 7) ? sum(num_normals) : K );
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            z_beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_ub_unconstrain((logical_eq(prior_dist, 8) ? stan::math::promote_scalar<double>(0) : stan::math::promote_scalar<double>(stan::math::positive_infinity()) ), z_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 785;
        if (!(context__.contains_r("global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("global");
        pos__ = 0U;
        validate_non_negative_index("global", "hs", hs);
        context__.validate_dims("parameter initialization", "global", "double", context__.to_vec(hs));
        std::vector<double> global(hs, double(0));
        size_t global_k_0_max__ = hs;
        for (size_t k_0__ = 0; k_0__ < global_k_0_max__; ++k_0__) {
            global[k_0__] = vals_r__[pos__++];
        }
        size_t global_i_0_max__ = hs;
        for (size_t i_0__ = 0; i_0__ < global_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, global[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable global: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 786;
        if (!(context__.contains_r("local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("local");
        pos__ = 0U;
        validate_non_negative_index("local", "K", K);
        validate_non_negative_index("local", "hs", hs);
        context__.validate_dims("parameter initialization", "local", "vector_d", context__.to_vec(hs,K));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > local(hs, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
        size_t local_j_1_max__ = K;
        size_t local_k_0_max__ = hs;
        for (size_t j_1__ = 0; j_1__ < local_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < local_k_0_max__; ++k_0__) {
                local[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t local_i_0_max__ = hs;
        for (size_t i_0__ = 0; i_0__ < local_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lb_unconstrain(0, local[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable local: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 787;
        if (!(context__.contains_r("caux")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable caux missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("caux");
        pos__ = 0U;
        validate_non_negative_index("caux", "logical_gt(hs, 0)", logical_gt(hs, 0));
        context__.validate_dims("parameter initialization", "caux", "double", context__.to_vec(logical_gt(hs, 0)));
        std::vector<double> caux(logical_gt(hs, 0), double(0));
        size_t caux_k_0_max__ = logical_gt(hs, 0);
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            caux[k_0__] = vals_r__[pos__++];
        }
        size_t caux_i_0_max__ = logical_gt(hs, 0);
        for (size_t i_0__ = 0; i_0__ < caux_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, caux[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable caux: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 788;
        if (!(context__.contains_r("mix")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mix missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mix");
        pos__ = 0U;
        validate_non_negative_index("mix", "K", K);
        validate_non_negative_index("mix", "(primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)))", (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6))));
        context__.validate_dims("parameter initialization", "mix", "vector_d", context__.to_vec((primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6))),K));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mix((primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6))), Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
        size_t mix_j_1_max__ = K;
        size_t mix_k_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
        for (size_t j_1__ = 0; j_1__ < mix_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mix_k_0_max__; ++k_0__) {
                mix[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t mix_i_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
        for (size_t i_0__ = 0; i_0__ < mix_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lb_unconstrain(0, mix[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mix: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 789;
        if (!(context__.contains_r("one_over_lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable one_over_lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("one_over_lambda");
        pos__ = 0U;
        validate_non_negative_index("one_over_lambda", "logical_eq(prior_dist, 6)", logical_eq(prior_dist, 6));
        context__.validate_dims("parameter initialization", "one_over_lambda", "double", context__.to_vec(logical_eq(prior_dist, 6)));
        std::vector<double> one_over_lambda(logical_eq(prior_dist, 6), double(0));
        size_t one_over_lambda_k_0_max__ = logical_eq(prior_dist, 6);
        for (size_t k_0__ = 0; k_0__ < one_over_lambda_k_0_max__; ++k_0__) {
            one_over_lambda[k_0__] = vals_r__[pos__++];
        }
        size_t one_over_lambda_i_0_max__ = logical_eq(prior_dist, 6);
        for (size_t i_0__ = 0; i_0__ < one_over_lambda_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, one_over_lambda[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable one_over_lambda: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 790;
        if (!(context__.contains_r("z_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_b");
        pos__ = 0U;
        validate_non_negative_index("z_b", "q", q);
        context__.validate_dims("parameter initialization", "z_b", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_b(q);
        size_t z_b_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < z_b_j_1_max__; ++j_1__) {
            z_b(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(z_b);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_b: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 791;
        if (!(context__.contains_r("z_T")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_T missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_T");
        pos__ = 0U;
        validate_non_negative_index("z_T", "len_z_T", len_z_T);
        context__.validate_dims("parameter initialization", "z_T", "vector_d", context__.to_vec(len_z_T));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_T(len_z_T);
        size_t z_T_j_1_max__ = len_z_T;
        for (size_t j_1__ = 0; j_1__ < z_T_j_1_max__; ++j_1__) {
            z_T(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(z_T);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_T: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 792;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "len_rho", len_rho);
        context__.validate_dims("parameter initialization", "rho", "vector_d", context__.to_vec(len_rho));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho(len_rho);
        size_t rho_j_1_max__ = len_rho;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            rho(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 793;
        if (!(context__.contains_r("zeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        validate_non_negative_index("zeta", "len_concentration", len_concentration);
        context__.validate_dims("parameter initialization", "zeta", "vector_d", context__.to_vec(len_concentration));
        Eigen::Matrix<double, Eigen::Dynamic, 1> zeta(len_concentration);
        size_t zeta_j_1_max__ = len_concentration;
        for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
            zeta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, zeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 794;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "t", t);
        context__.validate_dims("parameter initialization", "tau", "vector_d", context__.to_vec(t));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau(t);
        size_t tau_j_1_max__ = t;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 796;
        if (!(context__.contains_r("ac_scale_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ac_scale_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ac_scale_raw");
        pos__ = 0U;
        validate_non_negative_index("ac_scale_raw", "ac_nproc", ac_nproc);
        context__.validate_dims("parameter initialization", "ac_scale_raw", "vector_d", context__.to_vec(ac_nproc));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ac_scale_raw(ac_nproc);
        size_t ac_scale_raw_j_1_max__ = ac_nproc;
        for (size_t j_1__ = 0; j_1__ < ac_scale_raw_j_1_max__; ++j_1__) {
            ac_scale_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, ac_scale_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ac_scale_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 797;
        if (!(context__.contains_r("ac_noise")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ac_noise missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ac_noise");
        pos__ = 0U;
        validate_non_negative_index("ac_noise", "ac_q", ac_q);
        context__.validate_dims("parameter initialization", "ac_noise", "vector_d", context__.to_vec(ac_q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ac_noise(ac_q);
        size_t ac_noise_j_1_max__ = ac_q;
        for (size_t j_1__ = 0; j_1__ < ac_noise_j_1_max__; ++j_1__) {
            ac_noise(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(ac_noise);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ac_noise: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 799;
        if (!(context__.contains_r("obs_ac_scale_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable obs_ac_scale_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("obs_ac_scale_raw");
        pos__ = 0U;
        validate_non_negative_index("obs_ac_scale_raw", "obs_ac_nproc", obs_ac_nproc);
        context__.validate_dims("parameter initialization", "obs_ac_scale_raw", "vector_d", context__.to_vec(obs_ac_nproc));
        Eigen::Matrix<double, Eigen::Dynamic, 1> obs_ac_scale_raw(obs_ac_nproc);
        size_t obs_ac_scale_raw_j_1_max__ = obs_ac_nproc;
        for (size_t j_1__ = 0; j_1__ < obs_ac_scale_raw_j_1_max__; ++j_1__) {
            obs_ac_scale_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, obs_ac_scale_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable obs_ac_scale_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 800;
        if (!(context__.contains_r("obs_ac_noise")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable obs_ac_noise missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("obs_ac_noise");
        pos__ = 0U;
        validate_non_negative_index("obs_ac_noise", "obs_ac_q", obs_ac_q);
        context__.validate_dims("parameter initialization", "obs_ac_noise", "vector_d", context__.to_vec(obs_ac_q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> obs_ac_noise(obs_ac_q);
        size_t obs_ac_noise_j_1_max__ = obs_ac_q;
        for (size_t j_1__ = 0; j_1__ < obs_ac_noise_j_1_max__; ++j_1__) {
            obs_ac_noise(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(obs_ac_noise);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable obs_ac_noise: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 801;
        if (!(context__.contains_r("oz_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable oz_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("oz_beta");
        pos__ = 0U;
        validate_non_negative_index("oz_beta", "K_all", K_all);
        context__.validate_dims("parameter initialization", "oz_beta", "vector_d", context__.to_vec(K_all));
        Eigen::Matrix<double, Eigen::Dynamic, 1> oz_beta(K_all);
        size_t oz_beta_j_1_max__ = K_all;
        for (size_t j_1__ = 0; j_1__ < oz_beta_j_1_max__; ++j_1__) {
            oz_beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(oz_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable oz_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 803;
        if (!(context__.contains_r("seeds_aux_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable seeds_aux_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("seeds_aux_raw");
        pos__ = 0U;
        validate_non_negative_index("seeds_aux_raw", "hseeds", hseeds);
        context__.validate_dims("parameter initialization", "seeds_aux_raw", "vector_d", context__.to_vec(hseeds));
        Eigen::Matrix<double, Eigen::Dynamic, 1> seeds_aux_raw(hseeds);
        size_t seeds_aux_raw_j_1_max__ = hseeds;
        for (size_t j_1__ = 0; j_1__ < seeds_aux_raw_j_1_max__; ++j_1__) {
            seeds_aux_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, seeds_aux_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable seeds_aux_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 804;
        if (!(context__.contains_r("seeds_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable seeds_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("seeds_raw");
        pos__ = 0U;
        validate_non_negative_index("seeds_raw", "M", M);
        context__.validate_dims("parameter initialization", "seeds_raw", "vector_d", context__.to_vec(M));
        Eigen::Matrix<double, Eigen::Dynamic, 1> seeds_raw(M);
        size_t seeds_raw_j_1_max__ = M;
        for (size_t j_1__ = 0; j_1__ < seeds_raw_j_1_max__; ++j_1__) {
            seeds_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, seeds_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable seeds_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 805;
        if (!(context__.contains_r("infections_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable infections_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("infections_raw");
        pos__ = 0U;
        validate_non_negative_index("infections_raw", "(latent ? (N - (M * N0)) : 0 )", (latent ? (N - (M * N0)) : 0 ));
        context__.validate_dims("parameter initialization", "infections_raw", "vector_d", context__.to_vec((latent ? (N - (M * N0)) : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> infections_raw((latent ? (N - (M * N0)) : 0 ));
        size_t infections_raw_j_1_max__ = (latent ? (N - (M * N0)) : 0 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            infections_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, infections_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable infections_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 806;
        if (!(context__.contains_r("S0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable S0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("S0");
        pos__ = 0U;
        validate_non_negative_index("S0", "(S0_fixed ? 0 : M )", (S0_fixed ? 0 : M ));
        context__.validate_dims("parameter initialization", "S0", "vector_d", context__.to_vec((S0_fixed ? 0 : M )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> S0((S0_fixed ? 0 : M ));
        size_t S0_j_1_max__ = (S0_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            S0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, S0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable S0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 807;
        if (!(context__.contains_r("veps")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable veps missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("veps");
        pos__ = 0U;
        validate_non_negative_index("veps", "(veps_fixed ? 0 : M )", (veps_fixed ? 0 : M ));
        context__.validate_dims("parameter initialization", "veps", "vector_d", context__.to_vec((veps_fixed ? 0 : M )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> veps((veps_fixed ? 0 : M ));
        size_t veps_j_1_max__ = (veps_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            veps(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, veps);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable veps: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 780;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ogamma;
            (void) ogamma;  // dummy to suppress unused var warning
            if (jacobian__)
                ogamma = in__.vector_constrain(num_ointercepts, lp__);
            else
                ogamma = in__.vector_constrain(num_ointercepts);
            current_statement_begin__ = 781;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma_raw;
            (void) gamma_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma_raw = in__.vector_constrain(has_intercept, lp__);
            else
                gamma_raw = in__.vector_constrain(has_intercept);
            current_statement_begin__ = 782;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> oaux_raw;
            (void) oaux_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                oaux_raw = in__.vector_lb_constrain(0, num_oaux, lp__);
            else
                oaux_raw = in__.vector_lb_constrain(0, num_oaux);
            current_statement_begin__ = 783;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> inf_aux_raw;
            (void) inf_aux_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                inf_aux_raw = in__.vector_lb_constrain(0, latent, lp__);
            else
                inf_aux_raw = in__.vector_lb_constrain(0, latent);
            current_statement_begin__ = 784;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z_beta;
            (void) z_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                z_beta = in__.vector_ub_constrain((logical_eq(prior_dist, 8) ? stan::math::promote_scalar<double>(0) : stan::math::promote_scalar<double>(stan::math::positive_infinity()) ), (logical_eq(prior_dist, 7) ? sum(num_normals) : K ), lp__);
            else
                z_beta = in__.vector_ub_constrain((logical_eq(prior_dist, 8) ? stan::math::promote_scalar<double>(0) : stan::math::promote_scalar<double>(stan::math::positive_infinity()) ), (logical_eq(prior_dist, 7) ? sum(num_normals) : K ));
            current_statement_begin__ = 785;
            std::vector<local_scalar_t__> global;
            size_t global_d_0_max__ = hs;
            global.reserve(global_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < global_d_0_max__; ++d_0__) {
                if (jacobian__)
                    global.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    global.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 786;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > local;
            size_t local_d_0_max__ = hs;
            local.reserve(local_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < local_d_0_max__; ++d_0__) {
                if (jacobian__)
                    local.push_back(in__.vector_lb_constrain(0, K, lp__));
                else
                    local.push_back(in__.vector_lb_constrain(0, K));
            }
            current_statement_begin__ = 787;
            std::vector<local_scalar_t__> caux;
            size_t caux_d_0_max__ = logical_gt(hs, 0);
            caux.reserve(caux_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < caux_d_0_max__; ++d_0__) {
                if (jacobian__)
                    caux.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    caux.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 788;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > mix;
            size_t mix_d_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
            mix.reserve(mix_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mix_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mix.push_back(in__.vector_lb_constrain(0, K, lp__));
                else
                    mix.push_back(in__.vector_lb_constrain(0, K));
            }
            current_statement_begin__ = 789;
            std::vector<local_scalar_t__> one_over_lambda;
            size_t one_over_lambda_d_0_max__ = logical_eq(prior_dist, 6);
            one_over_lambda.reserve(one_over_lambda_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < one_over_lambda_d_0_max__; ++d_0__) {
                if (jacobian__)
                    one_over_lambda.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    one_over_lambda.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 790;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z_b;
            (void) z_b;  // dummy to suppress unused var warning
            if (jacobian__)
                z_b = in__.vector_constrain(q, lp__);
            else
                z_b = in__.vector_constrain(q);
            current_statement_begin__ = 791;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z_T;
            (void) z_T;  // dummy to suppress unused var warning
            if (jacobian__)
                z_T = in__.vector_constrain(len_z_T, lp__);
            else
                z_T = in__.vector_constrain(len_z_T);
            current_statement_begin__ = 792;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rho;
            (void) rho;  // dummy to suppress unused var warning
            if (jacobian__)
                rho = in__.vector_lub_constrain(0, 1, len_rho, lp__);
            else
                rho = in__.vector_lub_constrain(0, 1, len_rho);
            current_statement_begin__ = 793;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.vector_lb_constrain(0, len_concentration, lp__);
            else
                zeta = in__.vector_lb_constrain(0, len_concentration);
            current_statement_begin__ = 794;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.vector_lb_constrain(0, t, lp__);
            else
                tau = in__.vector_lb_constrain(0, t);
            current_statement_begin__ = 796;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ac_scale_raw;
            (void) ac_scale_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                ac_scale_raw = in__.vector_lb_constrain(0, ac_nproc, lp__);
            else
                ac_scale_raw = in__.vector_lb_constrain(0, ac_nproc);
            current_statement_begin__ = 797;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ac_noise;
            (void) ac_noise;  // dummy to suppress unused var warning
            if (jacobian__)
                ac_noise = in__.vector_constrain(ac_q, lp__);
            else
                ac_noise = in__.vector_constrain(ac_q);
            current_statement_begin__ = 799;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> obs_ac_scale_raw;
            (void) obs_ac_scale_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                obs_ac_scale_raw = in__.vector_lb_constrain(0, obs_ac_nproc, lp__);
            else
                obs_ac_scale_raw = in__.vector_lb_constrain(0, obs_ac_nproc);
            current_statement_begin__ = 800;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> obs_ac_noise;
            (void) obs_ac_noise;  // dummy to suppress unused var warning
            if (jacobian__)
                obs_ac_noise = in__.vector_constrain(obs_ac_q, lp__);
            else
                obs_ac_noise = in__.vector_constrain(obs_ac_q);
            current_statement_begin__ = 801;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> oz_beta;
            (void) oz_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                oz_beta = in__.vector_constrain(K_all, lp__);
            else
                oz_beta = in__.vector_constrain(K_all);
            current_statement_begin__ = 803;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seeds_aux_raw;
            (void) seeds_aux_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                seeds_aux_raw = in__.vector_lb_constrain(0, hseeds, lp__);
            else
                seeds_aux_raw = in__.vector_lb_constrain(0, hseeds);
            current_statement_begin__ = 804;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seeds_raw;
            (void) seeds_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                seeds_raw = in__.vector_lb_constrain(0, M, lp__);
            else
                seeds_raw = in__.vector_lb_constrain(0, M);
            current_statement_begin__ = 805;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infections_raw;
            (void) infections_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                infections_raw = in__.vector_lb_constrain(0, (latent ? (N - (M * N0)) : 0 ), lp__);
            else
                infections_raw = in__.vector_lb_constrain(0, (latent ? (N - (M * N0)) : 0 ));
            current_statement_begin__ = 806;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> S0;
            (void) S0;  // dummy to suppress unused var warning
            if (jacobian__)
                S0 = in__.vector_lub_constrain(0, 1, (S0_fixed ? 0 : M ), lp__);
            else
                S0 = in__.vector_lub_constrain(0, 1, (S0_fixed ? 0 : M ));
            current_statement_begin__ = 807;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> veps;
            (void) veps;  // dummy to suppress unused var warning
            if (jacobian__)
                veps = in__.vector_lub_constrain(0, 1, (veps_fixed ? 0 : M ), lp__);
            else
                veps = in__.vector_lub_constrain(0, 1, (veps_fixed ? 0 : M ));
            // transformed parameters
            current_statement_begin__ = 811;
            validate_non_negative_index("oeta", "N_obs", N_obs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> oeta(N_obs);
            stan::math::initialize(oeta, DUMMY_VAR__);
            stan::math::fill(oeta, DUMMY_VAR__);
            current_statement_begin__ = 812;
            validate_non_negative_index("E_obs", "N_obs", N_obs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> E_obs(N_obs);
            stan::math::initialize(E_obs, DUMMY_VAR__);
            stan::math::fill(E_obs, DUMMY_VAR__);
            current_statement_begin__ = 813;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta(N);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 814;
            validate_non_negative_index("oaux", "num_oaux", num_oaux);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> oaux(num_oaux);
            stan::math::initialize(oaux, DUMMY_VAR__);
            stan::math::fill(oaux, DUMMY_VAR__);
            stan::math::assign(oaux,oaux_raw);
            current_statement_begin__ = 815;
            validate_non_negative_index("inf_aux", "latent", latent);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> inf_aux(latent);
            stan::math::initialize(inf_aux, DUMMY_VAR__);
            stan::math::fill(inf_aux, DUMMY_VAR__);
            stan::math::assign(inf_aux,inf_aux_raw);
            current_statement_begin__ = 816;
            validate_non_negative_index("seeds_aux", "hseeds", hseeds);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seeds_aux(hseeds);
            stan::math::initialize(seeds_aux, DUMMY_VAR__);
            stan::math::fill(seeds_aux, DUMMY_VAR__);
            stan::math::assign(seeds_aux,seeds_aux_raw);
            current_statement_begin__ = 817;
            validate_non_negative_index("gamma", "has_intercept", has_intercept);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma(has_intercept);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma, DUMMY_VAR__);
            current_statement_begin__ = 818;
            validate_non_negative_index("seeds", "M", M);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seeds(M);
            stan::math::initialize(seeds, DUMMY_VAR__);
            stan::math::fill(seeds, DUMMY_VAR__);
            stan::math::assign(seeds,seeds_raw);
            current_statement_begin__ = 820;
            validate_non_negative_index("Rt_unadj", "N2", N2);
            validate_non_negative_index("Rt_unadj", "M", M);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Rt_unadj(N2, M);
            stan::math::initialize(Rt_unadj, DUMMY_VAR__);
            stan::math::fill(Rt_unadj, DUMMY_VAR__);
            stan::math::assign(Rt_unadj,rep_matrix(0, N2, M));
            current_statement_begin__ = 821;
            validate_non_negative_index("load", "N2", N2);
            validate_non_negative_index("load", "M", M);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> load(N2, M);
            stan::math::initialize(load, DUMMY_VAR__);
            stan::math::fill(load, DUMMY_VAR__);
            stan::math::assign(load,rep_matrix(0, N2, M));
            current_statement_begin__ = 822;
            validate_non_negative_index("E_infections", "N2", N2);
            validate_non_negative_index("E_infections", "M", M);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> E_infections(N2, M);
            stan::math::initialize(E_infections, DUMMY_VAR__);
            stan::math::fill(E_infections, DUMMY_VAR__);
            stan::math::assign(E_infections,rep_matrix(0, N2, M));
            current_statement_begin__ = 823;
            validate_non_negative_index("infections", "N2", N2);
            validate_non_negative_index("infections", "M", M);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> infections(N2, M);
            stan::math::initialize(infections, DUMMY_VAR__);
            stan::math::fill(infections, DUMMY_VAR__);
            stan::math::assign(infections,rep_matrix(0, N2, M));
            current_statement_begin__ = 824;
            validate_non_negative_index("susc", "N2", N2);
            validate_non_negative_index("susc", "M", M);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> susc(N2, M);
            stan::math::initialize(susc, DUMMY_VAR__);
            stan::math::fill(susc, DUMMY_VAR__);
            stan::math::assign(susc,rep_matrix(0, N2, M));
            current_statement_begin__ = 825;
            validate_non_negative_index("ac_scale", "ac_nproc", ac_nproc);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ac_scale(ac_nproc);
            stan::math::initialize(ac_scale, DUMMY_VAR__);
            stan::math::fill(ac_scale, DUMMY_VAR__);
            stan::math::assign(ac_scale,elt_multiply(ac_scale_raw, ac_prior_scales));
            current_statement_begin__ = 826;
            validate_non_negative_index("ac_beta", "ac_q", ac_q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ac_beta(ac_q);
            stan::math::initialize(ac_beta, DUMMY_VAR__);
            stan::math::fill(ac_beta, DUMMY_VAR__);
            current_statement_begin__ = 828;
            validate_non_negative_index("obs_ac_scale", "obs_ac_nproc", obs_ac_nproc);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> obs_ac_scale(obs_ac_nproc);
            stan::math::initialize(obs_ac_scale, DUMMY_VAR__);
            stan::math::fill(obs_ac_scale, DUMMY_VAR__);
            stan::math::assign(obs_ac_scale,elt_multiply(obs_ac_scale_raw, obs_ac_prior_scales));
            current_statement_begin__ = 829;
            validate_non_negative_index("obs_ac_beta", "obs_ac_q", obs_ac_q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> obs_ac_beta(obs_ac_q);
            stan::math::initialize(obs_ac_beta, DUMMY_VAR__);
            stan::math::fill(obs_ac_beta, DUMMY_VAR__);
            current_statement_begin__ = 830;
            validate_non_negative_index("obeta", "K_all", K_all);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> obeta(K_all);
            stan::math::initialize(obeta, DUMMY_VAR__);
            stan::math::fill(obeta, DUMMY_VAR__);
            stan::math::assign(obeta,add(elt_multiply(oz_beta, prior_oscale), prior_omean));
            current_statement_begin__ = 831;
            validate_non_negative_index("beta", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta(K);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 832;
            validate_non_negative_index("b", "q", q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b(q);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 833;
            validate_non_negative_index("theta_L", "len_theta_L", len_theta_L);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_L(len_theta_L);
            stan::math::initialize(theta_L, DUMMY_VAR__);
            stan::math::fill(theta_L, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 834;
            if (as_bool(logical_eq(prior_dist, 0))) {
                current_statement_begin__ = 834;
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist, 1))) {
                current_statement_begin__ = 835;
                stan::math::assign(beta, add(elt_multiply(z_beta, prior_scale), prior_mean));
            } else if (as_bool(logical_eq(prior_dist, 2))) {
                current_statement_begin__ = 836;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 837;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                ((CFt(get_base1(z_beta, k, "z_beta", 1), get_base1(prior_df, k, "prior_df", 1), pstream__) * get_base1(prior_scale, k, "prior_scale", 1)) + get_base1(prior_mean, k, "prior_mean", 1)), 
                                "assigning variable beta");
                }
            } else if (as_bool(logical_eq(prior_dist, 3))) {
                {
                current_statement_begin__ = 840;
                local_scalar_t__ c2(DUMMY_VAR__);
                (void) c2;  // dummy to suppress unused var warning
                stan::math::initialize(c2, DUMMY_VAR__);
                stan::math::fill(c2, DUMMY_VAR__);
                stan::math::assign(c2,(square(slab_scale) * get_base1(caux, 1, "caux", 1)));
                current_statement_begin__ = 841;
                stan::math::assign(beta, hs_prior(z_beta, global, local, global_prior_scale, 1, c2, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist, 4))) {
                {
                current_statement_begin__ = 844;
                local_scalar_t__ c2(DUMMY_VAR__);
                (void) c2;  // dummy to suppress unused var warning
                stan::math::initialize(c2, DUMMY_VAR__);
                stan::math::fill(c2, DUMMY_VAR__);
                stan::math::assign(c2,(square(slab_scale) * get_base1(caux, 1, "caux", 1)));
                current_statement_begin__ = 845;
                stan::math::assign(beta, hsplus_prior(z_beta, global, local, global_prior_scale, 1, c2, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist, 5))) {
                current_statement_begin__ = 848;
                stan::math::assign(beta, add(prior_mean, elt_multiply(elt_multiply(prior_scale, stan::math::sqrt(multiply(2, get_base1(mix, 1, "mix", 1)))), z_beta)));
            } else if (as_bool(logical_eq(prior_dist, 6))) {
                current_statement_begin__ = 850;
                stan::math::assign(beta, add(prior_mean, elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda, 1, "one_over_lambda", 1), prior_scale), stan::math::sqrt(multiply(2, get_base1(mix, 1, "mix", 1)))), z_beta)));
            } else if (as_bool(logical_eq(prior_dist, 7))) {
                {
                current_statement_begin__ = 852;
                int z_pos(0);
                (void) z_pos;  // dummy to suppress unused var warning
                stan::math::fill(z_pos, std::numeric_limits<int>::min());
                stan::math::assign(z_pos,1);
                current_statement_begin__ = 853;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 854;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                get_base1(z_beta, z_pos, "z_beta", 1), 
                                "assigning variable beta");
                    current_statement_begin__ = 855;
                    stan::math::assign(z_pos, (z_pos + 1));
                    current_statement_begin__ = 856;
                    for (int n = 2; n <= get_base1(num_normals, k, "num_normals", 1); ++n) {
                        current_statement_begin__ = 857;
                        stan::model::assign(beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "beta") * get_base1(z_beta, z_pos, "z_beta", 1)), 
                                    "assigning variable beta");
                        current_statement_begin__ = 858;
                        stan::math::assign(z_pos, (z_pos + 1));
                    }
                    current_statement_begin__ = 860;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "beta") * pow(get_base1(prior_scale, k, "prior_scale", 1), get_base1(num_normals, k, "num_normals", 1))), 
                                "assigning variable beta");
                    current_statement_begin__ = 861;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "beta") + get_base1(prior_mean, k, "prior_mean", 1)), 
                                "assigning variable beta");
                }
                }
            } else if (as_bool(logical_eq(prior_dist, 8))) {
                current_statement_begin__ = 864;
                stan::math::assign(beta, add(z_beta, prior_shift));
            }
            current_statement_begin__ = 867;
            for (int i = 1; i <= num_oaux; ++i) {
                current_statement_begin__ = 868;
                if (as_bool(logical_gt(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 0))) {
                    current_statement_begin__ = 869;
                    if (as_bool(logical_gt(get_base1(prior_scale_for_oaux, i, "prior_scale_for_oaux", 1), 0))) {
                        current_statement_begin__ = 870;
                        stan::model::assign(oaux, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(oaux, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "oaux") * get_base1(prior_scale_for_oaux, i, "prior_scale_for_oaux", 1)), 
                                    "assigning variable oaux");
                    }
                    current_statement_begin__ = 872;
                    if (as_bool(logical_lte(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 2))) {
                        current_statement_begin__ = 873;
                        stan::model::assign(oaux, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(oaux, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "oaux") + get_base1(prior_mean_for_oaux, i, "prior_mean_for_oaux", 1)), 
                                    "assigning variable oaux");
                    }
                }
            }
            current_statement_begin__ = 878;
            if (as_bool(has_intercept)) {
                current_statement_begin__ = 879;
                if (as_bool((primitive_value(logical_eq(get_base1(prior_dist_for_intercept, 1, "prior_dist_for_intercept", 1), 1)) || primitive_value(logical_eq(get_base1(prior_dist_for_intercept, 1, "prior_dist_for_intercept", 1), 2))))) {
                    current_statement_begin__ = 880;
                    stan::math::assign(gamma, add(multiply(gamma_raw, get_base1(prior_scale_for_intercept, 1, "prior_scale_for_intercept", 1)), get_base1(prior_mean_for_intercept, 1, "prior_mean_for_intercept", 1)));
                }
            }
            current_statement_begin__ = 884;
            if (as_bool(latent)) {
                current_statement_begin__ = 885;
                if (as_bool(logical_gt(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 0))) {
                    current_statement_begin__ = 886;
                    if (as_bool(logical_gt(get_base1(prior_scale_for_inf_aux, 1, "prior_scale_for_inf_aux", 1), 0))) {
                        current_statement_begin__ = 887;
                        stan::model::assign(inf_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(inf_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "inf_aux") * get_base1(prior_scale_for_inf_aux, 1, "prior_scale_for_inf_aux", 1)), 
                                    "assigning variable inf_aux");
                    }
                    current_statement_begin__ = 889;
                    if (as_bool(logical_lte(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 2))) {
                        current_statement_begin__ = 890;
                        stan::model::assign(inf_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(inf_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "inf_aux") + get_base1(prior_mean_for_inf_aux, 1, "prior_mean_for_inf_aux", 1)), 
                                    "assigning variable inf_aux");
                    }
                }
            }
            current_statement_begin__ = 896;
            if (as_bool(hseeds)) {
                current_statement_begin__ = 897;
                if (as_bool(logical_gt(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 0))) {
                    current_statement_begin__ = 898;
                    if (as_bool(logical_gt(get_base1(prior_scale_for_seeds_aux, 1, "prior_scale_for_seeds_aux", 1), 0))) {
                        current_statement_begin__ = 899;
                        stan::model::assign(seeds_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(seeds_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "seeds_aux") * get_base1(prior_scale_for_seeds_aux, 1, "prior_scale_for_seeds_aux", 1)), 
                                    "assigning variable seeds_aux");
                    }
                    current_statement_begin__ = 901;
                    if (as_bool(logical_lte(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 2))) {
                        current_statement_begin__ = 902;
                        stan::model::assign(seeds_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(seeds_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "seeds_aux") + get_base1(prior_mean_for_seeds_aux, 1, "prior_mean_for_seeds_aux", 1)), 
                                    "assigning variable seeds_aux");
                    }
                }
            }
            current_statement_begin__ = 908;
            if (as_bool(logical_eq(prior_dist_for_seeds, 3))) {
                current_statement_begin__ = 909;
                stan::math::assign(seeds, elt_multiply(seeds, prior_scale_for_seeds));
            }
            current_statement_begin__ = 912;
            if (as_bool(logical_eq(prior_dist_for_seeds, 9))) {
                current_statement_begin__ = 913;
                stan::math::assign(seeds, multiply(seeds, get_base1(seeds_aux, 1, "seeds_aux", 1)));
            }
            {
            current_statement_begin__ = 917;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 918;
            for (int proc = 1; proc <= ac_nproc; ++proc) {
                current_statement_begin__ = 919;
                stan::model::assign(ac_beta, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(ac_ntime, proc, "ac_ntime", 1)) - 1)), stan::model::nil_index_list()), 
                            cumulative_sum(stan::model::rvalue(ac_noise, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(ac_ntime, proc, "ac_ntime", 1)) - 1)), stan::model::nil_index_list()), "ac_noise")), 
                            "assigning variable ac_beta");
                current_statement_begin__ = 920;
                stan::math::assign(i, (i + get_base1(ac_ntime, proc, "ac_ntime", 1)));
            }
            current_statement_begin__ = 923;
            stan::math::assign(i, 1);
            current_statement_begin__ = 924;
            for (int proc = 1; proc <= obs_ac_nproc; ++proc) {
                current_statement_begin__ = 925;
                stan::model::assign(obs_ac_beta, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)) - 1)), stan::model::nil_index_list()), 
                            cumulative_sum(stan::model::rvalue(obs_ac_noise, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)) - 1)), stan::model::nil_index_list()), "obs_ac_noise")), 
                            "assigning variable obs_ac_beta");
                current_statement_begin__ = 926;
                stan::math::assign(i, (i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)));
            }
            }
            current_statement_begin__ = 930;
            if (as_bool(logical_gt(K, 0))) {
                current_statement_begin__ = 931;
                stan::math::assign(eta, multiply(X, beta));
            } else {
                current_statement_begin__ = 933;
                stan::math::assign(eta, rep_vector(0.0, N));
            }
            current_statement_begin__ = 935;
            if (as_bool(logical_gt(t, 0))) {
                current_statement_begin__ = 936;
                if (as_bool(logical_eq(special_case, 1))) {
                    {
                    current_statement_begin__ = 937;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,1);
                    current_statement_begin__ = 938;
                    stan::math::assign(theta_L, elt_multiply(scale, tau));
                    current_statement_begin__ = 939;
                    if (as_bool(logical_eq(t, 1))) {
                        current_statement_begin__ = 939;
                        stan::math::assign(b, multiply(get_base1(theta_L, 1, "theta_L", 1), z_b));
                    } else {
                        current_statement_begin__ = 940;
                        for (int i = 1; i <= t; ++i) {
                            {
                            current_statement_begin__ = 941;
                            int end(0);
                            (void) end;  // dummy to suppress unused var warning
                            stan::math::fill(end, std::numeric_limits<int>::min());
                            stan::math::assign(end,((start + get_base1(l, i, "l", 1)) - 1));
                            current_statement_begin__ = 942;
                            stan::model::assign(b, 
                                        stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                        multiply(get_base1(theta_L, i, "theta_L", 1), stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                        "assigning variable b");
                            current_statement_begin__ = 943;
                            stan::math::assign(start, (end + 1));
                            }
                        }
                    }
                    }
                } else {
                    current_statement_begin__ = 947;
                    stan::math::assign(theta_L, make_theta_L(len_theta_L, p, 1.0, tau, scale, zeta, rho, z_T, pstream__));
                    current_statement_begin__ = 949;
                    stan::math::assign(b, make_b(z_b, theta_L, p, l, pstream__));
                }
            }
            current_statement_begin__ = 953;
            if (as_bool(logical_gt(t, 0))) {
                current_statement_begin__ = 954;
                if (as_bool(special_case)) {
                    current_statement_begin__ = 954;
                    for (int i = 1; i <= t; ++i) {
                        current_statement_begin__ = 954;
                        stan::math::assign(eta, add(eta, stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V, i, "V", 1)), stan::model::nil_index_list()), "b")));
                    }
                } else {
                    current_statement_begin__ = 955;
                    stan::math::assign(eta, add(eta, csr_matrix_times_vector2(N, q, w, v, u, b, pstream__)));
                }
            }
            current_statement_begin__ = 957;
            if (as_bool(logical_eq(has_intercept, 1))) {
                current_statement_begin__ = 958;
                stan::math::assign(eta, add(eta, get_base1(gamma, 1, "gamma", 1)));
            } else {
                current_statement_begin__ = 962;
                stan::math::assign(eta, add(eta, dot_product(xbar, beta)));
            }
            current_statement_begin__ = 965;
            if (as_bool(logical_gt(ac_nterms, 0))) {
                current_statement_begin__ = 966;
                for (int i = 1; i <= ac_nterms; ++i) {
                    current_statement_begin__ = 967;
                    for (int j = 1; j <= N; ++j) {
                        current_statement_begin__ = 968;
                        if (as_bool(logical_gt(get_base1(get_base1(ac_V, i, "ac_V", 1), j, "ac_V", 2), 0))) {
                            current_statement_begin__ = 969;
                            stan::model::assign(eta, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "eta") + get_base1(ac_beta, get_base1(get_base1(ac_V, i, "ac_V", 1), j, "ac_V", 2), "ac_beta", 1)), 
                                        "assigning variable eta");
                        }
                    }
                }
            }
            {
            current_statement_begin__ = 978;
            int npos(0);
            (void) npos;  // dummy to suppress unused var warning
            stan::math::fill(npos, std::numeric_limits<int>::min());
            stan::math::assign(npos,1);
            current_statement_begin__ = 979;
            int kpos(0);
            (void) kpos;  // dummy to suppress unused var warning
            stan::math::fill(kpos, std::numeric_limits<int>::min());
            stan::math::assign(kpos,1);
            current_statement_begin__ = 980;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 981;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 983;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 984;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX1, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 986;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 989;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 990;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 992;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 998;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 999;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1000;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1001;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1003;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1004;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX2, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1006;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1009;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1010;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1012;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1018;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1019;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1020;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1021;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1023;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1024;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX3, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1026;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1029;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1030;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1032;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1038;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1039;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1040;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1041;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1043;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1044;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX4, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1046;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1049;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1050;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1052;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1058;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1059;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1060;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1061;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1063;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1064;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX5, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1066;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1069;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1070;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1072;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1078;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1079;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1080;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1081;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1083;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1084;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX6, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1086;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1089;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1090;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1092;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1098;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1099;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1100;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1101;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1103;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1104;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX7, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1106;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1109;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1110;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1112;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1118;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1119;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1120;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1121;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1123;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1124;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX8, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1126;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1129;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1130;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1132;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1138;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1139;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1140;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1141;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1143;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1144;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX9, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1146;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1149;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1150;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1152;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1158;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1159;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1160;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1161;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1163;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1164;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX10, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1166;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1169;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1170;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1172;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            }
            {
            current_statement_begin__ = 1180;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 1181;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 1182;
                if (as_bool(logical_eq(get_base1(has_offset, r, "has_offset", 1), 1))) {
                    current_statement_begin__ = 1183;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), segment(offset_, i, get_base1(oN, r, "oN", 1))), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1185;
                stan::math::assign(i, (i + get_base1(oN, r, "oN", 1)));
            }
            }
            current_statement_begin__ = 1190;
            for (int i = 1; i <= obs_ac_nterms; ++i) {
                current_statement_begin__ = 1191;
                for (int j = 1; j <= N_obs; ++j) {
                    current_statement_begin__ = 1192;
                    if (as_bool(logical_gt(get_base1(get_base1(obs_ac_V, i, "obs_ac_V", 1), j, "obs_ac_V", 2), 0))) {
                        current_statement_begin__ = 1193;
                        stan::model::assign(oeta, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "oeta") + get_base1(obs_ac_beta, get_base1(get_base1(obs_ac_V, i, "obs_ac_V", 1), j, "obs_ac_V", 2), "obs_ac_beta", 1)), 
                                    "assigning variable oeta");
                    }
                }
            }
            {
            current_statement_begin__ = 1198;
            int idx1(0);
            (void) idx1;  // dummy to suppress unused var warning
            stan::math::fill(idx1, std::numeric_limits<int>::min());
            stan::math::assign(idx1,1);
            current_statement_begin__ = 1199;
            int idx2(0);
            (void) idx2;  // dummy to suppress unused var warning
            stan::math::fill(idx2, std::numeric_limits<int>::min());
            stan::math::assign(idx2,1);
            current_statement_begin__ = 1200;
            for (int m = 1; m <= M; ++m) {
                {
                current_statement_begin__ = 1202;
                int n0(0);
                (void) n0;  // dummy to suppress unused var warning
                stan::math::fill(n0, std::numeric_limits<int>::min());
                stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                current_statement_begin__ = 1203;
                int n1(0);
                (void) n1;  // dummy to suppress unused var warning
                stan::math::fill(n1, std::numeric_limits<int>::min());
                stan::math::assign(n1,((n0 + N0) - 1));
                current_statement_begin__ = 1204;
                int n2(0);
                (void) n2;  // dummy to suppress unused var warning
                stan::math::fill(n2, std::numeric_limits<int>::min());
                stan::math::assign(n2,((n0 + get_base1(NC, m, "NC", 1)) - 1));
                current_statement_begin__ = 1205;
                int len(0);
                (void) len;  // dummy to suppress unused var warning
                stan::math::fill(len, std::numeric_limits<int>::min());
                current_statement_begin__ = 1206;
                local_scalar_t__ vt(DUMMY_VAR__);
                (void) vt;  // dummy to suppress unused var warning
                stan::math::initialize(vt, DUMMY_VAR__);
                stan::math::fill(vt, DUMMY_VAR__);
                current_statement_begin__ = 1209;
                if (as_bool(logical_eq(link, 1))) {
                    current_statement_begin__ = 1210;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                stan::math::exp(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta")), 
                                "assigning variable Rt_unadj");
                } else if (as_bool(logical_eq(link, 2))) {
                    current_statement_begin__ = 1212;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                multiply(carry, inv_logit(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta"))), 
                                "assigning variable Rt_unadj");
                } else {
                    current_statement_begin__ = 1214;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta"), 
                                "assigning variable Rt_unadj");
                }
                current_statement_begin__ = 1216;
                stan::math::assign(idx1, (idx1 + get_base1(NC, m, "NC", 1)));
                current_statement_begin__ = 1218;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_min_max(n0, n1), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                            rep_vector(get_base1(seeds, m, "seeds", 1), N0), 
                            "assigning variable infections");
                current_statement_begin__ = 1220;
                if (as_bool(pop_adjust)) {
                    current_statement_begin__ = 1221;
                    stan::model::assign(susc, 
                                stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                get_base1(pops, m, "pops", 1), 
                                "assigning variable susc");
                    current_statement_begin__ = 1222;
                    if (as_bool(logical_negation(S0_fixed))) {
                        current_statement_begin__ = 1222;
                        stan::model::assign(susc, 
                                    stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (stan::model::rvalue(susc, stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "susc") * get_base1(S0, m, "S0", 1)), 
                                    "assigning variable susc");
                    }
                }
                current_statement_begin__ = 1225;
                for (int i = n0; i <= n2; ++i) {
                    {
                    current_statement_begin__ = 1227;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,std::max(n0, (i - gen_len)));
                    current_statement_begin__ = 1228;
                    stan::model::assign(load, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                dot_product(sub_col(infections, start, m, (i - start)), tail(gen_rev, (i - start))), 
                                "assigning variable load");
                    current_statement_begin__ = 1230;
                    if (as_bool(logical_gt(i, n1))) {
                        current_statement_begin__ = 1231;
                        stan::model::assign(E_infections, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (get_base1(Rt_unadj, i, m, "Rt_unadj", 1) * get_base1(load, i, m, "load", 1)), 
                                    "assigning variable E_infections");
                        current_statement_begin__ = 1232;
                        if (as_bool(latent)) {
                            current_statement_begin__ = 1232;
                            stan::model::assign(infections, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        get_base1(infections_raw, idx2, "infections_raw", 1), 
                                        "assigning variable infections");
                        } else {
                            current_statement_begin__ = 1233;
                            stan::model::assign(infections, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        get_base1(E_infections, i, m, "E_infections", 1), 
                                        "assigning variable infections");
                        }
                        current_statement_begin__ = 1234;
                        stan::math::assign(idx2, (idx2 + 1));
                    }
                    current_statement_begin__ = 1237;
                    if (as_bool(pop_adjust)) {
                        current_statement_begin__ = 1238;
                        stan::model::assign(infections, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (get_base1(susc, i, m, "susc", 1) * (1 - stan::math::exp((-(get_base1(infections, i, m, "infections", 1)) / get_base1(pops, m, "pops", 1))))), 
                                    "assigning variable infections");
                        current_statement_begin__ = 1239;
                        stan::math::assign(vt, get_base1(vacc, i, m, "vacc", 1));
                        current_statement_begin__ = 1240;
                        if (as_bool(logical_negation(veps_fixed))) {
                            current_statement_begin__ = 1240;
                            stan::math::assign(vt, (vt * get_base1(veps, m, "veps", 1)));
                        }
                        current_statement_begin__ = 1241;
                        if (as_bool(logical_neq(i, n2))) {
                            current_statement_begin__ = 1241;
                            stan::model::assign(susc, 
                                        stan::model::cons_list(stan::model::index_uni((i + 1)), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        ((1 - vt) * (get_base1(susc, i, m, "susc", 1) - get_base1(infections, i, m, "infections", 1))), 
                                        "assigning variable susc");
                        }
                    }
                    }
                }
                }
            }
            }
            {
            current_statement_begin__ = 1247;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 1248;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 1249;
                stan::model::assign(E_obs, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                            linkinv(add(segment(oeta, i, get_base1(oN, r, "oN", 1)), 1e-15), get_base1(olink, r, "olink", 1), pstream__), 
                            "assigning variable E_obs");
                current_statement_begin__ = 1250;
                stan::math::assign(i, (i + get_base1(oN, r, "oN", 1)));
            }
            }
            current_statement_begin__ = 1255;
            for (int i = 1; i <= N_obs; ++i) {
                {
                current_statement_begin__ = 1256;
                int m(0);
                (void) m;  // dummy to suppress unused var warning
                stan::math::fill(m, std::numeric_limits<int>::min());
                stan::math::assign(m,get_base1(obs_group, i, "obs_group", 1));
                current_statement_begin__ = 1257;
                int dt(0);
                (void) dt;  // dummy to suppress unused var warning
                stan::math::fill(dt, std::numeric_limits<int>::min());
                stan::math::assign(dt,get_base1(obs_date, i, "obs_date", 1));
                current_statement_begin__ = 1258;
                int tp(0);
                (void) tp;  // dummy to suppress unused var warning
                stan::math::fill(tp, std::numeric_limits<int>::min());
                stan::math::assign(tp,get_base1(obs_type, i, "obs_type", 1));
                current_statement_begin__ = 1259;
                int n0(0);
                (void) n0;  // dummy to suppress unused var warning
                stan::math::fill(n0, std::numeric_limits<int>::min());
                stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                current_statement_begin__ = 1260;
                if (as_bool(logical_eq(dt, 1))) {
                    current_statement_begin__ = 1261;
                    stan::model::assign(E_obs, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(E_obs, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "E_obs") * (1e-15 * get_base1(infections, 1, m, "infections", 1))), 
                                "assigning variable E_obs");
                } else {
                    {
                    current_statement_begin__ = 1263;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,std::max(n0, (dt - get_base1(pvecs_len, tp, "pvecs_len", 1))));
                    current_statement_begin__ = 1264;
                    stan::model::assign(E_obs, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(E_obs, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "E_obs") * dot_product(sub_col(infections, start, m, (dt - start)), tail(get_base1(pvecs_rev, tp, "pvecs_rev", 1), (dt - start)))), 
                                "assigning variable E_obs");
                    }
                }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 811;
            size_t oeta_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(oeta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: oeta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable oeta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 812;
            size_t E_obs_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(E_obs(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: E_obs" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable E_obs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 813;
            size_t eta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 814;
            size_t oaux_j_1_max__ = num_oaux;
            for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(oaux(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: oaux" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable oaux: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "oaux", oaux, 0);
            current_statement_begin__ = 815;
            size_t inf_aux_j_1_max__ = latent;
            for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(inf_aux(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: inf_aux" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable inf_aux: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "inf_aux", inf_aux, 0);
            current_statement_begin__ = 816;
            size_t seeds_aux_j_1_max__ = hseeds;
            for (size_t j_1__ = 0; j_1__ < seeds_aux_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(seeds_aux(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: seeds_aux" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable seeds_aux: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "seeds_aux", seeds_aux, 0);
            current_statement_begin__ = 817;
            size_t gamma_j_1_max__ = has_intercept;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(gamma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gamma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 818;
            size_t seeds_j_1_max__ = M;
            for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(seeds(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: seeds" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable seeds: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "seeds", seeds, 0);
            current_statement_begin__ = 820;
            size_t Rt_unadj_j_1_max__ = N2;
            size_t Rt_unadj_j_2_max__ = M;
            for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Rt_unadj(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Rt_unadj" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Rt_unadj: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "Rt_unadj", Rt_unadj, 0);
            current_statement_begin__ = 821;
            size_t load_j_1_max__ = N2;
            size_t load_j_2_max__ = M;
            for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(load(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: load" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable load: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "load", load, 0);
            current_statement_begin__ = 822;
            size_t E_infections_j_1_max__ = N2;
            size_t E_infections_j_2_max__ = M;
            for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(E_infections(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: E_infections" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable E_infections: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "E_infections", E_infections, 0);
            current_statement_begin__ = 823;
            size_t infections_j_1_max__ = N2;
            size_t infections_j_2_max__ = M;
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(infections(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: infections" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable infections: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "infections", infections, 0);
            current_statement_begin__ = 824;
            size_t susc_j_1_max__ = N2;
            size_t susc_j_2_max__ = M;
            for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(susc(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: susc" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable susc: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "susc", susc, 0);
            current_statement_begin__ = 825;
            size_t ac_scale_j_1_max__ = ac_nproc;
            for (size_t j_1__ = 0; j_1__ < ac_scale_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ac_scale(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ac_scale" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ac_scale: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 826;
            size_t ac_beta_j_1_max__ = ac_q;
            for (size_t j_1__ = 0; j_1__ < ac_beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ac_beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ac_beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ac_beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 828;
            size_t obs_ac_scale_j_1_max__ = obs_ac_nproc;
            for (size_t j_1__ = 0; j_1__ < obs_ac_scale_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(obs_ac_scale(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: obs_ac_scale" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable obs_ac_scale: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 829;
            size_t obs_ac_beta_j_1_max__ = obs_ac_q;
            for (size_t j_1__ = 0; j_1__ < obs_ac_beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(obs_ac_beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: obs_ac_beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable obs_ac_beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 830;
            size_t obeta_j_1_max__ = K_all;
            for (size_t j_1__ = 0; j_1__ < obeta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(obeta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: obeta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable obeta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 831;
            size_t beta_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 832;
            size_t b_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 833;
            size_t theta_L_j_1_max__ = len_theta_L;
            for (size_t j_1__ = 0; j_1__ < theta_L_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_L(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_L" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_L: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 1273;
            if (as_bool(logical_eq(prior_dist, 1))) {
                current_statement_begin__ = 1273;
                lp_accum__.add(normal_log(z_beta, 0, 1));
            } else if (as_bool(logical_eq(prior_dist, 2))) {
                current_statement_begin__ = 1274;
                lp_accum__.add(normal_log(z_beta, 0, 1));
            } else if (as_bool(logical_eq(prior_dist, 3))) {
                {
                current_statement_begin__ = 1276;
                local_scalar_t__ log_half(DUMMY_VAR__);
                (void) log_half;  // dummy to suppress unused var warning
                stan::math::initialize(log_half, DUMMY_VAR__);
                stan::math::fill(log_half, DUMMY_VAR__);
                stan::math::assign(log_half,-(0.693147180559945286));
                current_statement_begin__ = 1277;
                lp_accum__.add(normal_log(z_beta, 0, 1));
                current_statement_begin__ = 1278;
                lp_accum__.add((normal_log(get_base1(local, 1, "local", 1), 0, 1) - log_half));
                current_statement_begin__ = 1279;
                lp_accum__.add(inv_gamma_log(get_base1(local, 2, "local", 1), multiply(0.5, prior_df), multiply(0.5, prior_df)));
                current_statement_begin__ = 1280;
                lp_accum__.add((normal_log(get_base1(global, 1, "global", 1), 0, 1) - log_half));
                current_statement_begin__ = 1281;
                lp_accum__.add(inv_gamma_log(get_base1(global, 2, "global", 1), (0.5 * global_prior_df), (0.5 * global_prior_df)));
                current_statement_begin__ = 1282;
                lp_accum__.add(inv_gamma_log(caux, (0.5 * slab_df), (0.5 * slab_df)));
                }
            } else if (as_bool(logical_eq(prior_dist, 4))) {
                {
                current_statement_begin__ = 1285;
                local_scalar_t__ log_half(DUMMY_VAR__);
                (void) log_half;  // dummy to suppress unused var warning
                stan::math::initialize(log_half, DUMMY_VAR__);
                stan::math::fill(log_half, DUMMY_VAR__);
                stan::math::assign(log_half,-(0.693147180559945286));
                current_statement_begin__ = 1286;
                lp_accum__.add(normal_log(z_beta, 0, 1));
                current_statement_begin__ = 1287;
                lp_accum__.add((normal_log(get_base1(local, 1, "local", 1), 0, 1) - log_half));
                current_statement_begin__ = 1288;
                lp_accum__.add(inv_gamma_log(get_base1(local, 2, "local", 1), multiply(0.5, prior_df), multiply(0.5, prior_df)));
                current_statement_begin__ = 1289;
                lp_accum__.add((normal_log(get_base1(local, 3, "local", 1), 0, 1) - log_half));
                current_statement_begin__ = 1291;
                lp_accum__.add(inv_gamma_log(get_base1(local, 4, "local", 1), multiply(0.5, prior_scale), multiply(0.5, prior_scale)));
                current_statement_begin__ = 1292;
                lp_accum__.add((normal_log(get_base1(global, 1, "global", 1), 0, 1) - log_half));
                current_statement_begin__ = 1293;
                lp_accum__.add(inv_gamma_log(get_base1(global, 2, "global", 1), (0.5 * global_prior_df), (0.5 * global_prior_df)));
                current_statement_begin__ = 1294;
                lp_accum__.add(inv_gamma_log(caux, (0.5 * slab_df), (0.5 * slab_df)));
                }
            } else if (as_bool(logical_eq(prior_dist, 5))) {
                current_statement_begin__ = 1297;
                lp_accum__.add(normal_log(z_beta, 0, 1));
                current_statement_begin__ = 1298;
                lp_accum__.add(exponential_log(get_base1(mix, 1, "mix", 1), 1));
            } else if (as_bool(logical_eq(prior_dist, 6))) {
                current_statement_begin__ = 1301;
                lp_accum__.add(normal_log(z_beta, 0, 1));
                current_statement_begin__ = 1302;
                lp_accum__.add(exponential_log(get_base1(mix, 1, "mix", 1), 1));
                current_statement_begin__ = 1303;
                lp_accum__.add(chi_square_log(get_base1(one_over_lambda, 1, "one_over_lambda", 1), get_base1(prior_df, 1, "prior_df", 1)));
            } else if (as_bool(logical_eq(prior_dist, 7))) {
                current_statement_begin__ = 1306;
                lp_accum__.add(normal_log(z_beta, 0, 1));
            } else if (as_bool(logical_eq(prior_dist, 8))) {
                current_statement_begin__ = 1309;
                lp_accum__.add(gamma_log(minus(z_beta), prior_shape, elt_divide(1.0, prior_scale)));
            }
            current_statement_begin__ = 1313;
            if (as_bool(logical_eq(has_intercept, 1))) {
                current_statement_begin__ = 1314;
                if (as_bool(logical_eq(get_base1(prior_dist_for_intercept, 1, "prior_dist_for_intercept", 1), 1))) {
                    current_statement_begin__ = 1315;
                    lp_accum__.add(normal_log(gamma_raw, 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_intercept, 1, "prior_dist_for_intercept", 1), 2))) {
                    current_statement_begin__ = 1317;
                    lp_accum__.add(student_t_log(gamma_raw, get_base1(prior_df_for_intercept, 1, "prior_df_for_intercept", 1), 0, 1));
                }
            }
            current_statement_begin__ = 1320;
            lp_accum__.add(normal_log(ac_scale_raw, 0, 1));
            {
            current_statement_begin__ = 1323;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 1324;
            for (int proc = 1; proc <= ac_nproc; ++proc) {
                current_statement_begin__ = 1325;
                lp_accum__.add(normal_log(stan::model::rvalue(ac_noise, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(ac_ntime, proc, "ac_ntime", 1)) - 1)), stan::model::nil_index_list()), "ac_noise"), 0, get_base1(ac_scale, proc, "ac_scale", 1)));
                current_statement_begin__ = 1326;
                stan::math::assign(i, (i + get_base1(ac_ntime, proc, "ac_ntime", 1)));
            }
            }
            current_statement_begin__ = 1330;
            lp_accum__.add(normal_log(obs_ac_scale_raw, 0, 1));
            {
            current_statement_begin__ = 1333;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 1334;
            for (int proc = 1; proc <= obs_ac_nproc; ++proc) {
                current_statement_begin__ = 1335;
                lp_accum__.add(normal_log(stan::model::rvalue(obs_ac_noise, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)) - 1)), stan::model::nil_index_list()), "obs_ac_noise"), 0, get_base1(obs_ac_scale, proc, "obs_ac_scale", 1)));
                current_statement_begin__ = 1336;
                stan::math::assign(i, (i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)));
            }
            }
            current_statement_begin__ = 1339;
            lp_accum__.add(normal_log(oz_beta, 0, 1));
            current_statement_begin__ = 1342;
            if (as_bool(logical_gt(num_ointercepts, 0))) {
                current_statement_begin__ = 1343;
                lp_accum__.add(normal_log(ogamma, prior_mean_for_ointercept, prior_scale_for_ointercept));
            }
            current_statement_begin__ = 1346;
            for (int i = 1; i <= num_oaux; ++i) {
                current_statement_begin__ = 1347;
                if (as_bool(logical_eq(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 1))) {
                    current_statement_begin__ = 1348;
                    lp_accum__.add(normal_log(get_base1(oaux_raw, i, "oaux_raw", 1), 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 2))) {
                    current_statement_begin__ = 1350;
                    lp_accum__.add(student_t_log(get_base1(oaux_raw, i, "oaux_raw", 1), get_base1(prior_df_for_oaux, i, "prior_df_for_oaux", 1), 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 3))) {
                    current_statement_begin__ = 1352;
                    lp_accum__.add(exponential_log(get_base1(oaux_raw, i, "oaux_raw", 1), 1));
                }
            }
            current_statement_begin__ = 1354;
            if (as_bool(latent)) {
                {
                current_statement_begin__ = 1357;
                int idx(0);
                (void) idx;  // dummy to suppress unused var warning
                stan::math::fill(idx, std::numeric_limits<int>::min());
                stan::math::assign(idx,1);
                current_statement_begin__ = 1358;
                for (int m = 1; m <= M; ++m) {
                    {
                    current_statement_begin__ = 1360;
                    int n0(0);
                    (void) n0;  // dummy to suppress unused var warning
                    stan::math::fill(n0, std::numeric_limits<int>::min());
                    stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                    current_statement_begin__ = 1361;
                    int n1(0);
                    (void) n1;  // dummy to suppress unused var warning
                    stan::math::fill(n1, std::numeric_limits<int>::min());
                    stan::math::assign(n1,((n0 + N0) - 1));
                    current_statement_begin__ = 1362;
                    int n2(0);
                    (void) n2;  // dummy to suppress unused var warning
                    stan::math::fill(n2, std::numeric_limits<int>::min());
                    stan::math::assign(n2,((n0 + get_base1(NC, m, "NC", 1)) - 1));
                    current_statement_begin__ = 1363;
                    validate_non_negative_index("mu", "(n2 - n1)", (n2 - n1));
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu((n2 - n1));
                    stan::math::initialize(mu, DUMMY_VAR__);
                    stan::math::fill(mu, DUMMY_VAR__);
                    stan::math::assign(mu,stan::model::rvalue(E_infections, stan::model::cons_list(stan::model::index_min_max((n1 + 1), n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "E_infections"));
                    current_statement_begin__ = 1364;
                    validate_non_negative_index("sigma", "(n2 - n1)", (n2 - n1));
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma((n2 - n1));
                    stan::math::initialize(sigma, DUMMY_VAR__);
                    stan::math::fill(sigma, DUMMY_VAR__);
                    stan::math::assign(sigma,multiply(get_base1(inf_aux, 1, "inf_aux", 1), stan::model::rvalue(E_infections, stan::model::cons_list(stan::model::index_min_max((n1 + 1), n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "E_infections")));
                    current_statement_begin__ = 1365;
                    if (as_bool(fixed_vtm)) {
                        current_statement_begin__ = 1365;
                        stan::math::assign(sigma, stan::math::sqrt(sigma));
                    }
                    current_statement_begin__ = 1366;
                    lp_accum__.add(normal_log(stan::model::rvalue(infections_raw, stan::model::cons_list(stan::model::index_min_max(idx, (((idx + get_base1(NC, m, "NC", 1)) - N0) - 1)), stan::model::nil_index_list()), "infections_raw"), mu, sigma));
                    current_statement_begin__ = 1367;
                    stan::math::assign(idx, (idx + (get_base1(NC, m, "NC", 1) - N0)));
                    }
                }
                }
                current_statement_begin__ = 1373;
                if (as_bool(logical_eq(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 1))) {
                    current_statement_begin__ = 1374;
                    lp_accum__.add(normal_log(get_base1(inf_aux_raw, 1, "inf_aux_raw", 1), 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 2))) {
                    current_statement_begin__ = 1376;
                    lp_accum__.add(student_t_log(get_base1(inf_aux_raw, 1, "inf_aux_raw", 1), get_base1(prior_df_for_inf_aux, 1, "prior_df_for_inf_aux", 1), 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 3))) {
                    current_statement_begin__ = 1378;
                    lp_accum__.add(exponential_log(get_base1(inf_aux_raw, 1, "inf_aux_raw", 1), 1));
                }
            }
            current_statement_begin__ = 1381;
            if (as_bool(hseeds)) {
                current_statement_begin__ = 1382;
                if (as_bool(logical_eq(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 1))) {
                    current_statement_begin__ = 1383;
                    lp_accum__.add(normal_log(get_base1(seeds_aux_raw, 1, "seeds_aux_raw", 1), 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 2))) {
                    current_statement_begin__ = 1385;
                    lp_accum__.add(student_t_log(get_base1(seeds_aux_raw, 1, "seeds_aux_raw", 1), get_base1(prior_df_for_seeds_aux, 1, "prior_df_for_seeds_aux", 1), 0, 1));
                } else if (as_bool(logical_eq(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 3))) {
                    current_statement_begin__ = 1387;
                    lp_accum__.add(exponential_log(get_base1(seeds_aux_raw, 1, "seeds_aux_raw", 1), 1));
                }
            }
            current_statement_begin__ = 1391;
            if (as_bool(logical_eq(prior_dist_for_seeds, 1))) {
                current_statement_begin__ = 1392;
                lp_accum__.add(normal_log(seeds_raw, prior_mean_for_seeds, prior_scale_for_seeds));
            } else if (as_bool(logical_eq(prior_dist_for_seeds, 2))) {
                current_statement_begin__ = 1394;
                lp_accum__.add(student_t_log(seeds_raw, prior_df_for_seeds, 0, 1));
            } else if (as_bool((primitive_value(logical_eq(prior_dist_for_seeds, 3)) || primitive_value(logical_eq(prior_dist_for_seeds, 9))))) {
                current_statement_begin__ = 1396;
                lp_accum__.add(exponential_log(seeds_raw, 1));
            }
            current_statement_begin__ = 1399;
            if (as_bool(logical_negation(S0_fixed))) {
                current_statement_begin__ = 1400;
                lp_accum__.add(normal_log(S0, prior_mean_for_S0, prior_scale_for_S0));
            }
            current_statement_begin__ = 1403;
            if (as_bool(logical_negation(veps_fixed))) {
                current_statement_begin__ = 1404;
                lp_accum__.add(normal_log(veps, prior_mean_for_veps, prior_scale_for_veps));
            }
            current_statement_begin__ = 1406;
            if (as_bool(logical_gt(t, 0))) {
                {
                current_statement_begin__ = 1407;
                local_scalar_t__ dummy(DUMMY_VAR__);
                (void) dummy;  // dummy to suppress unused var warning
                stan::math::initialize(dummy, DUMMY_VAR__);
                stan::math::fill(dummy, DUMMY_VAR__);
                stan::math::assign(dummy,decov_lp(z_b, z_T, rho, zeta, tau, regularization, delta, shape, t, p, lp__, lp_accum__, pstream__));
                }
            }
            current_statement_begin__ = 1411;
            if (as_bool(logical_eq(prior_PD, 0))) {
                {
                current_statement_begin__ = 1412;
                int i(0);
                (void) i;  // dummy to suppress unused var warning
                stan::math::fill(i, std::numeric_limits<int>::min());
                stan::math::assign(i,1);
                current_statement_begin__ = 1413;
                for (int r = 1; r <= R; ++r) {
                    current_statement_begin__ = 1414;
                    if (as_bool(logical_eq(get_base1(ofamily, r, "ofamily", 1), 1))) {
                        current_statement_begin__ = 1415;
                        lp_accum__.add(poisson_log(segment(obs, i, get_base1(oN, r, "oN", 1)), add(segment(E_obs, i, get_base1(oN, r, "oN", 1)), 1e-15)));
                    } else if (as_bool(logical_eq(get_base1(ofamily, r, "ofamily", 1), 2))) {
                        current_statement_begin__ = 1418;
                        lp_accum__.add(neg_binomial_2_log(segment(obs, i, get_base1(oN, r, "oN", 1)), add(segment(E_obs, i, get_base1(oN, r, "oN", 1)), 1e-15), get_base1(oaux, get_base1(has_oaux, r, "has_oaux", 1), "oaux", 1)));
                    } else if (as_bool(logical_eq(get_base1(ofamily, r, "ofamily", 1), 3))) {
                        current_statement_begin__ = 1422;
                        lp_accum__.add(neg_binomial_2_log(segment(obs, i, get_base1(oN, r, "oN", 1)), add(segment(E_obs, i, get_base1(oN, r, "oN", 1)), 1e-15), divide(add(segment(E_obs, i, get_base1(oN, r, "oN", 1)), 1e-15), get_base1(oaux, get_base1(has_oaux, r, "has_oaux", 1), "oaux", 1))));
                    } else if (as_bool(logical_eq(get_base1(ofamily, r, "ofamily", 1), 4))) {
                        current_statement_begin__ = 1426;
                        lp_accum__.add(normal_log(segment(obs_real, i, get_base1(oN, r, "oN", 1)), add(segment(E_obs, i, get_base1(oN, r, "oN", 1)), 1e-15), get_base1(oaux, get_base1(has_oaux, r, "has_oaux", 1), "oaux", 1)));
                    } else {
                        current_statement_begin__ = 1429;
                        lp_accum__.add(lognormal_log(segment(obs_real, i, get_base1(oN, r, "oN", 1)), add(subtract(stan::math::log(segment(E_obs, i, get_base1(oN, r, "oN", 1))), (pow(get_base1(oaux, get_base1(has_oaux, r, "has_oaux", 1), "oaux", 1), 2) / 2)), 1e-15), get_base1(oaux, get_base1(has_oaux, r, "has_oaux", 1), "oaux", 1)));
                    }
                    current_statement_begin__ = 1432;
                    stan::math::assign(i, (i + get_base1(oN, r, "oN", 1)));
                }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("ogamma");
        names__.push_back("gamma_raw");
        names__.push_back("oaux_raw");
        names__.push_back("inf_aux_raw");
        names__.push_back("z_beta");
        names__.push_back("global");
        names__.push_back("local");
        names__.push_back("caux");
        names__.push_back("mix");
        names__.push_back("one_over_lambda");
        names__.push_back("z_b");
        names__.push_back("z_T");
        names__.push_back("rho");
        names__.push_back("zeta");
        names__.push_back("tau");
        names__.push_back("ac_scale_raw");
        names__.push_back("ac_noise");
        names__.push_back("obs_ac_scale_raw");
        names__.push_back("obs_ac_noise");
        names__.push_back("oz_beta");
        names__.push_back("seeds_aux_raw");
        names__.push_back("seeds_raw");
        names__.push_back("infections_raw");
        names__.push_back("S0");
        names__.push_back("veps");
        names__.push_back("oeta");
        names__.push_back("E_obs");
        names__.push_back("eta");
        names__.push_back("oaux");
        names__.push_back("inf_aux");
        names__.push_back("seeds_aux");
        names__.push_back("gamma");
        names__.push_back("seeds");
        names__.push_back("Rt_unadj");
        names__.push_back("load");
        names__.push_back("E_infections");
        names__.push_back("infections");
        names__.push_back("susc");
        names__.push_back("ac_scale");
        names__.push_back("ac_beta");
        names__.push_back("obs_ac_scale");
        names__.push_back("obs_ac_beta");
        names__.push_back("obeta");
        names__.push_back("beta");
        names__.push_back("b");
        names__.push_back("theta_L");
        names__.push_back("alpha");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(num_ointercepts);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_oaux);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(latent);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_dist, 7) ? sum(num_normals) : K ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_gt(hs, 0));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6))));
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(prior_dist, 6));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_z_T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_rho);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_concentration);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ac_nproc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ac_q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(obs_ac_nproc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(obs_ac_q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K_all);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hseeds);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((latent ? (N - (M * N0)) : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((S0_fixed ? 0 : M ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((veps_fixed ? 0 : M ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_obs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_obs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_oaux);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(latent);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hseeds);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ac_nproc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ac_q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(obs_ac_nproc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(obs_ac_q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K_all);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_theta_L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_epidemia_base_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> ogamma = in__.vector_constrain(num_ointercepts);
        size_t ogamma_j_1_max__ = num_ointercepts;
        for (size_t j_1__ = 0; j_1__ < ogamma_j_1_max__; ++j_1__) {
            vars__.push_back(ogamma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_raw = in__.vector_constrain(has_intercept);
        size_t gamma_raw_j_1_max__ = has_intercept;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            vars__.push_back(gamma_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> oaux_raw = in__.vector_lb_constrain(0, num_oaux);
        size_t oaux_raw_j_1_max__ = num_oaux;
        for (size_t j_1__ = 0; j_1__ < oaux_raw_j_1_max__; ++j_1__) {
            vars__.push_back(oaux_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> inf_aux_raw = in__.vector_lb_constrain(0, latent);
        size_t inf_aux_raw_j_1_max__ = latent;
        for (size_t j_1__ = 0; j_1__ < inf_aux_raw_j_1_max__; ++j_1__) {
            vars__.push_back(inf_aux_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_beta = in__.vector_ub_constrain((logical_eq(prior_dist, 8) ? stan::math::promote_scalar<double>(0) : stan::math::promote_scalar<double>(stan::math::positive_infinity()) ), (logical_eq(prior_dist, 7) ? sum(num_normals) : K ));
        size_t z_beta_j_1_max__ = (logical_eq(prior_dist, 7) ? sum(num_normals) : K );
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            vars__.push_back(z_beta(j_1__));
        }
        std::vector<double> global;
        size_t global_d_0_max__ = hs;
        global.reserve(global_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < global_d_0_max__; ++d_0__) {
            global.push_back(in__.scalar_lb_constrain(0));
        }
        size_t global_k_0_max__ = hs;
        for (size_t k_0__ = 0; k_0__ < global_k_0_max__; ++k_0__) {
            vars__.push_back(global[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > local;
        size_t local_d_0_max__ = hs;
        local.reserve(local_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < local_d_0_max__; ++d_0__) {
            local.push_back(in__.vector_lb_constrain(0, K));
        }
        size_t local_j_1_max__ = K;
        size_t local_k_0_max__ = hs;
        for (size_t j_1__ = 0; j_1__ < local_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < local_k_0_max__; ++k_0__) {
                vars__.push_back(local[k_0__](j_1__));
            }
        }
        std::vector<double> caux;
        size_t caux_d_0_max__ = logical_gt(hs, 0);
        caux.reserve(caux_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < caux_d_0_max__; ++d_0__) {
            caux.push_back(in__.scalar_lb_constrain(0));
        }
        size_t caux_k_0_max__ = logical_gt(hs, 0);
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            vars__.push_back(caux[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mix;
        size_t mix_d_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
        mix.reserve(mix_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mix_d_0_max__; ++d_0__) {
            mix.push_back(in__.vector_lb_constrain(0, K));
        }
        size_t mix_j_1_max__ = K;
        size_t mix_k_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
        for (size_t j_1__ = 0; j_1__ < mix_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mix_k_0_max__; ++k_0__) {
                vars__.push_back(mix[k_0__](j_1__));
            }
        }
        std::vector<double> one_over_lambda;
        size_t one_over_lambda_d_0_max__ = logical_eq(prior_dist, 6);
        one_over_lambda.reserve(one_over_lambda_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < one_over_lambda_d_0_max__; ++d_0__) {
            one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }
        size_t one_over_lambda_k_0_max__ = logical_eq(prior_dist, 6);
        for (size_t k_0__ = 0; k_0__ < one_over_lambda_k_0_max__; ++k_0__) {
            vars__.push_back(one_over_lambda[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_b = in__.vector_constrain(q);
        size_t z_b_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < z_b_j_1_max__; ++j_1__) {
            vars__.push_back(z_b(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_T = in__.vector_constrain(len_z_T);
        size_t z_T_j_1_max__ = len_z_T;
        for (size_t j_1__ = 0; j_1__ < z_T_j_1_max__; ++j_1__) {
            vars__.push_back(z_T(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho = in__.vector_lub_constrain(0, 1, len_rho);
        size_t rho_j_1_max__ = len_rho;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            vars__.push_back(rho(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> zeta = in__.vector_lb_constrain(0, len_concentration);
        size_t zeta_j_1_max__ = len_concentration;
        for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
            vars__.push_back(zeta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau = in__.vector_lb_constrain(0, t);
        size_t tau_j_1_max__ = t;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            vars__.push_back(tau(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ac_scale_raw = in__.vector_lb_constrain(0, ac_nproc);
        size_t ac_scale_raw_j_1_max__ = ac_nproc;
        for (size_t j_1__ = 0; j_1__ < ac_scale_raw_j_1_max__; ++j_1__) {
            vars__.push_back(ac_scale_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ac_noise = in__.vector_constrain(ac_q);
        size_t ac_noise_j_1_max__ = ac_q;
        for (size_t j_1__ = 0; j_1__ < ac_noise_j_1_max__; ++j_1__) {
            vars__.push_back(ac_noise(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> obs_ac_scale_raw = in__.vector_lb_constrain(0, obs_ac_nproc);
        size_t obs_ac_scale_raw_j_1_max__ = obs_ac_nproc;
        for (size_t j_1__ = 0; j_1__ < obs_ac_scale_raw_j_1_max__; ++j_1__) {
            vars__.push_back(obs_ac_scale_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> obs_ac_noise = in__.vector_constrain(obs_ac_q);
        size_t obs_ac_noise_j_1_max__ = obs_ac_q;
        for (size_t j_1__ = 0; j_1__ < obs_ac_noise_j_1_max__; ++j_1__) {
            vars__.push_back(obs_ac_noise(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> oz_beta = in__.vector_constrain(K_all);
        size_t oz_beta_j_1_max__ = K_all;
        for (size_t j_1__ = 0; j_1__ < oz_beta_j_1_max__; ++j_1__) {
            vars__.push_back(oz_beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> seeds_aux_raw = in__.vector_lb_constrain(0, hseeds);
        size_t seeds_aux_raw_j_1_max__ = hseeds;
        for (size_t j_1__ = 0; j_1__ < seeds_aux_raw_j_1_max__; ++j_1__) {
            vars__.push_back(seeds_aux_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> seeds_raw = in__.vector_lb_constrain(0, M);
        size_t seeds_raw_j_1_max__ = M;
        for (size_t j_1__ = 0; j_1__ < seeds_raw_j_1_max__; ++j_1__) {
            vars__.push_back(seeds_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> infections_raw = in__.vector_lb_constrain(0, (latent ? (N - (M * N0)) : 0 ));
        size_t infections_raw_j_1_max__ = (latent ? (N - (M * N0)) : 0 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            vars__.push_back(infections_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> S0 = in__.vector_lub_constrain(0, 1, (S0_fixed ? 0 : M ));
        size_t S0_j_1_max__ = (S0_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            vars__.push_back(S0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> veps = in__.vector_lub_constrain(0, 1, (veps_fixed ? 0 : M ));
        size_t veps_j_1_max__ = (veps_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            vars__.push_back(veps(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 811;
            validate_non_negative_index("oeta", "N_obs", N_obs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> oeta(N_obs);
            stan::math::initialize(oeta, DUMMY_VAR__);
            stan::math::fill(oeta, DUMMY_VAR__);
            current_statement_begin__ = 812;
            validate_non_negative_index("E_obs", "N_obs", N_obs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> E_obs(N_obs);
            stan::math::initialize(E_obs, DUMMY_VAR__);
            stan::math::fill(E_obs, DUMMY_VAR__);
            current_statement_begin__ = 813;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta(N);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 814;
            validate_non_negative_index("oaux", "num_oaux", num_oaux);
            Eigen::Matrix<double, Eigen::Dynamic, 1> oaux(num_oaux);
            stan::math::initialize(oaux, DUMMY_VAR__);
            stan::math::fill(oaux, DUMMY_VAR__);
            stan::math::assign(oaux,oaux_raw);
            current_statement_begin__ = 815;
            validate_non_negative_index("inf_aux", "latent", latent);
            Eigen::Matrix<double, Eigen::Dynamic, 1> inf_aux(latent);
            stan::math::initialize(inf_aux, DUMMY_VAR__);
            stan::math::fill(inf_aux, DUMMY_VAR__);
            stan::math::assign(inf_aux,inf_aux_raw);
            current_statement_begin__ = 816;
            validate_non_negative_index("seeds_aux", "hseeds", hseeds);
            Eigen::Matrix<double, Eigen::Dynamic, 1> seeds_aux(hseeds);
            stan::math::initialize(seeds_aux, DUMMY_VAR__);
            stan::math::fill(seeds_aux, DUMMY_VAR__);
            stan::math::assign(seeds_aux,seeds_aux_raw);
            current_statement_begin__ = 817;
            validate_non_negative_index("gamma", "has_intercept", has_intercept);
            Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(has_intercept);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma, DUMMY_VAR__);
            current_statement_begin__ = 818;
            validate_non_negative_index("seeds", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, 1> seeds(M);
            stan::math::initialize(seeds, DUMMY_VAR__);
            stan::math::fill(seeds, DUMMY_VAR__);
            stan::math::assign(seeds,seeds_raw);
            current_statement_begin__ = 820;
            validate_non_negative_index("Rt_unadj", "N2", N2);
            validate_non_negative_index("Rt_unadj", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Rt_unadj(N2, M);
            stan::math::initialize(Rt_unadj, DUMMY_VAR__);
            stan::math::fill(Rt_unadj, DUMMY_VAR__);
            stan::math::assign(Rt_unadj,rep_matrix(0, N2, M));
            current_statement_begin__ = 821;
            validate_non_negative_index("load", "N2", N2);
            validate_non_negative_index("load", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> load(N2, M);
            stan::math::initialize(load, DUMMY_VAR__);
            stan::math::fill(load, DUMMY_VAR__);
            stan::math::assign(load,rep_matrix(0, N2, M));
            current_statement_begin__ = 822;
            validate_non_negative_index("E_infections", "N2", N2);
            validate_non_negative_index("E_infections", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> E_infections(N2, M);
            stan::math::initialize(E_infections, DUMMY_VAR__);
            stan::math::fill(E_infections, DUMMY_VAR__);
            stan::math::assign(E_infections,rep_matrix(0, N2, M));
            current_statement_begin__ = 823;
            validate_non_negative_index("infections", "N2", N2);
            validate_non_negative_index("infections", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> infections(N2, M);
            stan::math::initialize(infections, DUMMY_VAR__);
            stan::math::fill(infections, DUMMY_VAR__);
            stan::math::assign(infections,rep_matrix(0, N2, M));
            current_statement_begin__ = 824;
            validate_non_negative_index("susc", "N2", N2);
            validate_non_negative_index("susc", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> susc(N2, M);
            stan::math::initialize(susc, DUMMY_VAR__);
            stan::math::fill(susc, DUMMY_VAR__);
            stan::math::assign(susc,rep_matrix(0, N2, M));
            current_statement_begin__ = 825;
            validate_non_negative_index("ac_scale", "ac_nproc", ac_nproc);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ac_scale(ac_nproc);
            stan::math::initialize(ac_scale, DUMMY_VAR__);
            stan::math::fill(ac_scale, DUMMY_VAR__);
            stan::math::assign(ac_scale,elt_multiply(ac_scale_raw, ac_prior_scales));
            current_statement_begin__ = 826;
            validate_non_negative_index("ac_beta", "ac_q", ac_q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ac_beta(ac_q);
            stan::math::initialize(ac_beta, DUMMY_VAR__);
            stan::math::fill(ac_beta, DUMMY_VAR__);
            current_statement_begin__ = 828;
            validate_non_negative_index("obs_ac_scale", "obs_ac_nproc", obs_ac_nproc);
            Eigen::Matrix<double, Eigen::Dynamic, 1> obs_ac_scale(obs_ac_nproc);
            stan::math::initialize(obs_ac_scale, DUMMY_VAR__);
            stan::math::fill(obs_ac_scale, DUMMY_VAR__);
            stan::math::assign(obs_ac_scale,elt_multiply(obs_ac_scale_raw, obs_ac_prior_scales));
            current_statement_begin__ = 829;
            validate_non_negative_index("obs_ac_beta", "obs_ac_q", obs_ac_q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> obs_ac_beta(obs_ac_q);
            stan::math::initialize(obs_ac_beta, DUMMY_VAR__);
            stan::math::fill(obs_ac_beta, DUMMY_VAR__);
            current_statement_begin__ = 830;
            validate_non_negative_index("obeta", "K_all", K_all);
            Eigen::Matrix<double, Eigen::Dynamic, 1> obeta(K_all);
            stan::math::initialize(obeta, DUMMY_VAR__);
            stan::math::fill(obeta, DUMMY_VAR__);
            stan::math::assign(obeta,add(elt_multiply(oz_beta, prior_oscale), prior_omean));
            current_statement_begin__ = 831;
            validate_non_negative_index("beta", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(K);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 832;
            validate_non_negative_index("b", "q", q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b(q);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 833;
            validate_non_negative_index("theta_L", "len_theta_L", len_theta_L);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_L(len_theta_L);
            stan::math::initialize(theta_L, DUMMY_VAR__);
            stan::math::fill(theta_L, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 834;
            if (as_bool(logical_eq(prior_dist, 0))) {
                current_statement_begin__ = 834;
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist, 1))) {
                current_statement_begin__ = 835;
                stan::math::assign(beta, add(elt_multiply(z_beta, prior_scale), prior_mean));
            } else if (as_bool(logical_eq(prior_dist, 2))) {
                current_statement_begin__ = 836;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 837;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                ((CFt(get_base1(z_beta, k, "z_beta", 1), get_base1(prior_df, k, "prior_df", 1), pstream__) * get_base1(prior_scale, k, "prior_scale", 1)) + get_base1(prior_mean, k, "prior_mean", 1)), 
                                "assigning variable beta");
                }
            } else if (as_bool(logical_eq(prior_dist, 3))) {
                {
                current_statement_begin__ = 840;
                local_scalar_t__ c2(DUMMY_VAR__);
                (void) c2;  // dummy to suppress unused var warning
                stan::math::initialize(c2, DUMMY_VAR__);
                stan::math::fill(c2, DUMMY_VAR__);
                stan::math::assign(c2,(square(slab_scale) * get_base1(caux, 1, "caux", 1)));
                current_statement_begin__ = 841;
                stan::math::assign(beta, hs_prior(z_beta, global, local, global_prior_scale, 1, c2, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist, 4))) {
                {
                current_statement_begin__ = 844;
                local_scalar_t__ c2(DUMMY_VAR__);
                (void) c2;  // dummy to suppress unused var warning
                stan::math::initialize(c2, DUMMY_VAR__);
                stan::math::fill(c2, DUMMY_VAR__);
                stan::math::assign(c2,(square(slab_scale) * get_base1(caux, 1, "caux", 1)));
                current_statement_begin__ = 845;
                stan::math::assign(beta, hsplus_prior(z_beta, global, local, global_prior_scale, 1, c2, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist, 5))) {
                current_statement_begin__ = 848;
                stan::math::assign(beta, add(prior_mean, elt_multiply(elt_multiply(prior_scale, stan::math::sqrt(multiply(2, get_base1(mix, 1, "mix", 1)))), z_beta)));
            } else if (as_bool(logical_eq(prior_dist, 6))) {
                current_statement_begin__ = 850;
                stan::math::assign(beta, add(prior_mean, elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda, 1, "one_over_lambda", 1), prior_scale), stan::math::sqrt(multiply(2, get_base1(mix, 1, "mix", 1)))), z_beta)));
            } else if (as_bool(logical_eq(prior_dist, 7))) {
                {
                current_statement_begin__ = 852;
                int z_pos(0);
                (void) z_pos;  // dummy to suppress unused var warning
                stan::math::fill(z_pos, std::numeric_limits<int>::min());
                stan::math::assign(z_pos,1);
                current_statement_begin__ = 853;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 854;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                get_base1(z_beta, z_pos, "z_beta", 1), 
                                "assigning variable beta");
                    current_statement_begin__ = 855;
                    stan::math::assign(z_pos, (z_pos + 1));
                    current_statement_begin__ = 856;
                    for (int n = 2; n <= get_base1(num_normals, k, "num_normals", 1); ++n) {
                        current_statement_begin__ = 857;
                        stan::model::assign(beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "beta") * get_base1(z_beta, z_pos, "z_beta", 1)), 
                                    "assigning variable beta");
                        current_statement_begin__ = 858;
                        stan::math::assign(z_pos, (z_pos + 1));
                    }
                    current_statement_begin__ = 860;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "beta") * pow(get_base1(prior_scale, k, "prior_scale", 1), get_base1(num_normals, k, "num_normals", 1))), 
                                "assigning variable beta");
                    current_statement_begin__ = 861;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), "beta") + get_base1(prior_mean, k, "prior_mean", 1)), 
                                "assigning variable beta");
                }
                }
            } else if (as_bool(logical_eq(prior_dist, 8))) {
                current_statement_begin__ = 864;
                stan::math::assign(beta, add(z_beta, prior_shift));
            }
            current_statement_begin__ = 867;
            for (int i = 1; i <= num_oaux; ++i) {
                current_statement_begin__ = 868;
                if (as_bool(logical_gt(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 0))) {
                    current_statement_begin__ = 869;
                    if (as_bool(logical_gt(get_base1(prior_scale_for_oaux, i, "prior_scale_for_oaux", 1), 0))) {
                        current_statement_begin__ = 870;
                        stan::model::assign(oaux, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(oaux, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "oaux") * get_base1(prior_scale_for_oaux, i, "prior_scale_for_oaux", 1)), 
                                    "assigning variable oaux");
                    }
                    current_statement_begin__ = 872;
                    if (as_bool(logical_lte(get_base1(prior_dist_for_oaux, i, "prior_dist_for_oaux", 1), 2))) {
                        current_statement_begin__ = 873;
                        stan::model::assign(oaux, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(oaux, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "oaux") + get_base1(prior_mean_for_oaux, i, "prior_mean_for_oaux", 1)), 
                                    "assigning variable oaux");
                    }
                }
            }
            current_statement_begin__ = 878;
            if (as_bool(has_intercept)) {
                current_statement_begin__ = 879;
                if (as_bool((primitive_value(logical_eq(get_base1(prior_dist_for_intercept, 1, "prior_dist_for_intercept", 1), 1)) || primitive_value(logical_eq(get_base1(prior_dist_for_intercept, 1, "prior_dist_for_intercept", 1), 2))))) {
                    current_statement_begin__ = 880;
                    stan::math::assign(gamma, add(multiply(gamma_raw, get_base1(prior_scale_for_intercept, 1, "prior_scale_for_intercept", 1)), get_base1(prior_mean_for_intercept, 1, "prior_mean_for_intercept", 1)));
                }
            }
            current_statement_begin__ = 884;
            if (as_bool(latent)) {
                current_statement_begin__ = 885;
                if (as_bool(logical_gt(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 0))) {
                    current_statement_begin__ = 886;
                    if (as_bool(logical_gt(get_base1(prior_scale_for_inf_aux, 1, "prior_scale_for_inf_aux", 1), 0))) {
                        current_statement_begin__ = 887;
                        stan::model::assign(inf_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(inf_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "inf_aux") * get_base1(prior_scale_for_inf_aux, 1, "prior_scale_for_inf_aux", 1)), 
                                    "assigning variable inf_aux");
                    }
                    current_statement_begin__ = 889;
                    if (as_bool(logical_lte(get_base1(prior_dist_for_inf_aux, 1, "prior_dist_for_inf_aux", 1), 2))) {
                        current_statement_begin__ = 890;
                        stan::model::assign(inf_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(inf_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "inf_aux") + get_base1(prior_mean_for_inf_aux, 1, "prior_mean_for_inf_aux", 1)), 
                                    "assigning variable inf_aux");
                    }
                }
            }
            current_statement_begin__ = 896;
            if (as_bool(hseeds)) {
                current_statement_begin__ = 897;
                if (as_bool(logical_gt(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 0))) {
                    current_statement_begin__ = 898;
                    if (as_bool(logical_gt(get_base1(prior_scale_for_seeds_aux, 1, "prior_scale_for_seeds_aux", 1), 0))) {
                        current_statement_begin__ = 899;
                        stan::model::assign(seeds_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(seeds_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "seeds_aux") * get_base1(prior_scale_for_seeds_aux, 1, "prior_scale_for_seeds_aux", 1)), 
                                    "assigning variable seeds_aux");
                    }
                    current_statement_begin__ = 901;
                    if (as_bool(logical_lte(get_base1(prior_dist_for_seeds_aux, 1, "prior_dist_for_seeds_aux", 1), 2))) {
                        current_statement_begin__ = 902;
                        stan::model::assign(seeds_aux, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(seeds_aux, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "seeds_aux") + get_base1(prior_mean_for_seeds_aux, 1, "prior_mean_for_seeds_aux", 1)), 
                                    "assigning variable seeds_aux");
                    }
                }
            }
            current_statement_begin__ = 908;
            if (as_bool(logical_eq(prior_dist_for_seeds, 3))) {
                current_statement_begin__ = 909;
                stan::math::assign(seeds, elt_multiply(seeds, prior_scale_for_seeds));
            }
            current_statement_begin__ = 912;
            if (as_bool(logical_eq(prior_dist_for_seeds, 9))) {
                current_statement_begin__ = 913;
                stan::math::assign(seeds, multiply(seeds, get_base1(seeds_aux, 1, "seeds_aux", 1)));
            }
            {
            current_statement_begin__ = 917;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 918;
            for (int proc = 1; proc <= ac_nproc; ++proc) {
                current_statement_begin__ = 919;
                stan::model::assign(ac_beta, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(ac_ntime, proc, "ac_ntime", 1)) - 1)), stan::model::nil_index_list()), 
                            cumulative_sum(stan::model::rvalue(ac_noise, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(ac_ntime, proc, "ac_ntime", 1)) - 1)), stan::model::nil_index_list()), "ac_noise")), 
                            "assigning variable ac_beta");
                current_statement_begin__ = 920;
                stan::math::assign(i, (i + get_base1(ac_ntime, proc, "ac_ntime", 1)));
            }
            current_statement_begin__ = 923;
            stan::math::assign(i, 1);
            current_statement_begin__ = 924;
            for (int proc = 1; proc <= obs_ac_nproc; ++proc) {
                current_statement_begin__ = 925;
                stan::model::assign(obs_ac_beta, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)) - 1)), stan::model::nil_index_list()), 
                            cumulative_sum(stan::model::rvalue(obs_ac_noise, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)) - 1)), stan::model::nil_index_list()), "obs_ac_noise")), 
                            "assigning variable obs_ac_beta");
                current_statement_begin__ = 926;
                stan::math::assign(i, (i + get_base1(obs_ac_ntime, proc, "obs_ac_ntime", 1)));
            }
            }
            current_statement_begin__ = 930;
            if (as_bool(logical_gt(K, 0))) {
                current_statement_begin__ = 931;
                stan::math::assign(eta, multiply(X, beta));
            } else {
                current_statement_begin__ = 933;
                stan::math::assign(eta, rep_vector(0.0, N));
            }
            current_statement_begin__ = 935;
            if (as_bool(logical_gt(t, 0))) {
                current_statement_begin__ = 936;
                if (as_bool(logical_eq(special_case, 1))) {
                    {
                    current_statement_begin__ = 937;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,1);
                    current_statement_begin__ = 938;
                    stan::math::assign(theta_L, elt_multiply(scale, tau));
                    current_statement_begin__ = 939;
                    if (as_bool(logical_eq(t, 1))) {
                        current_statement_begin__ = 939;
                        stan::math::assign(b, multiply(get_base1(theta_L, 1, "theta_L", 1), z_b));
                    } else {
                        current_statement_begin__ = 940;
                        for (int i = 1; i <= t; ++i) {
                            {
                            current_statement_begin__ = 941;
                            int end(0);
                            (void) end;  // dummy to suppress unused var warning
                            stan::math::fill(end, std::numeric_limits<int>::min());
                            stan::math::assign(end,((start + get_base1(l, i, "l", 1)) - 1));
                            current_statement_begin__ = 942;
                            stan::model::assign(b, 
                                        stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                        multiply(get_base1(theta_L, i, "theta_L", 1), stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                        "assigning variable b");
                            current_statement_begin__ = 943;
                            stan::math::assign(start, (end + 1));
                            }
                        }
                    }
                    }
                } else {
                    current_statement_begin__ = 947;
                    stan::math::assign(theta_L, make_theta_L(len_theta_L, p, 1.0, tau, scale, zeta, rho, z_T, pstream__));
                    current_statement_begin__ = 949;
                    stan::math::assign(b, make_b(z_b, theta_L, p, l, pstream__));
                }
            }
            current_statement_begin__ = 953;
            if (as_bool(logical_gt(t, 0))) {
                current_statement_begin__ = 954;
                if (as_bool(special_case)) {
                    current_statement_begin__ = 954;
                    for (int i = 1; i <= t; ++i) {
                        current_statement_begin__ = 954;
                        stan::math::assign(eta, add(eta, stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V, i, "V", 1)), stan::model::nil_index_list()), "b")));
                    }
                } else {
                    current_statement_begin__ = 955;
                    stan::math::assign(eta, add(eta, csr_matrix_times_vector2(N, q, w, v, u, b, pstream__)));
                }
            }
            current_statement_begin__ = 957;
            if (as_bool(logical_eq(has_intercept, 1))) {
                current_statement_begin__ = 958;
                stan::math::assign(eta, add(eta, get_base1(gamma, 1, "gamma", 1)));
            } else {
                current_statement_begin__ = 962;
                stan::math::assign(eta, add(eta, dot_product(xbar, beta)));
            }
            current_statement_begin__ = 965;
            if (as_bool(logical_gt(ac_nterms, 0))) {
                current_statement_begin__ = 966;
                for (int i = 1; i <= ac_nterms; ++i) {
                    current_statement_begin__ = 967;
                    for (int j = 1; j <= N; ++j) {
                        current_statement_begin__ = 968;
                        if (as_bool(logical_gt(get_base1(get_base1(ac_V, i, "ac_V", 1), j, "ac_V", 2), 0))) {
                            current_statement_begin__ = 969;
                            stan::model::assign(eta, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "eta") + get_base1(ac_beta, get_base1(get_base1(ac_V, i, "ac_V", 1), j, "ac_V", 2), "ac_beta", 1)), 
                                        "assigning variable eta");
                        }
                    }
                }
            }
            {
            current_statement_begin__ = 978;
            int npos(0);
            (void) npos;  // dummy to suppress unused var warning
            stan::math::fill(npos, std::numeric_limits<int>::min());
            stan::math::assign(npos,1);
            current_statement_begin__ = 979;
            int kpos(0);
            (void) kpos;  // dummy to suppress unused var warning
            stan::math::fill(kpos, std::numeric_limits<int>::min());
            stan::math::assign(kpos,1);
            current_statement_begin__ = 980;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 981;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 983;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 984;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX1, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 986;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 989;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 990;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 992;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 998;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 999;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1000;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1001;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1003;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1004;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX2, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1006;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1009;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1010;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1012;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1018;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1019;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1020;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1021;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1023;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1024;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX3, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1026;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1029;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1030;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1032;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1038;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1039;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1040;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1041;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1043;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1044;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX4, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1046;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1049;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1050;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1052;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1058;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1059;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1060;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1061;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1063;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1064;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX5, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1066;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1069;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1070;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1072;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1078;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1079;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1080;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1081;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1083;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1084;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX6, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1086;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1089;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1090;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1092;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1098;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1099;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1100;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1101;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1103;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1104;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX7, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1106;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1109;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1110;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1112;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1118;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1119;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1120;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1121;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1123;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1124;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX8, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1126;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1129;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1130;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1132;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1138;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1139;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1140;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1141;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1143;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1144;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX9, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1146;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1149;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1150;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1152;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            current_statement_begin__ = 1158;
            stan::math::assign(npos, (npos + get_base1(oN, i, "oN", 1)));
            current_statement_begin__ = 1159;
            stan::math::assign(kpos, (kpos + get_base1(oK, i, "oK", 1)));
            current_statement_begin__ = 1160;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 1161;
            if (as_bool(logical_gte(R, i))) {
                current_statement_begin__ = 1163;
                if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1164;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                multiply(oX10, segment(obeta, kpos, get_base1(oK, i, "oK", 1))), 
                                "assigning variable oeta");
                } else {
                    current_statement_begin__ = 1166;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                rep_vector(0.0, get_base1(oN, i, "oN", 1)), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1169;
                if (as_bool(logical_gt(get_base1(has_ointercept, i, "has_ointercept", 1), 0))) {
                    current_statement_begin__ = 1170;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), get_base1(ogamma, get_base1(has_ointercept, i, "has_ointercept", 1), "ogamma", 1)), 
                                "assigning variable oeta");
                } else if (as_bool(logical_gt(get_base1(oK, i, "oK", 1), 0))) {
                    current_statement_begin__ = 1172;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(npos, ((npos + get_base1(oN, i, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), dot_product(segment(oxbar, kpos, get_base1(oK, i, "oK", 1)), segment(obeta, kpos, get_base1(oK, i, "oK", 1)))), 
                                "assigning variable oeta");
                }
            }
            }
            {
            current_statement_begin__ = 1180;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 1181;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 1182;
                if (as_bool(logical_eq(get_base1(has_offset, r, "has_offset", 1), 1))) {
                    current_statement_begin__ = 1183;
                    stan::model::assign(oeta, 
                                stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), "oeta"), segment(offset_, i, get_base1(oN, r, "oN", 1))), 
                                "assigning variable oeta");
                }
                current_statement_begin__ = 1185;
                stan::math::assign(i, (i + get_base1(oN, r, "oN", 1)));
            }
            }
            current_statement_begin__ = 1190;
            for (int i = 1; i <= obs_ac_nterms; ++i) {
                current_statement_begin__ = 1191;
                for (int j = 1; j <= N_obs; ++j) {
                    current_statement_begin__ = 1192;
                    if (as_bool(logical_gt(get_base1(get_base1(obs_ac_V, i, "obs_ac_V", 1), j, "obs_ac_V", 2), 0))) {
                        current_statement_begin__ = 1193;
                        stan::model::assign(oeta, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(oeta, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "oeta") + get_base1(obs_ac_beta, get_base1(get_base1(obs_ac_V, i, "obs_ac_V", 1), j, "obs_ac_V", 2), "obs_ac_beta", 1)), 
                                    "assigning variable oeta");
                    }
                }
            }
            {
            current_statement_begin__ = 1198;
            int idx1(0);
            (void) idx1;  // dummy to suppress unused var warning
            stan::math::fill(idx1, std::numeric_limits<int>::min());
            stan::math::assign(idx1,1);
            current_statement_begin__ = 1199;
            int idx2(0);
            (void) idx2;  // dummy to suppress unused var warning
            stan::math::fill(idx2, std::numeric_limits<int>::min());
            stan::math::assign(idx2,1);
            current_statement_begin__ = 1200;
            for (int m = 1; m <= M; ++m) {
                {
                current_statement_begin__ = 1202;
                int n0(0);
                (void) n0;  // dummy to suppress unused var warning
                stan::math::fill(n0, std::numeric_limits<int>::min());
                stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                current_statement_begin__ = 1203;
                int n1(0);
                (void) n1;  // dummy to suppress unused var warning
                stan::math::fill(n1, std::numeric_limits<int>::min());
                stan::math::assign(n1,((n0 + N0) - 1));
                current_statement_begin__ = 1204;
                int n2(0);
                (void) n2;  // dummy to suppress unused var warning
                stan::math::fill(n2, std::numeric_limits<int>::min());
                stan::math::assign(n2,((n0 + get_base1(NC, m, "NC", 1)) - 1));
                current_statement_begin__ = 1205;
                int len(0);
                (void) len;  // dummy to suppress unused var warning
                stan::math::fill(len, std::numeric_limits<int>::min());
                current_statement_begin__ = 1206;
                local_scalar_t__ vt(DUMMY_VAR__);
                (void) vt;  // dummy to suppress unused var warning
                stan::math::initialize(vt, DUMMY_VAR__);
                stan::math::fill(vt, DUMMY_VAR__);
                current_statement_begin__ = 1209;
                if (as_bool(logical_eq(link, 1))) {
                    current_statement_begin__ = 1210;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                stan::math::exp(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta")), 
                                "assigning variable Rt_unadj");
                } else if (as_bool(logical_eq(link, 2))) {
                    current_statement_begin__ = 1212;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                multiply(carry, inv_logit(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta"))), 
                                "assigning variable Rt_unadj");
                } else {
                    current_statement_begin__ = 1214;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta"), 
                                "assigning variable Rt_unadj");
                }
                current_statement_begin__ = 1216;
                stan::math::assign(idx1, (idx1 + get_base1(NC, m, "NC", 1)));
                current_statement_begin__ = 1218;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_min_max(n0, n1), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                            rep_vector(get_base1(seeds, m, "seeds", 1), N0), 
                            "assigning variable infections");
                current_statement_begin__ = 1220;
                if (as_bool(pop_adjust)) {
                    current_statement_begin__ = 1221;
                    stan::model::assign(susc, 
                                stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                get_base1(pops, m, "pops", 1), 
                                "assigning variable susc");
                    current_statement_begin__ = 1222;
                    if (as_bool(logical_negation(S0_fixed))) {
                        current_statement_begin__ = 1222;
                        stan::model::assign(susc, 
                                    stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (stan::model::rvalue(susc, stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "susc") * get_base1(S0, m, "S0", 1)), 
                                    "assigning variable susc");
                    }
                }
                current_statement_begin__ = 1225;
                for (int i = n0; i <= n2; ++i) {
                    {
                    current_statement_begin__ = 1227;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,std::max(n0, (i - gen_len)));
                    current_statement_begin__ = 1228;
                    stan::model::assign(load, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                dot_product(sub_col(infections, start, m, (i - start)), tail(gen_rev, (i - start))), 
                                "assigning variable load");
                    current_statement_begin__ = 1230;
                    if (as_bool(logical_gt(i, n1))) {
                        current_statement_begin__ = 1231;
                        stan::model::assign(E_infections, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (get_base1(Rt_unadj, i, m, "Rt_unadj", 1) * get_base1(load, i, m, "load", 1)), 
                                    "assigning variable E_infections");
                        current_statement_begin__ = 1232;
                        if (as_bool(latent)) {
                            current_statement_begin__ = 1232;
                            stan::model::assign(infections, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        get_base1(infections_raw, idx2, "infections_raw", 1), 
                                        "assigning variable infections");
                        } else {
                            current_statement_begin__ = 1233;
                            stan::model::assign(infections, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        get_base1(E_infections, i, m, "E_infections", 1), 
                                        "assigning variable infections");
                        }
                        current_statement_begin__ = 1234;
                        stan::math::assign(idx2, (idx2 + 1));
                    }
                    current_statement_begin__ = 1237;
                    if (as_bool(pop_adjust)) {
                        current_statement_begin__ = 1238;
                        stan::model::assign(infections, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (get_base1(susc, i, m, "susc", 1) * (1 - stan::math::exp((-(get_base1(infections, i, m, "infections", 1)) / get_base1(pops, m, "pops", 1))))), 
                                    "assigning variable infections");
                        current_statement_begin__ = 1239;
                        stan::math::assign(vt, get_base1(vacc, i, m, "vacc", 1));
                        current_statement_begin__ = 1240;
                        if (as_bool(logical_negation(veps_fixed))) {
                            current_statement_begin__ = 1240;
                            stan::math::assign(vt, (vt * get_base1(veps, m, "veps", 1)));
                        }
                        current_statement_begin__ = 1241;
                        if (as_bool(logical_neq(i, n2))) {
                            current_statement_begin__ = 1241;
                            stan::model::assign(susc, 
                                        stan::model::cons_list(stan::model::index_uni((i + 1)), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        ((1 - vt) * (get_base1(susc, i, m, "susc", 1) - get_base1(infections, i, m, "infections", 1))), 
                                        "assigning variable susc");
                        }
                    }
                    }
                }
                }
            }
            }
            {
            current_statement_begin__ = 1247;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 1248;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 1249;
                stan::model::assign(E_obs, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                            linkinv(add(segment(oeta, i, get_base1(oN, r, "oN", 1)), 1e-15), get_base1(olink, r, "olink", 1), pstream__), 
                            "assigning variable E_obs");
                current_statement_begin__ = 1250;
                stan::math::assign(i, (i + get_base1(oN, r, "oN", 1)));
            }
            }
            current_statement_begin__ = 1255;
            for (int i = 1; i <= N_obs; ++i) {
                {
                current_statement_begin__ = 1256;
                int m(0);
                (void) m;  // dummy to suppress unused var warning
                stan::math::fill(m, std::numeric_limits<int>::min());
                stan::math::assign(m,get_base1(obs_group, i, "obs_group", 1));
                current_statement_begin__ = 1257;
                int dt(0);
                (void) dt;  // dummy to suppress unused var warning
                stan::math::fill(dt, std::numeric_limits<int>::min());
                stan::math::assign(dt,get_base1(obs_date, i, "obs_date", 1));
                current_statement_begin__ = 1258;
                int tp(0);
                (void) tp;  // dummy to suppress unused var warning
                stan::math::fill(tp, std::numeric_limits<int>::min());
                stan::math::assign(tp,get_base1(obs_type, i, "obs_type", 1));
                current_statement_begin__ = 1259;
                int n0(0);
                (void) n0;  // dummy to suppress unused var warning
                stan::math::fill(n0, std::numeric_limits<int>::min());
                stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                current_statement_begin__ = 1260;
                if (as_bool(logical_eq(dt, 1))) {
                    current_statement_begin__ = 1261;
                    stan::model::assign(E_obs, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(E_obs, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "E_obs") * (1e-15 * get_base1(infections, 1, m, "infections", 1))), 
                                "assigning variable E_obs");
                } else {
                    {
                    current_statement_begin__ = 1263;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,std::max(n0, (dt - get_base1(pvecs_len, tp, "pvecs_len", 1))));
                    current_statement_begin__ = 1264;
                    stan::model::assign(E_obs, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(E_obs, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "E_obs") * dot_product(sub_col(infections, start, m, (dt - start)), tail(get_base1(pvecs_rev, tp, "pvecs_rev", 1), (dt - start)))), 
                                "assigning variable E_obs");
                    }
                }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 814;
            check_greater_or_equal(function__, "oaux", oaux, 0);
            current_statement_begin__ = 815;
            check_greater_or_equal(function__, "inf_aux", inf_aux, 0);
            current_statement_begin__ = 816;
            check_greater_or_equal(function__, "seeds_aux", seeds_aux, 0);
            current_statement_begin__ = 818;
            check_greater_or_equal(function__, "seeds", seeds, 0);
            current_statement_begin__ = 820;
            check_greater_or_equal(function__, "Rt_unadj", Rt_unadj, 0);
            current_statement_begin__ = 821;
            check_greater_or_equal(function__, "load", load, 0);
            current_statement_begin__ = 822;
            check_greater_or_equal(function__, "E_infections", E_infections, 0);
            current_statement_begin__ = 823;
            check_greater_or_equal(function__, "infections", infections, 0);
            current_statement_begin__ = 824;
            check_greater_or_equal(function__, "susc", susc, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t oeta_j_1_max__ = N_obs;
                for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
                    vars__.push_back(oeta(j_1__));
                }
                size_t E_obs_j_1_max__ = N_obs;
                for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
                    vars__.push_back(E_obs(j_1__));
                }
                size_t eta_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    vars__.push_back(eta(j_1__));
                }
                size_t oaux_j_1_max__ = num_oaux;
                for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
                    vars__.push_back(oaux(j_1__));
                }
                size_t inf_aux_j_1_max__ = latent;
                for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
                    vars__.push_back(inf_aux(j_1__));
                }
                size_t seeds_aux_j_1_max__ = hseeds;
                for (size_t j_1__ = 0; j_1__ < seeds_aux_j_1_max__; ++j_1__) {
                    vars__.push_back(seeds_aux(j_1__));
                }
                size_t gamma_j_1_max__ = has_intercept;
                for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                    vars__.push_back(gamma(j_1__));
                }
                size_t seeds_j_1_max__ = M;
                for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
                    vars__.push_back(seeds(j_1__));
                }
                size_t Rt_unadj_j_2_max__ = M;
                size_t Rt_unadj_j_1_max__ = N2;
                for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                        vars__.push_back(Rt_unadj(j_1__, j_2__));
                    }
                }
                size_t load_j_2_max__ = M;
                size_t load_j_1_max__ = N2;
                for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                        vars__.push_back(load(j_1__, j_2__));
                    }
                }
                size_t E_infections_j_2_max__ = M;
                size_t E_infections_j_1_max__ = N2;
                for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                        vars__.push_back(E_infections(j_1__, j_2__));
                    }
                }
                size_t infections_j_2_max__ = M;
                size_t infections_j_1_max__ = N2;
                for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                        vars__.push_back(infections(j_1__, j_2__));
                    }
                }
                size_t susc_j_2_max__ = M;
                size_t susc_j_1_max__ = N2;
                for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                        vars__.push_back(susc(j_1__, j_2__));
                    }
                }
                size_t ac_scale_j_1_max__ = ac_nproc;
                for (size_t j_1__ = 0; j_1__ < ac_scale_j_1_max__; ++j_1__) {
                    vars__.push_back(ac_scale(j_1__));
                }
                size_t ac_beta_j_1_max__ = ac_q;
                for (size_t j_1__ = 0; j_1__ < ac_beta_j_1_max__; ++j_1__) {
                    vars__.push_back(ac_beta(j_1__));
                }
                size_t obs_ac_scale_j_1_max__ = obs_ac_nproc;
                for (size_t j_1__ = 0; j_1__ < obs_ac_scale_j_1_max__; ++j_1__) {
                    vars__.push_back(obs_ac_scale(j_1__));
                }
                size_t obs_ac_beta_j_1_max__ = obs_ac_q;
                for (size_t j_1__ = 0; j_1__ < obs_ac_beta_j_1_max__; ++j_1__) {
                    vars__.push_back(obs_ac_beta(j_1__));
                }
                size_t obeta_j_1_max__ = K_all;
                for (size_t j_1__ = 0; j_1__ < obeta_j_1_max__; ++j_1__) {
                    vars__.push_back(obeta(j_1__));
                }
                size_t beta_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__));
                }
                size_t b_j_1_max__ = q;
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
                size_t theta_L_j_1_max__ = len_theta_L;
                for (size_t j_1__ = 0; j_1__ < theta_L_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_L(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 1439;
            validate_non_negative_index("alpha", "has_intercept", has_intercept);
            std::vector<double> alpha(has_intercept, double(0));
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 1441;
            if (as_bool(logical_eq(has_intercept, 1))) {
                current_statement_begin__ = 1442;
                stan::model::assign(alpha, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (get_base1(gamma, 1, "gamma", 1) - dot_product(xbar, beta)), 
                            "assigning variable alpha");
            }
            // validate, write generated quantities
            current_statement_begin__ = 1439;
            size_t alpha_k_0_max__ = has_intercept;
            for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
                vars__.push_back(alpha[k_0__]);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_epidemia_base";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t ogamma_j_1_max__ = num_ointercepts;
        for (size_t j_1__ = 0; j_1__ < ogamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ogamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_raw_j_1_max__ = has_intercept;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oaux_raw_j_1_max__ = num_oaux;
        for (size_t j_1__ = 0; j_1__ < oaux_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oaux_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t inf_aux_raw_j_1_max__ = latent;
        for (size_t j_1__ = 0; j_1__ < inf_aux_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "inf_aux_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_beta_j_1_max__ = (logical_eq(prior_dist, 7) ? sum(num_normals) : K );
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t global_k_0_max__ = hs;
        for (size_t k_0__ = 0; k_0__ < global_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t local_j_1_max__ = K;
        size_t local_k_0_max__ = hs;
        for (size_t j_1__ = 0; j_1__ < local_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < local_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t caux_k_0_max__ = logical_gt(hs, 0);
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "caux" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mix_j_1_max__ = K;
        size_t mix_k_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
        for (size_t j_1__ = 0; j_1__ < mix_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mix_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mix" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t one_over_lambda_k_0_max__ = logical_eq(prior_dist, 6);
        for (size_t k_0__ = 0; k_0__ < one_over_lambda_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_b_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < z_b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_T_j_1_max__ = len_z_T;
        for (size_t j_1__ = 0; j_1__ < z_T_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_j_1_max__ = len_rho;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zeta_j_1_max__ = len_concentration;
        for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = t;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ac_scale_raw_j_1_max__ = ac_nproc;
        for (size_t j_1__ = 0; j_1__ < ac_scale_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ac_scale_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ac_noise_j_1_max__ = ac_q;
        for (size_t j_1__ = 0; j_1__ < ac_noise_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ac_noise" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t obs_ac_scale_raw_j_1_max__ = obs_ac_nproc;
        for (size_t j_1__ = 0; j_1__ < obs_ac_scale_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "obs_ac_scale_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t obs_ac_noise_j_1_max__ = obs_ac_q;
        for (size_t j_1__ = 0; j_1__ < obs_ac_noise_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "obs_ac_noise" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oz_beta_j_1_max__ = K_all;
        for (size_t j_1__ = 0; j_1__ < oz_beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oz_beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seeds_aux_raw_j_1_max__ = hseeds;
        for (size_t j_1__ = 0; j_1__ < seeds_aux_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seeds_aux_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seeds_raw_j_1_max__ = M;
        for (size_t j_1__ = 0; j_1__ < seeds_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seeds_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t infections_raw_j_1_max__ = (latent ? (N - (M * N0)) : 0 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "infections_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t S0_j_1_max__ = (S0_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "S0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t veps_j_1_max__ = (veps_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "veps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t oeta_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "oeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t E_obs_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "E_obs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t oaux_j_1_max__ = num_oaux;
            for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "oaux" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t inf_aux_j_1_max__ = latent;
            for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "inf_aux" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t seeds_aux_j_1_max__ = hseeds;
            for (size_t j_1__ = 0; j_1__ < seeds_aux_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "seeds_aux" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_j_1_max__ = has_intercept;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t seeds_j_1_max__ = M;
            for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "seeds" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Rt_unadj_j_2_max__ = M;
            size_t Rt_unadj_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Rt_unadj" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t load_j_2_max__ = M;
            size_t load_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "load" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t E_infections_j_2_max__ = M;
            size_t E_infections_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "E_infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t infections_j_2_max__ = M;
            size_t infections_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t susc_j_2_max__ = M;
            size_t susc_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "susc" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ac_scale_j_1_max__ = ac_nproc;
            for (size_t j_1__ = 0; j_1__ < ac_scale_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ac_scale" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ac_beta_j_1_max__ = ac_q;
            for (size_t j_1__ = 0; j_1__ < ac_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ac_beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t obs_ac_scale_j_1_max__ = obs_ac_nproc;
            for (size_t j_1__ = 0; j_1__ < obs_ac_scale_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obs_ac_scale" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t obs_ac_beta_j_1_max__ = obs_ac_q;
            for (size_t j_1__ = 0; j_1__ < obs_ac_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obs_ac_beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t obeta_j_1_max__ = K_all;
            for (size_t j_1__ = 0; j_1__ < obeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_L_j_1_max__ = len_theta_L;
            for (size_t j_1__ = 0; j_1__ < theta_L_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_L" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t alpha_k_0_max__ = has_intercept;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t ogamma_j_1_max__ = num_ointercepts;
        for (size_t j_1__ = 0; j_1__ < ogamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ogamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_raw_j_1_max__ = has_intercept;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oaux_raw_j_1_max__ = num_oaux;
        for (size_t j_1__ = 0; j_1__ < oaux_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oaux_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t inf_aux_raw_j_1_max__ = latent;
        for (size_t j_1__ = 0; j_1__ < inf_aux_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "inf_aux_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_beta_j_1_max__ = (logical_eq(prior_dist, 7) ? sum(num_normals) : K );
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t global_k_0_max__ = hs;
        for (size_t k_0__ = 0; k_0__ < global_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t local_j_1_max__ = K;
        size_t local_k_0_max__ = hs;
        for (size_t j_1__ = 0; j_1__ < local_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < local_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t caux_k_0_max__ = logical_gt(hs, 0);
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "caux" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mix_j_1_max__ = K;
        size_t mix_k_0_max__ = (primitive_value(logical_eq(prior_dist, 5)) || primitive_value(logical_eq(prior_dist, 6)));
        for (size_t j_1__ = 0; j_1__ < mix_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mix_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mix" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t one_over_lambda_k_0_max__ = logical_eq(prior_dist, 6);
        for (size_t k_0__ = 0; k_0__ < one_over_lambda_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_b_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < z_b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_T_j_1_max__ = len_z_T;
        for (size_t j_1__ = 0; j_1__ < z_T_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_j_1_max__ = len_rho;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zeta_j_1_max__ = len_concentration;
        for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = t;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ac_scale_raw_j_1_max__ = ac_nproc;
        for (size_t j_1__ = 0; j_1__ < ac_scale_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ac_scale_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ac_noise_j_1_max__ = ac_q;
        for (size_t j_1__ = 0; j_1__ < ac_noise_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ac_noise" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t obs_ac_scale_raw_j_1_max__ = obs_ac_nproc;
        for (size_t j_1__ = 0; j_1__ < obs_ac_scale_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "obs_ac_scale_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t obs_ac_noise_j_1_max__ = obs_ac_q;
        for (size_t j_1__ = 0; j_1__ < obs_ac_noise_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "obs_ac_noise" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oz_beta_j_1_max__ = K_all;
        for (size_t j_1__ = 0; j_1__ < oz_beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oz_beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seeds_aux_raw_j_1_max__ = hseeds;
        for (size_t j_1__ = 0; j_1__ < seeds_aux_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seeds_aux_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t seeds_raw_j_1_max__ = M;
        for (size_t j_1__ = 0; j_1__ < seeds_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seeds_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t infections_raw_j_1_max__ = (latent ? (N - (M * N0)) : 0 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "infections_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t S0_j_1_max__ = (S0_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "S0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t veps_j_1_max__ = (veps_fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "veps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t oeta_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "oeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t E_obs_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "E_obs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t oaux_j_1_max__ = num_oaux;
            for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "oaux" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t inf_aux_j_1_max__ = latent;
            for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "inf_aux" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t seeds_aux_j_1_max__ = hseeds;
            for (size_t j_1__ = 0; j_1__ < seeds_aux_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "seeds_aux" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_j_1_max__ = has_intercept;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t seeds_j_1_max__ = M;
            for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "seeds" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Rt_unadj_j_2_max__ = M;
            size_t Rt_unadj_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Rt_unadj" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t load_j_2_max__ = M;
            size_t load_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "load" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t E_infections_j_2_max__ = M;
            size_t E_infections_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "E_infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t infections_j_2_max__ = M;
            size_t infections_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t susc_j_2_max__ = M;
            size_t susc_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "susc" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ac_scale_j_1_max__ = ac_nproc;
            for (size_t j_1__ = 0; j_1__ < ac_scale_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ac_scale" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ac_beta_j_1_max__ = ac_q;
            for (size_t j_1__ = 0; j_1__ < ac_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ac_beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t obs_ac_scale_j_1_max__ = obs_ac_nproc;
            for (size_t j_1__ = 0; j_1__ < obs_ac_scale_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obs_ac_scale" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t obs_ac_beta_j_1_max__ = obs_ac_q;
            for (size_t j_1__ = 0; j_1__ < obs_ac_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obs_ac_beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t obeta_j_1_max__ = K_all;
            for (size_t j_1__ = 0; j_1__ < obeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_L_j_1_max__ = len_theta_L;
            for (size_t j_1__ = 0; j_1__ < theta_L_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_L" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t alpha_k_0_max__ = has_intercept;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_epidemia_base_namespace::model_epidemia_base stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
