% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pvt_ght}
\alias{pvt_ght}
\title{Google Health Trends data}
\usage{
pvt_ght(auth, locations, epiweeks, query, fetch_args = fetch_args_list())
}
\arguments{
\item{auth}{string. Restricted access key (not the same as API key).}

\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{query}{string. The query to be fetched.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/ght.html}

Estimate of influenza activity based on volume of certain search queries. …
}
\examples{
\dontrun{
pvt_ght(
  auth = Sys.getenv("SECRET_API_AUTH_GHT"),
  locations = "ma",
  epiweeks = epirange(199301, 202304),
  query = "how to get over the flu"
)
}
}
\keyword{endpoint}
