% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{BOOST}
\alias{BOOST}
\title{Implements BOOST SNP-SNP interaction test}
\usage{
BOOST(A, X, Y, ncores = 1)
}
\arguments{
\item{A}{target variant. The SNP A is encoded as 0, 1, 2.}

\item{X}{genotype matrix (excluding A). The only accepted SNP values are
also 0, 1 and 2.}

\item{Y}{observed phenotype. Binary or two-level factor.}

\item{ncores}{number of threads (default 1)}
}
\value{
The interaction statistic between each column in \code{X} and \code{A}
}
\description{
For a pair of SNPs (\eqn{X_1}{X1}, \eqn{X_2}{X2}) and a binary phenotype
\eqn{Y}{Y}, the \code{\link{BOOST}} function computes the ratio of maximum
log-likelihoods for two models: the full model and the main effects model.
Mathematically speaking, the full model is a logistic regression model with
both main effects and interaction terms
\eqn{\left(X_1, X_2, X_1\times X_2\right)}{(X1, X2, X1, X1 x X2)}.
The main effects model is a logistic regression model with only
\eqn{\left(X_1, X_2\right)}{(X1, X2)} as covariates. Since we are
interested in the synergies with a single variant, we do not implement
the initial sure screening stage in BOOST which filters out non-significant
pairs.
}
\examples{
X <- matrix((runif(500, min = 0, max = 1) < 0.5) +
    (runif(500, min = 0, max = 1) < 0.5), nrow = 50)
A <- (runif(50, min = 0, max = 1) < 0.5) + (runif(50, min = 0, max = 1) < 0.5)
Y <- runif(50, min = 0, max = 1) < 1/(1+exp(-.5 * A * X[, 3] + .25 * A * X[, 7]))
BOOST(A, X, Y)

}
\seealso{
The webpage \url{http://bioinformatics.ust.hk/BOOST.html} provides
additional details about the BOOST software
}
