% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{gen_model}
\alias{gen_model}
\title{Samples effect sizes for the disease model}
\usage{
gen_model(nX, nY, nZ12, mean = rep(0, 4), sd = rep(1, 4))
}
\arguments{
\item{nX}{number of SNPs interacting with the target variant}

\item{nY}{number of SNPs with marginal effects}

\item{nZ12}{number of SNP pairs with epistatic effects}

\item{mean}{vector or list of means}

\item{sd}{vector or list of standard deviations}
}
\value{
a list of vectors corresponding to the effect size coefficients.
}
\description{
The generated disease model is the list of effect size coefficients.
The list comprises the following fields: 'syner', 'marg' and 'inter'.
'syner' is itself a list of numeric vectors with two entries named
'A0' and 'A1'. 'A0' refers to the vector of effect sizes when the target
variant \eqn{A = 0}{A = 0}. Similarly, 'A1' refers to the vector of effect
sizes in the case \eqn{A = 1}{A = 1}. The two other entries 'marg' and
'inter' are, respectively, the marginal and epistatic effect sizes. The
effect sizes are independent and normally-distributed. The \code{mean}
parameter is either a list of vectors or a vector of length 4. If
\code{mean} is a vector, then the effect sizes for each type of effects have
the same mean. Otherwise, the corresponding vector in the list
specifies their individual means. The same logic applies to \code{sd}, the
standard deviation parameter. For coherence, the parameters \code{mean} and
\code{sd} are encoded in the same order as the output.
}
\examples{
effect_sizes <- gen_model(nX = 2, nY = 2, nZ12 = 1,
                          mean = rep(1, 4), sd = rep(1, 4))

}
