% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.r
\name{ENgetnodevalue}
\alias{ENgetnodevalue}
\title{Retrieve node parameter value.}
\usage{
ENgetnodevalue(nodeindex, paramcode)
}
\arguments{
\item{nodeindex}{An integer vector specifying the node index.}

\item{paramcode}{An integer or character string, the parameter codes (see below).}
}
\value{
parameter value
}
\description{
\code{ENgetnodevalue} retrieves the values of specific node parameters.
}
\note{
Node indexes are consecutive integers starting from 1.
  
  Node parameter codes consist of the following constants:
  \tabular{lrl}{
  \code{EN_ELEVATION}  \tab 0  \tab Elevation\cr
  \code{EN_BASEDEMAND} \tab 1  \tab Base demand\cr
  \code{EN_PATTERN}    \tab 2  \tab Demand pattern index\cr
  \code{EN_EMITTER}    \tab 3  \tab Emitter coeff.\cr
  \code{EN_INITQUAL}   \tab 4  \tab Initial quality\cr
  \code{EN_SOURCEQUAL} \tab 5  \tab Source quality\cr
  \code{EN_SOURCEPAT}  \tab 6  \tab Source pattern index\cr
  \code{EN_SOURCETYPE} \tab 7  \tab Source type (see note below)\cr
  \code{EN_TANKLEVEL}  \tab 8  \tab Initial water level in tank\cr
  \code{EN_DEMAND}     \tab 9  \tab Actual demand\cr
  \code{EN_HEAD}       \tab 10 \tab Hydraulic head\cr
  \code{EN_PRESSURE}   \tab 11 \tab Pressure\cr
  \code{EN_QUALITY}    \tab 12 \tab Actual quality\cr
  \code{EN_SOURCEMASS} \tab 13 \tab Mass flow rate per minute of a chemical source
  }

  Parameters 9 - 13 (\code{EN_DEMAND} through \code{EN_SOURCEMASS}) are computed values. The
  others are input design parameters.

  Source types are identified with the following constants:
  \tabular{ll}{
   \code{EN_CONCEN}    \tab 0\cr
   \code{EN_MASS}      \tab 1\cr
   \code{EN_SETPOINT}  \tab 2\cr
   \code{EN_FLOWPACED} \tab 3
  }

  See \code{[SOURCES]} for a description of these source types.

  Values are returned in units which depend on the units used for flow rate in the EPANET
  input file (see Units of Measurement).
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetnodevalue(1, "EN_ELEVATION")
ENgetnodevalue(5, "EN_BASEDEMAND")
ENclose()
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___network_info.html}
}
