% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{crawl_envs}
\alias{crawl_envs}
\title{Crawl environments in search of other environments}
\usage{
crawl_envs(env_names, path, env_path_list, envir = .GlobalEnv)
}
\arguments{
\item{env_names}{array with the environment names where the search for environments is wished
(careful: should not contain the environment *objects* but their *names*!).}

\item{path}{array with environment names leading to the current set of environments listed in \code{env_names}.}

\item{env_path_list}{array or list of environment names found so far including their path
(e.g. an element of \code{env_path_list} could be \code{"env1$env2$env"}).
The first time this function is called it should contain the empty array or the empty list.}

\item{envir}{environment used as starting point for the environment search process.}
}
\value{
An array containing the path to each environment found inside the \code{envir} environment
and its sub-environments. This array is concatenated to whatever paths are already listed in the
\code{env_path_list} object passed to the function.
}
\description{
Function that crawls a set of environments to search for environments defined within each of them
}
\details{
This function crawls the environments defined in the \code{envir} environment and any environments
within those environments until no environment has been left without visit, making up an environments tree.
The path to each environment found is stored using the \code{$} notation as in \code{env1$env12$envx}.

Instead of setting the \code{envir} parameter to the root environment where the search should start,
a similar result is obtained by setting the \code{path} variable to the environment chain leading to
the environment that should be passed to \code{envir}, as in e.g. \code{c("env_of_envs", "env11")}.
The difference is that such environment will appear as part of the paths to the environments passed,
and in addition, it is assumed that such environment is an actual environment.
environment given by the chained names passed in \code{path} is an actual environment, and
}
\keyword{internal}

