% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include.R
\name{include}
\alias{include}
\title{Source \R files}
\usage{
include(
  files_andor_dirs,
  envir = parent.frame(),
  chdir = FALSE,
  recursive = FALSE
)
}
\arguments{
\item{files_andor_dirs}{A character vector of filepaths to \R files, or
directories containing R files. Directories are searched for files that end
with extension ".R" or ".r", ignoring those that start with a period (\code{.})
or an underscore (\verb{_}). The found files files from each directory are
sorted by their \code{basename()} before being sourced. Filepaths can be
supplied explicitly to override the default sorting.}

\item{envir}{An \R environment. By default, the current \R evaluation
environment.}

\item{chdir}{logical; if \code{TRUE}, the \R working directory is
    changed to the directory containing \code{file} for evaluating.}

\item{recursive}{whether to search directories recursively for R files.}
}
\value{
The environment \code{envir}, invisibly.
}
\description{
Source \R files
}
\details{
This is a vectorized wrapper around \code{\link[base:sys.source]{base::sys.source}} with some
differences. Notably:
\itemize{
\item \code{envir} defaults to the current frame
\item \code{envir} is returned (invisibly)
\item \code{keep.source} and \code{keep.parse.data} default to
\code{getOption("keep.source")} and \code{getOption("keep.parse.data")} respectively,
instead of \code{getOption("keep.source.pkgs")} and
\code{getOption("keep.parse.data.pkgs")}
\item \code{toplevel.env} is set to \code{getOption("topLevelEnvironment", envir)}. In
other words, if the option \code{topLevelEnvironment} is already set, it is
respected.
}
}
